# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class Follow(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'follower': 'Actor',
        'following': 'Actor',
        'score': 'float',
        'state': 'str',
        'created_at': 'datetime',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'follower': 'follower',
        'following': 'following',
        'score': 'score',
        'state': 'state',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt'
    }

    def __init__(self, id=None, follower=None, following=None, score=None, state=None, created_at=None, updated_at=None, local_vars_configuration=None):  # noqa: E501
        """Follow - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._follower = None
        self._following = None
        self._score = None
        self._state = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if follower is not None:
            self.follower = follower
        if following is not None:
            self.following = following
        if score is not None:
            self.score = score
        if state is not None:
            self.state = state
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def id(self):
        """Gets the id of this Follow.  # noqa: E501


        :return: The id of this Follow.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Follow.


        :param id: The id of this Follow.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def follower(self):
        """Gets the follower of this Follow.  # noqa: E501


        :return: The follower of this Follow.  # noqa: E501
        :rtype: Actor
        """
        return self._follower

    @follower.setter
    def follower(self, follower):
        """Sets the follower of this Follow.


        :param follower: The follower of this Follow.  # noqa: E501
        :type follower: Actor
        """

        self._follower = follower

    @property
    def following(self):
        """Gets the following of this Follow.  # noqa: E501


        :return: The following of this Follow.  # noqa: E501
        :rtype: Actor
        """
        return self._following

    @following.setter
    def following(self, following):
        """Sets the following of this Follow.


        :param following: The following of this Follow.  # noqa: E501
        :type following: Actor
        """

        self._following = following

    @property
    def score(self):
        """Gets the score of this Follow.  # noqa: E501

        score reflecting the reachability of the actor, with steps of `10` and a base score of `1000`.  # noqa: E501

        :return: The score of this Follow.  # noqa: E501
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this Follow.

        score reflecting the reachability of the actor, with steps of `10` and a base score of `1000`.  # noqa: E501

        :param score: The score of this Follow.  # noqa: E501
        :type score: float
        """

        self._score = score

    @property
    def state(self):
        """Gets the state of this Follow.  # noqa: E501


        :return: The state of this Follow.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Follow.


        :param state: The state of this Follow.  # noqa: E501
        :type state: str
        """
        allowed_values = ["pending", "accepted"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def created_at(self):
        """Gets the created_at of this Follow.  # noqa: E501


        :return: The created_at of this Follow.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Follow.


        :param created_at: The created_at of this Follow.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Follow.  # noqa: E501


        :return: The updated_at of this Follow.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Follow.


        :param updated_at: The updated_at of this Follow.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Follow):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Follow):
            return True

        return self.to_dict() != other.to_dict()
