import tsInterfaces = require("./typesystem-interfaces");
export interface IJSONSchemaError {
    entry: any;
    params: any;
    path: string;
    range: tsInterfaces.RangeObject;
    isWarning: boolean;
}
declare class JSONSchemaError implements IJSONSchemaError {
    entry: any;
    params: any;
    path: string;
    range: tsInterfaces.RangeObject;
    isWarning: boolean;
    constructor(entry: any, params: any, path: string, range: tsInterfaces.RangeObject, isWarning: boolean);
}
export interface JSONSchemaObjectValidator {
    validate(content: String): IJSONSchemaError[];
}
declare abstract class RecursiveValidator implements JSONSchemaObjectValidator {
    validate(content: string): IJSONSchemaError[];
    private validateInternal;
    protected createError(entry: any, params: any, rootObj: any, jsonPath: string, isWarning: boolean): JSONSchemaError;
    protected abstract doValidate(obj: any, rootObj: any, jsonPath: string): JSONSchemaError[];
}
export declare class Draft4Validator extends RecursiveValidator {
    protected doValidate(obj: any, rootObj: any, jsonPath: string): JSONSchemaError[];
}
export declare class Draft3Validator extends RecursiveValidator {
    protected doValidate(obj: any, rootObj: any, jsonPath: string): JSONSchemaError[];
}
export {};
