/**
 * SECTION:dummy-persona-store
 * @short_description: A persona store which allows <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link>s to be programmatically created and manipulated, for the purposes of testing the core of libfolks itself. This should not be used in user-visible applications.
 * 
 * <para>There are two sides to this class’ interface: the methods and properties declared by <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>, which form the normal libfolks persona store API; and the mock methods and properties (see for example <link linkend="folks-dummy-persona-store-set-add-persona-from-details-mock"><function>folks_dummy_persona_store_set_add_persona_from_details_mock()</function></link>) which are intended to be used by test driver code to simulate the behaviour of a real backing store. Calls to these mock methods effect state changes in the store which are visible in the normal libfolks API. The <code>update_</code>, <code>register_</code> and <code>unregister_</code> prefixes and the <code>mock</code> suffix are commonly used for backing store methods.</para><para>The main action performed with a dummy persona store is to change its set of personas, adding and removing them dynamically to test client-side behaviour. The client-side APIs (<link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link> and <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link>) should <emphasis>not</emphasis> be used for this. Instead, the mock APIs should be used: <link linkend="folks-dummy-persona-store-freeze-personas-changed"><function>folks_dummy_persona_store_freeze_personas_changed()</function></link>, <link linkend="folks-dummy-persona-store-register-personas"><function>folks_dummy_persona_store_register_personas()</function></link>, <link linkend="folks-dummy-persona-store-unregister-personas"><function>folks_dummy_persona_store_unregister_personas()</function></link> and <link linkend="folks-dummy-persona-store-thaw-personas-changed"><function>folks_dummy_persona_store_thaw_personas_changed()</function></link>. These can be used to build up complex <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link> signal emissions, which are only emitted after the final call to <link linkend="folks-dummy-persona-store-thaw-personas-changed"><function>folks_dummy_persona_store_thaw_personas_changed()</function></link>.</para><para>The API in FolksDummy is unstable and may change wildly. It is designed mostly for use by libfolks unit tests.</para>
 *
 * Since: 0.9.7
 */
/**
 * FOLKS_DUMMY_TYPE_PERSONA_STORE:
 * 
 * The type for <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link>.
 */
/**
 * folks_dummy_persona_store_update_capabilities:
 * @self: the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> instance
 * @can_add_personas: (in): &nbsp;.  <para>whether the store can handle adding personas </para>
 * @can_alias_personas: (in): &nbsp;.  <para>whether the store can handle and update user-specified persona aliases </para>
 * @can_remove_personas: (in): &nbsp;.  <para>whether the store can handle removing personas </para>
 * 
 * Set capabilities of the persona store.
 * 
 * <para>This sets the capabilities of the store, as if they were changed on a backing store somewhere. This is intended to be used for testing code which depends on the values of <link linkend="FolksPersonaStore--can-add-personas"><type>"can-add-personas"</type></link>, <link linkend="FolksPersonaStore--can-alias-personas"><type>"can-alias-personas"</type></link> and <link linkend="FolksPersonaStore--can-remove-personas"><type>"can-remove-personas"</type></link>.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_store_freeze_personas_changed:
 * @self: the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> instance
 * 
 * Freeze persona changes in the store.
 * 
 * <para>This freezes externally-visible changes to the set of personas in the store until <link linkend="folks-dummy-persona-store-thaw-personas-changed"><function>folks_dummy_persona_store_thaw_personas_changed()</function></link> is called, at which point all pending changes are made visible in the <link linkend="FolksPersonaStore--personas"><type>"personas"</type></link> property and by emitting <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link>.</para><para>Calls to <link linkend="folks-dummy-persona-store-freeze-personas-changed"><function>folks_dummy_persona_store_freeze_personas_changed()</function></link> and <link linkend="folks-dummy-persona-store-thaw-personas-changed"><function>folks_dummy_persona_store_thaw_personas_changed()</function></link> must be well-nested. Pending changes will only be committed after the final call to <link linkend="folks-dummy-persona-store-thaw-personas-changed"><function>folks_dummy_persona_store_thaw_personas_changed()</function></link>.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-dummy-persona-store-thaw-personas-changed"><function>folks_dummy_persona_store_thaw_personas_changed()</function></link>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_store_thaw_personas_changed:
 * @self: the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> instance
 * 
 * Thaw persona changes in the store.
 * 
 * <para>This thaws externally-visible changes to the set of personas in the store. If the number of calls to <link linkend="folks-dummy-persona-store-thaw-personas-changed"><function>folks_dummy_persona_store_thaw_personas_changed()</function></link> matches the number of calls to <link linkend="folks-dummy-persona-store-freeze-personas-changed"><function>folks_dummy_persona_store_freeze_personas_changed()</function></link>, all pending changes are committed and made externally-visible.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-dummy-persona-store-freeze-personas-changed"><function>folks_dummy_persona_store_freeze_personas_changed()</function></link>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_store_register_personas:
 * @self: the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> instance
 * @personas: (in): &nbsp;.  <para>set of personas to register </para>
 * 
 * Register new personas with the persona store.
 * 
 * <para>This registers a set of personas as if they had just appeared in the backing store. If the persona store is not frozen (see <link linkend="folks-dummy-persona-store-freeze-personas-changed"><function>folks_dummy_persona_store_freeze_personas_changed()</function></link>) the changes are made externally visible on the store immediately (e.g. in the <link linkend="FolksPersonaStore--personas"><type>"personas"</type></link> property and through a <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link> signal). If the store is frozen, the changes will be pending until the store is next unfrozen.</para><para>All elements in the @personas set be of type <link linkend="FolksDummyPersonaStore--persona-type"><type>"persona-type"</type></link>.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_store_unregister_personas:
 * @self: the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> instance
 * @personas: (in): &nbsp;.  <para>set of personas to unregister </para>
 * 
 * Unregister existing personas with the persona store.
 * 
 * <para>This unregisters a set of personas as if they had just disappeared from the backing store. If the persona store is not frozen (see <link linkend="folks-dummy-persona-store-freeze-personas-changed"><function>folks_dummy_persona_store_freeze_personas_changed()</function></link>) the changes are made externally visible on the store immediately (e.g. in the <link linkend="FolksPersonaStore--personas"><type>"personas"</type></link> property and through a <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link> signal). If the store is frozen, the changes will be pending until the store is next unfrozen.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_store_reach_quiescence:
 * @self: the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> instance
 * 
 * Reach quiescence on the store.
 * 
 * <para>If the <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> method has already been called on the store, this causes the store to signal that it has reached quiescence immediately. If the store has not yet been prepared, this will set a flag to ensure that quiescence is reached as soon as <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> is called.</para><para>This must be called before the store will reach quiescence.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_store_update_is_user_set_default:
 * @self: the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> instance
 * @is_user_set_default: (in): &nbsp;.  <para>new value for the property </para>
 * 
 * Update the <link linkend="FolksPersonaStore--is-user-set-default"><type>"is-user-set-default"</type></link> property.
 * 
 * <para>Backend method for use by test code to simulate a backing-store-driven change in the <link linkend="FolksPersonaStore--is-user-set-default"><type>"is-user-set-default"</type></link> property.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_store_update_trust_level:
 * @self: the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> instance
 * @trust_level: (in): &nbsp;.  <para>new value for the property </para>
 * 
 * Update the <link linkend="FolksPersonaStore--trust-level"><type>"trust-level"</type></link> property.
 * 
 * <para>Backend method for use by test code to simulate a backing-store-driven change in the <link linkend="FolksPersonaStore--trust-level"><type>"trust-level"</type></link> property.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_store_set_add_persona_from_details_mock:
 * @self: the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> instance
 * @mock_target: (allow-none) (closure): user data to pass to @mock
 * @mock: &nbsp;
 * 
 * Mock function for <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link>.
 * 
 * <para>This function is called whenever this store&apos;s <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link> method is called. It allows the caller to determine whether adding the given persona should fail, by throwing an error from this mock function. If no error is thrown from this function, adding the given persona will succeed. This is useful for testing error handling of calls to <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link>.</para><para>The value returned by this function gives a delay which is imposed for completion of the <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link> call. Negative or zero delays result in completion in an idle callback, and positive delays result in completion after that many milliseconds.</para><para>If this is <code>null</code>, all calls to <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link> will succeed.</para><para>This mock function may be changed at any time; changes will take effect for the next call to <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link>.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_store_set_remove_persona_mock:
 * @self: the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> instance
 * @mock_target: (allow-none) (closure): user data to pass to @mock
 * @mock: &nbsp;
 * 
 * Mock function for <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link>.
 * 
 * <para>This function is called whenever this store&apos;s <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link> method is called. It allows the caller to determine whether removing the given persona should fail, by throwing an error from this mock function. If no error is thrown from this function, removing the given persona will succeed. This is useful for testing error handling of calls to <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link>.</para><para>See <link linkend="folks-dummy-persona-store-set-add-persona-from-details-mock"><function>folks_dummy_persona_store_set_add_persona_from_details_mock()</function></link>.</para><para>This mock function may be changed at any time; changes will take effect for the next call to <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link>.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_store_set_prepare_mock:
 * @self: the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> instance
 * @mock_target: (allow-none) (closure): user data to pass to @mock
 * @mock: &nbsp;
 * 
 * Mock function for <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link>.
 * 
 * <para>This function is called whenever this store&apos;s <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> method is called on an unprepared store. It allows the caller to determine whether preparing the store should fail, by throwing an error from this mock function. If no error is thrown from this function, preparing the store will succeed (and all future calls to <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> will return immediately without calling this mock function). This is useful for testing error handling of calls to <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link>.</para><para>See <link linkend="folks-dummy-persona-store-set-add-persona-from-details-mock"><function>folks_dummy_persona_store_set_add_persona_from_details_mock()</function></link>.</para><para>This mock function may be changed at any time; changes will take effect for the next call to <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link>.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_store_new:
 * @id: (in): &nbsp;.  <para>The new store&apos;s ID. </para>
 * @display_name: (in): &nbsp;.  <para>The new store&apos;s display name. </para>
 * @always_writeable_properties: (in) (array length=always_writeable_properties_length1): &nbsp;.  <para>The set of always writeable properties. </para>
 * @always_writeable_properties_length1: length of the @always_writeable_properties array
 * 
 * Create a new persona store.
 * 
 * <para>This store will have no personas to begin with; use <link linkend="folks-dummy-persona-store-register-personas"><function>folks_dummy_persona_store_register_personas()</function></link> to add some, then call <link linkend="folks-dummy-persona-store-reach-quiescence"><function>folks_dummy_persona_store_reach_quiescence()</function></link> to signal the store reaching quiescence.</para>
 *
 * Since: 0.9.7
 */
/**
 * FolksDummyPersonaStore:persona-type:
 * 
 * Type of programmatically created personas.
 * 
 * <para>This is the type used to create new personas when <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link> is called. It must be a subtype of <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link>.</para><para>This may be modified at any time, with modifications taking effect for the next call to <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link> or <link linkend="folks-dummy-persona-store-register-personas"><function>folks_dummy_persona_store_register_personas()</function></link>.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_store_get_persona_type:
 * @self: the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksDummyPersonaStore--persona-type"><type>"persona-type"</type></link> property.
 * 
 * Type of programmatically created personas.
 * 
 * <para>This is the type used to create new personas when <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link> is called. It must be a subtype of <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link>.</para><para>This may be modified at any time, with modifications taking effect for the next call to <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link> or <link linkend="folks-dummy-persona-store-register-personas"><function>folks_dummy_persona_store_register_personas()</function></link>.</para>
 * 
 * Returns: the value of the <link linkend="FolksDummyPersonaStore--persona-type"><type>"persona-type"</type></link> property
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_persona_store_set_persona_type:
 * @self: the <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksDummyPersonaStore--persona-type"><type>"persona-type"</type></link> property
 * 
 * Set the value of the <link linkend="FolksDummyPersonaStore--persona-type"><type>"persona-type"</type></link> property to @value.
 * 
 * Type of programmatically created personas.
 * 
 * <para>This is the type used to create new personas when <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link> is called. It must be a subtype of <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link>.</para><para>This may be modified at any time, with modifications taking effect for the next call to <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link> or <link linkend="folks-dummy-persona-store-register-personas"><function>folks_dummy_persona_store_register_personas()</function></link>.</para>
 *
 * Since: 0.9.7
 */
/**
 * FolksDummyPersonaStoreAddPersonaFromDetailsMock:
 * @persona: (in): &nbsp;.  <para>the persona being added to the store, as constructed from the details passed to <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link>. </para>
 * @error: (error-domains FolksPersonaStoreError): location to store the error occurring, or %NULL to ignore
 * @user_data: (closure): data to pass to the delegate function
 * 
 * Type of a mock function for <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link>.
 * 
 * <para>See <link linkend="folks-dummy-persona-store-set-add-persona-from-details-mock"><function>folks_dummy_persona_store_set_add_persona_from_details_mock()</function></link>.</para>
 * <para><link linkend="FolksPersonaStoreError"><type>FolksPersonaStoreError</type></link> will be returned in @error <para>to be thrown from <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link> </para></para>
 * 
 * Returns: <para>delay to apply to the add persona operation (negative delays complete synchronously; zero delays complete in an idle callback; positive delays complete after that many milliseconds) </para>
 *
 * Since: 0.9.7
 */
/**
 * FolksDummyPersonaStoreRemovePersonaMock:
 * @persona: (in): &nbsp;.  <para>the persona being removed from the store </para>
 * @error: (error-domains FolksPersonaStoreError): location to store the error occurring, or %NULL to ignore
 * @user_data: (closure): data to pass to the delegate function
 * 
 * Type of a mock function for <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link>.
 * 
 * <para>See <link linkend="folks-dummy-persona-store-set-remove-persona-mock"><function>folks_dummy_persona_store_set_remove_persona_mock()</function></link>.</para>
 * <para><link linkend="FolksPersonaStoreError"><type>FolksPersonaStoreError</type></link> will be returned in @error <para>to be thrown from <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link> </para></para>
 * 
 * Returns: <para>delay to apply to the remove persona operation (negative and zero delays complete in an idle callback; positive delays complete after that many milliseconds) </para>
 *
 * Since: 0.9.7
 */
/**
 * FolksDummyPersonaStorePrepareMock:
 * @error: (error-domains FolksPersonaStoreError): location to store the error occurring, or %NULL to ignore
 * @user_data: (closure): data to pass to the delegate function
 * 
 * Type of a mock function for <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link>.
 * 
 * <para>See <link linkend="folks-dummy-persona-store-set-prepare-mock"><function>folks_dummy_persona_store_set_prepare_mock()</function></link>.</para>
 * <para><link linkend="FolksPersonaStoreError"><type>FolksPersonaStoreError</type></link> will be returned in @error <para>to be thrown from <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> </para></para>
 * 
 * Returns: <para>delay to apply to the prepare operation (negative and zero delays complete in an idle callback; positive delays complete after that many milliseconds) </para>
 *
 * Since: 0.9.7
 */
/**
 * FolksDummyPersonaStore:
 * 
 * A persona store which allows <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link>s to be programmatically created and manipulated, for the purposes of testing the core of libfolks itself. This should not be used in user-visible applications.
 * 
 * <para>There are two sides to this class’ interface: the methods and properties declared by <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>, which form the normal libfolks persona store API; and the mock methods and properties (see for example <link linkend="folks-dummy-persona-store-set-add-persona-from-details-mock"><function>folks_dummy_persona_store_set_add_persona_from_details_mock()</function></link>) which are intended to be used by test driver code to simulate the behaviour of a real backing store. Calls to these mock methods effect state changes in the store which are visible in the normal libfolks API. The <code>update_</code>, <code>register_</code> and <code>unregister_</code> prefixes and the <code>mock</code> suffix are commonly used for backing store methods.</para><para>The main action performed with a dummy persona store is to change its set of personas, adding and removing them dynamically to test client-side behaviour. The client-side APIs (<link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link> and <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link>) should <emphasis>not</emphasis> be used for this. Instead, the mock APIs should be used: <link linkend="folks-dummy-persona-store-freeze-personas-changed"><function>folks_dummy_persona_store_freeze_personas_changed()</function></link>, <link linkend="folks-dummy-persona-store-register-personas"><function>folks_dummy_persona_store_register_personas()</function></link>, <link linkend="folks-dummy-persona-store-unregister-personas"><function>folks_dummy_persona_store_unregister_personas()</function></link> and <link linkend="folks-dummy-persona-store-thaw-personas-changed"><function>folks_dummy_persona_store_thaw_personas_changed()</function></link>. These can be used to build up complex <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link> signal emissions, which are only emitted after the final call to <link linkend="folks-dummy-persona-store-thaw-personas-changed"><function>folks_dummy_persona_store_thaw_personas_changed()</function></link>.</para><para>The API in FolksDummy is unstable and may change wildly. It is designed mostly for use by libfolks unit tests.</para>
 *
 * Since: 0.9.7
 */
/**
 * FolksDummyPersonaStoreClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-DUMMY-TYPE-PERSONA-STORE:CAPS"><literal>FOLKS_DUMMY_TYPE_PERSONA_STORE</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
