/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.freeplane.core.extension.ExtensionContainer;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.OptionPanelController;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.IValidator;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.AController;
import org.freeplane.features.mode.FreeScrollAction;
import org.freeplane.features.mode.FreeplaneActions;
import org.freeplane.features.mode.IControllerExecuteExtension;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.MoveSelectedNodeAction;
import org.freeplane.features.mode.MoveToRootAction;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.main.application.ApplicationLifecycleListener;

public class Controller
extends AController
implements FreeplaneActions,
IMapLifeCycleListener {
    private final ExtensionContainer extensionContainer;
    private ModeController modeController;
    private ModeController modeController4build;
    private final Map<String, ModeController> modeControllers = new LinkedHashMap<String, ModeController>();
    private ViewController viewController;
    private final ResourceController resourceController;
    private final List<IValidator> optionValidators = new ArrayList<IValidator>();
    private final OptionPanelController optionPanelController;
    private IMapViewManager mapViewManager;
    private List<ApplicationLifecycleListener> applicationLifecycleListeners = new ArrayList<ApplicationLifecycleListener>(0);
    private final Collection<IMapLifeCycleListener> mapLifeCycleListeners;
    private static ThreadLocal<Controller> threadController = new ThreadLocal();
    private static Controller currentController = null;

    public Controller(ResourceController resourceController) {
        if (currentController == null) {
            currentController = this;
        }
        this.mapLifeCycleListeners = new LinkedList<IMapLifeCycleListener>();
        this.resourceController = resourceController;
        this.optionPanelController = new OptionPanelController();
        this.extensionContainer = new ExtensionContainer(new HashMap<Class<? extends IExtension>, IExtension>());
        this.addAction(new MoveToRootAction());
        Arrays.stream(IMapSelection.NodePosition.values()).forEach(p -> this.addAction(new MoveSelectedNodeAction((IMapSelection.NodePosition)((Object)p))));
        Arrays.stream(FreeScrollAction.Direction.values()).forEach(d -> this.addAction(new FreeScrollAction((FreeScrollAction.Direction)((Object)d))));
    }

    public void addExtension(Class<? extends IExtension> clazz, IExtension extension) {
        this.extensionContainer.addExtension(clazz, extension);
    }

    public void addModeController(ModeController modeController) {
        this.modeControllers.put(modeController.getModeName(), modeController);
    }

    public void addMapLifeCycleListener(IMapLifeCycleListener listener) {
        this.mapLifeCycleListeners.add(listener);
    }

    public void removeMapLifeCycleListener(IMapLifeCycleListener listener) {
        this.mapLifeCycleListeners.remove(listener);
    }

    public void close() {
        this.getMapViewManager().close();
    }

    public <T extends IExtension> T getExtension(Class<T> clazz) {
        return this.extensionContainer.getExtension(clazz);
    }

    public MapModel getMap() {
        return this.getMapViewManager().getMap();
    }

    public IMapViewManager getMapViewManager() {
        return this.mapViewManager;
    }

    public void setMapViewManager(IMapViewManager mapViewManager) {
        this.mapViewManager = mapViewManager;
    }

    public ModeController getModeController() {
        return this.modeController4build != null ? this.modeController4build : this.modeController;
    }

    public ModeController getModeController(String modeName) {
        return this.modeControllers.get(modeName);
    }

    public Set<String> getModes() {
        return this.modeControllers.keySet();
    }

    public IMapSelection getSelection() {
        return this.getMapViewManager().getMapSelection();
    }

    public ViewController getViewController() {
        return this.viewController;
    }

    public ExecutorService getMainThreadExecutorService() {
        return this.viewController.getMainThreadExecutorService();
    }

    public void quit() {
        if (this.shutdown()) {
            System.exit(0);
        }
    }

    public void selectMode(ModeController newModeController) {
        this.modeController4build = null;
        ModeController oldModeController = this.modeController;
        if (oldModeController == newModeController) {
            return;
        }
        if (oldModeController != null) {
            oldModeController.shutdown();
        }
        LogUtils.info("requesting mode: " + newModeController.getModeName());
        this.modeController = newModeController;
        this.viewController.selectMode(oldModeController, newModeController);
        newModeController.startup();
        this.getMapViewManager().changeToMode(newModeController.getModeName());
    }

    public void selectMode(String modeName) {
        ModeController newModeController = this.modeControllers.get(modeName);
        if (newModeController == null) {
            return;
        }
        if (this.modeController == newModeController) {
            return;
        }
        this.selectMode(newModeController);
    }

    public void setViewController(ViewController viewController) {
        this.viewController = viewController;
    }

    public boolean shutdown() {
        this.viewController.saveProperties();
        if (!this.viewController.quit()) {
            return false;
        }
        this.mapViewManager.getMaps().values().forEach(map -> map.releaseResources());
        try {
            ResourceController.getResourceController().saveProperties();
            this.extensionContainer.getExtensions().clear();
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
        return true;
    }

    public static void exec(String string) throws IOException {
        Controller.exec(string, false);
    }

    public static void exec(String string, boolean waitFor) throws IOException {
        IControllerExecuteExtension ext = Controller.getCurrentController().getExtension(IControllerExecuteExtension.class);
        if (ext == null) {
            ext = Controller.getCurrentController().getDefaultExecuter();
        }
        ext.exec(string, waitFor);
    }

    public static void exec(String[] command) throws IOException {
        Controller.exec(command, false);
    }

    public static void exec(String[] command, boolean waitFor) throws IOException {
        IControllerExecuteExtension ext = Controller.getCurrentController().getExtension(IControllerExecuteExtension.class);
        if (ext == null) {
            ext = Controller.getCurrentController().getDefaultExecuter();
        }
        ext.exec(command, waitFor);
    }

    private IControllerExecuteExtension getDefaultExecuter() {
        return new IControllerExecuteExtension(){

            @Override
            public void exec(String[] command, boolean waitFor) throws IOException {
                LogUtils.info("execute " + Arrays.toString(command));
                Process proc = Runtime.getRuntime().exec(command);
                this.waiting(waitFor, proc);
            }

            @Override
            public void exec(String string, boolean waitFor) throws IOException {
                LogUtils.info("execute " + string);
                Process proc = Runtime.getRuntime().exec(string);
                this.waiting(waitFor, proc);
            }

            private void waiting(boolean waitFor, Process proc) throws IOException {
                if (waitFor) {
                    try {
                        proc.waitFor();
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
            }
        };
    }

    public static Controller getCurrentController() {
        Controller controller = threadController.get();
        return controller != null ? controller : currentController;
    }

    public static void setCurrentController(Controller controller) {
        currentController = controller;
    }

    public static ModeController getCurrentModeController() {
        return Controller.getCurrentController().getModeController();
    }

    public void selectModeForBuild(ModeController modeController4build) {
        this.modeController4build = modeController4build;
    }

    public ResourceController getResourceController() {
        return this.resourceController;
    }

    public void addOptionValidator(IValidator validator) {
        this.optionValidators.add(validator);
    }

    public List<IValidator> getOptionValidators() {
        return this.optionValidators;
    }

    public OptionPanelController getOptionPanelController() {
        return this.optionPanelController;
    }

    public void addApplicationLifecycleListener(ApplicationLifecycleListener applicationLifecycleListener) {
        this.applicationLifecycleListeners.add(applicationLifecycleListener);
    }

    public void fireMapCreated(MapModel map) {
        IMapLifeCycleListener[] list;
        for (IMapLifeCycleListener next : list = this.mapLifeCycleListeners.toArray(new IMapLifeCycleListener[0])) {
            next.onCreate(map);
        }
    }

    protected void fireMapRemoved(MapModel map) {
        IMapLifeCycleListener[] list;
        for (IMapLifeCycleListener next : list = this.mapLifeCycleListeners.toArray(new IMapLifeCycleListener[0])) {
            next.onRemove(map);
        }
    }

    @Override
    public void onCreate(MapModel map) {
        this.fireMapCreated(map);
    }

    @Override
    public void onRemove(MapModel map) {
        this.fireMapRemoved(map);
    }

    public void fireStartupFinished() {
        for (ApplicationLifecycleListener listener : this.applicationLifecycleListeners) {
            listener.onStartupFinished();
        }
    }

    public void fireApplicationStopped() {
        for (ApplicationLifecycleListener listener : this.applicationLifecycleListeners) {
            listener.onApplicationStopped();
        }
    }
}

