/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.config;

import java.awt.Color;
import tim.prune.config.ColourUtils;

public class ColourScheme {
    private final Color[] _colours = new Color[8];
    private static final Color[] DEFAULT_COLOURS = new Color[]{Color.WHITE, Color.BLUE, Color.GREEN, Color.BLACK, Color.RED, Color.ORANGE, Color.BLACK, Color.GRAY};
    public static final int IDX_BACKGROUND = 0;
    public static final int IDX_POINT = 1;
    public static final int IDX_SELECTION = 2;
    public static final int IDX_TEXT = 3;
    public static final int IDX_PRIMARY = 4;
    public static final int IDX_SECONDARY = 5;
    public static final int IDX_BORDERS = 6;
    public static final int IDX_LINES = 7;
    private static final int NUM_COLOURS = 8;

    public void loadFromHex(String string) {
        if (string != null && string.length() > 5) {
            String[] stringArray = string.split(",");
            int n = Math.min(stringArray.length, 8);
            int n2 = 0;
            while (n2 < n) {
                this._colours[n2] = ColourUtils.colourFromHex(stringArray[n2]);
                ++n2;
            }
        }
    }

    public Color getColour(int n) {
        assert (n >= 0 && n < 8);
        Color color = this._colours[n];
        return color != null ? color : DEFAULT_COLOURS[n];
    }

    public static Color getDefaultColour(int n) {
        assert (n >= 0 && n < 8);
        return DEFAULT_COLOURS[n];
    }

    public void setColour(int n, Color color) {
        assert (n >= 0 && n < 8);
        this._colours[n] = color;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < 8) {
            stringBuilder.append(ColourUtils.makeHexCode(this.getColour(n)));
            stringBuilder.append(',');
            ++n;
        }
        return stringBuilder.toString();
    }
}

