/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.io.importexport.OsmImporter;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.GeoJSONReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.I18n;

public class GeoJSONImporter
extends OsmImporter {
    private static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions("geojson", "geojson", I18n.tr("GeoJSON file", new Object[0]) + " (*.geojson, *.geojson.gz, *.geojson.bz2, *.geojson.xz, *.geojson.zip)", ExtensionFileFilter.AddArchiveExtension.NONE, Arrays.asList("gz", "bz", "bz2", "xz", "zip"));

    public GeoJSONImporter() {
        super(FILE_FILTER);
    }

    @Deprecated
    public DataSet parseDataSet(String source) throws IOException, IllegalDataException {
        try (CachedFile cf = new CachedFile(source);){
            InputStream fileInputStream = Compression.getUncompressedFileInputStream(cf.getFile());
            DataSet dataSet = this.parseDataSet(fileInputStream, NullProgressMonitor.INSTANCE);
            return dataSet;
        }
    }

    @Override
    protected DataSet parseDataSet(InputStream in, ProgressMonitor progressMonitor) throws IllegalDataException {
        return GeoJSONReader.parseDataSet(in, progressMonitor);
    }
}

