/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.AbstractAlgorithmConstraints;
import org.bouncycastle.jsse.provider.DisabledAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ProvAlgorithmDecomposer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private static final Logger LOG = Logger.getLogger(ProvAlgorithmConstraints.class.getName());
    private static final String PROPERTY_CERTPATH_DISABLED_ALGORITHMS = "jdk.certpath.disabledAlgorithms";
    private static final String PROPERTY_TLS_DISABLED_ALGORITHMS = "jdk.tls.disabledAlgorithms";
    private static final String DEFAULT_CERTPATH_DISABLED_ALGORITHMS = "MD2, MD5, SHA1 jdkCA & usage TLSServer, RSA keySize < 1024, DSA keySize < 1024, EC keySize < 224";
    private static final String DEFAULT_TLS_DISABLED_ALGORITHMS = "SSLv3, TLSv1, TLSv1.1, RC4, DES, MD5withRSA, DH keySize < 1024, EC keySize < 224, 3DES_EDE_CBC, anon, NULL";
    private static final DisabledAlgorithmConstraints provTlsDisabledAlgorithms = DisabledAlgorithmConstraints.create(ProvAlgorithmDecomposer.INSTANCE_TLS, "jdk.tls.disabledAlgorithms", "SSLv3, TLSv1, TLSv1.1, RC4, DES, MD5withRSA, DH keySize < 1024, EC keySize < 224, 3DES_EDE_CBC, anon, NULL");
    private static final DisabledAlgorithmConstraints provX509DisabledAlgorithms = DisabledAlgorithmConstraints.create(ProvAlgorithmDecomposer.INSTANCE_X509, "jdk.certpath.disabledAlgorithms", "MD2, MD5, SHA1 jdkCA & usage TLSServer, RSA keySize < 1024, DSA keySize < 1024, EC keySize < 224");
    static final ProvAlgorithmConstraints DEFAULT = new ProvAlgorithmConstraints(null, true);
    static final ProvAlgorithmConstraints DEFAULT_TLS_ONLY = new ProvAlgorithmConstraints(null, false);
    private final BCAlgorithmConstraints configAlgorithmConstraints;
    private final Set<String> supportedSignatureAlgorithms;
    private final boolean enableX509Constraints;

    ProvAlgorithmConstraints(BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl) {
        super(null);
        this.configAlgorithmConstraints = bCAlgorithmConstraints;
        this.supportedSignatureAlgorithms = null;
        this.enableX509Constraints = bl;
    }

    ProvAlgorithmConstraints(BCAlgorithmConstraints bCAlgorithmConstraints, String[] stringArray, boolean bl) {
        super(null);
        this.configAlgorithmConstraints = bCAlgorithmConstraints;
        this.supportedSignatureAlgorithms = ProvAlgorithmConstraints.asUnmodifiableSet(stringArray);
        this.enableX509Constraints = bl;
    }

    @Override
    public boolean permits(Set<BCCryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        this.checkPrimitives(set);
        this.checkAlgorithmName(string);
        if (null != this.supportedSignatureAlgorithms) {
            String string2 = string;
            string = this.getAlgorithm(string2);
            if (!this.isSupportedSignatureAlgorithm(string2)) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Signature algorithm '" + string2 + "' not in supported signature algorithms");
                }
                return false;
            }
        }
        if (null != this.configAlgorithmConstraints && !this.configAlgorithmConstraints.permits(set, string, algorithmParameters)) {
            return false;
        }
        if (null != provTlsDisabledAlgorithms && !provTlsDisabledAlgorithms.permits(set, string, algorithmParameters)) {
            return false;
        }
        return !this.enableX509Constraints || null == provX509DisabledAlgorithms || provX509DisabledAlgorithms.permits(set, string, algorithmParameters);
    }

    @Override
    public boolean permits(Set<BCCryptoPrimitive> set, Key key) {
        this.checkPrimitives(set);
        this.checkKey(key);
        if (null != this.configAlgorithmConstraints && !this.configAlgorithmConstraints.permits(set, key)) {
            return false;
        }
        if (null != provTlsDisabledAlgorithms && !provTlsDisabledAlgorithms.permits(set, key)) {
            return false;
        }
        return !this.enableX509Constraints || null == provX509DisabledAlgorithms || provX509DisabledAlgorithms.permits(set, key);
    }

    @Override
    public boolean permits(Set<BCCryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        this.checkPrimitives(set);
        this.checkAlgorithmName(string);
        this.checkKey(key);
        if (null != this.supportedSignatureAlgorithms) {
            String string2 = string;
            string = this.getAlgorithm(string2);
            if (!this.isSupportedSignatureAlgorithm(string2)) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Signature algorithm '" + string2 + "' not in supported signature algorithms");
                }
                return false;
            }
        }
        if (null != this.configAlgorithmConstraints && !this.configAlgorithmConstraints.permits(set, string, key, algorithmParameters)) {
            return false;
        }
        if (null != provTlsDisabledAlgorithms && !provTlsDisabledAlgorithms.permits(set, string, key, algorithmParameters)) {
            return false;
        }
        return !this.enableX509Constraints || null == provX509DisabledAlgorithms || provX509DisabledAlgorithms.permits(set, string, key, algorithmParameters);
    }

    private String getAlgorithm(String string) {
        int n = string.indexOf(58);
        return n < 0 ? string : string.substring(0, n);
    }

    private boolean isSupportedSignatureAlgorithm(String string) {
        return this.containsIgnoreCase(this.supportedSignatureAlgorithms, string);
    }
}

