/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.state;

import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateObserver;
import org.opensearch.cluster.NotClusterManagerException;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.node.NodeClosedException;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportClusterStateAction
extends TransportClusterManagerNodeReadAction<ClusterStateRequest, ClusterStateResponse> {
    private final Logger logger = LogManager.getLogger(this.getClass());

    @Inject
    public TransportClusterStateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:monitor/state", false, transportService, clusterService, threadPool, actionFilters, ClusterStateRequest::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterStateResponse read(StreamInput in) throws IOException {
        return new ClusterStateResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterStateRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected void clusterManagerOperation(final ClusterStateRequest request, final ClusterState state, final ActionListener<ClusterStateResponse> listener) throws IOException {
        Predicate<ClusterState> acceptableClusterStateOrNotMasterPredicate;
        final Predicate<ClusterState> acceptableClusterStatePredicate = request.waitForMetadataVersion() == null ? clusterState -> true : clusterState -> clusterState.metadata().version() >= request.waitForMetadataVersion();
        Predicate<ClusterState> predicate = acceptableClusterStateOrNotMasterPredicate = request.local() ? acceptableClusterStatePredicate : acceptableClusterStatePredicate.or(clusterState -> !clusterState.nodes().isLocalNodeElectedClusterManager());
        if (acceptableClusterStatePredicate.test(state)) {
            ActionListener.completeWith(listener, () -> this.buildResponse(request, state));
        } else {
            assert (!acceptableClusterStateOrNotMasterPredicate.test(state));
            new ClusterStateObserver(state, this.clusterService, request.waitForTimeout(), this.logger, this.threadPool.getThreadContext()).waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState newState) {
                    if (acceptableClusterStatePredicate.test(newState)) {
                        ActionListener.completeWith((ActionListener)listener, () -> TransportClusterStateAction.this.buildResponse(request, newState));
                    } else {
                        listener.onFailure((Exception)((Object)new NotClusterManagerException("cluster-manager stepped down waiting for metadata version " + request.waitForMetadataVersion())));
                    }
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure((Exception)((Object)new NodeClosedException(TransportClusterStateAction.this.clusterService.localNode())));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    try {
                        listener.onResponse((Object)new ClusterStateResponse(state.getClusterName(), null, true));
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }
            }, acceptableClusterStateOrNotMasterPredicate);
        }
    }

    private ClusterStateResponse buildResponse(ClusterStateRequest request, ClusterState currentState) {
        String[] indices;
        this.logger.trace("Serving cluster state request using version {}", (Object)currentState.version());
        ClusterState.Builder builder = ClusterState.builder(currentState.getClusterName());
        builder.version(currentState.version());
        builder.stateUUID(currentState.stateUUID());
        if (request.nodes()) {
            builder.nodes(currentState.nodes());
        }
        if (request.routingTable()) {
            if (request.indices().length > 0) {
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
                for (String filteredIndex : indices = this.indexNameExpressionResolver.concreteIndexNames(currentState, request)) {
                    if (!currentState.routingTable().getIndicesRouting().containsKey(filteredIndex)) continue;
                    routingTableBuilder.add(currentState.routingTable().getIndicesRouting().get(filteredIndex));
                }
                builder.routingTable(routingTableBuilder.build());
            } else {
                builder.routingTable(currentState.routingTable());
            }
        }
        if (request.blocks()) {
            builder.blocks(currentState.blocks());
        }
        Metadata.Builder mdBuilder = Metadata.builder();
        mdBuilder.clusterUUID(currentState.metadata().clusterUUID());
        mdBuilder.coordinationMetadata(currentState.coordinationMetadata());
        if (request.metadata()) {
            if (request.indices().length > 0) {
                mdBuilder.version(currentState.metadata().version());
                for (String filteredIndex : indices = this.indexNameExpressionResolver.concreteIndexNames(currentState, request)) {
                    IndexMetadata indexMetadata = currentState.metadata().index(filteredIndex);
                    if (indexMetadata == null) continue;
                    mdBuilder.put(indexMetadata, false);
                }
            } else {
                mdBuilder = Metadata.builder(currentState.metadata());
            }
            for (Map.Entry<String, ToXContentFragment> entry : currentState.metadata().customs().entrySet()) {
                if (((Metadata.Custom)entry.getValue()).context().contains((Object)Metadata.XContentContext.API)) continue;
                mdBuilder.removeCustom(entry.getKey());
            }
        }
        builder.metadata(mdBuilder);
        if (request.customs()) {
            for (Map.Entry<String, ToXContentFragment> entry : currentState.customs().entrySet()) {
                if (((ClusterState.Custom)entry.getValue()).isPrivate()) continue;
                builder.putCustom(entry.getKey(), (ClusterState.Custom)entry.getValue());
            }
        }
        return new ClusterStateResponse(currentState.getClusterName(), builder.build(), false);
    }

    static {
        String property = System.getProperty("opensearch.cluster_state.size");
        if (property != null) {
            throw new IllegalArgumentException("opensearch.cluster_state.size is no longer respected but was [" + property + "]");
        }
    }
}

