/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.query;

import org.apache.lucene.search.Query;
import org.opensearch.search.profile.AbstractInternalProfileTree;
import org.opensearch.search.profile.ContextualProfileBreakdown;
import org.opensearch.search.profile.query.QueryTimingType;

public abstract class AbstractQueryProfileTree
extends AbstractInternalProfileTree<ContextualProfileBreakdown<QueryTimingType>, Query> {
    private long rewriteTime;
    private long rewriteScratch;

    @Override
    protected String getTypeFromElement(Query query) {
        if (query.getClass().getSimpleName().isEmpty()) {
            return query.getClass().getSuperclass().getSimpleName();
        }
        return query.getClass().getSimpleName();
    }

    @Override
    protected String getDescriptionFromElement(Query query) {
        return query.toString();
    }

    public void startRewriteTime() {
        assert (this.rewriteScratch == 0L);
        this.rewriteScratch = System.nanoTime();
    }

    public void stopAndAddRewriteTime() {
        long time = Math.max(1L, System.nanoTime() - this.rewriteScratch);
        this.rewriteTime += time;
        this.rewriteScratch = 0L;
    }

    public long getRewriteTime() {
        return this.rewriteTime;
    }
}

