"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BasicAuthentication = void 0;

var _routes = require("./routes");

var _authentication_type = require("../authentication_type");

var _common = require("../../../../common");

var _next_url = require("../../../utils/next_url");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BasicAuthentication extends _authentication_type.AuthenticationType {
  constructor(config, sessionStorageFactory, router, esClient, coreSetup, logger) {
    super(config, sessionStorageFactory, router, esClient, coreSetup, logger);

    _defineProperty(this, "type", _common.AuthType.BASIC);
  }

  async init() {
    const routes = new _routes.BasicAuthRoutes(this.router, this.config, this.sessionStorageFactory, this.securityClient, this.coreSetup);
    routes.setupRoutes();
  } // override functions inherited from AuthenticationType


  requestIncludesAuthInfo(request) {
    return request.headers[_common.AUTH_HEADER_NAME] ? true : false;
  }

  async getAdditionalAuthHeader(request) {
    return {};
  }

  getCookie(request, authInfo) {
    if (this.config.auth.anonymous_auth_enabled && authInfo.user_name === _common.OPENDISTRO_SECURITY_ANONYMOUS) {
      return {
        username: authInfo.user_name,
        authType: this.type,
        expiryTime: Date.now() + this.config.session.ttl,
        isAnonymousAuth: true
      };
    }

    return {
      username: authInfo.user_name,
      credentials: {
        authHeaderValue: request.headers[_common.AUTH_HEADER_NAME]
      },
      authType: this.type,
      expiryTime: Date.now() + this.config.session.ttl
    };
  }

  async isValidCookie(cookie) {
    var _cookie$credentials;

    return cookie.authType === this.type && cookie.expiryTime && (cookie.username && ((_cookie$credentials = cookie.credentials) === null || _cookie$credentials === void 0 ? void 0 : _cookie$credentials.authHeaderValue) || this.config.auth.anonymous_auth_enabled && cookie.isAnonymousAuth);
  }

  handleUnauthedRequest(request, response, toolkit) {
    if (this.isPageRequest(request)) {
      const nextUrlParam = (0, _next_url.composeNextUrlQueryParam)(request, this.coreSetup.http.basePath.serverBasePath);

      if (this.config.auth.anonymous_auth_enabled) {
        const redirectLocation = `${this.coreSetup.http.basePath.serverBasePath}${_common.ANONYMOUS_AUTH_LOGIN}?${nextUrlParam}`;
        return response.redirected({
          headers: {
            location: `${redirectLocation}`
          }
        });
      } else {
        const redirectLocation = `${this.coreSetup.http.basePath.serverBasePath}${_common.LOGIN_PAGE_URI}?${nextUrlParam}`;
        return response.redirected({
          headers: {
            location: `${redirectLocation}`
          }
        });
      }
    } else {
      return response.unauthorized({
        body: `Authentication required`
      });
    }
  }

  buildAuthHeaderFromCookie(cookie) {
    var _cookie$credentials2;

    if (this.config.auth.anonymous_auth_enabled && cookie.isAnonymousAuth) {
      return {};
    }

    const headers = {};
    Object.assign(headers, {
      authorization: (_cookie$credentials2 = cookie.credentials) === null || _cookie$credentials2 === void 0 ? void 0 : _cookie$credentials2.authHeaderValue
    });
    return headers;
  }

}

exports.BasicAuthentication = BasicAuthentication;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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