/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointSubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifiedAccessEndpointLoadBalancerOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerifiedAccessEndpointLoadBalancerOptions> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(VerifiedAccessEndpointLoadBalancerOptions.getter(VerifiedAccessEndpointLoadBalancerOptions::protocolAsString)).setter(VerifiedAccessEndpointLoadBalancerOptions.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("protocol").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(VerifiedAccessEndpointLoadBalancerOptions.getter(VerifiedAccessEndpointLoadBalancerOptions::port)).setter(VerifiedAccessEndpointLoadBalancerOptions.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").unmarshallLocationName("port").build()}).build();
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerArn").getter(VerifiedAccessEndpointLoadBalancerOptions.getter(VerifiedAccessEndpointLoadBalancerOptions::loadBalancerArn)).setter(VerifiedAccessEndpointLoadBalancerOptions.setter(Builder::loadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").unmarshallLocationName("loadBalancerArn").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(VerifiedAccessEndpointLoadBalancerOptions.getter(VerifiedAccessEndpointLoadBalancerOptions::subnetIds)).setter(VerifiedAccessEndpointLoadBalancerOptions.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdSet").unmarshallLocationName("subnetIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, PORT_FIELD, LOAD_BALANCER_ARN_FIELD, SUBNET_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String protocol;
    private final Integer port;
    private final String loadBalancerArn;
    private final List<String> subnetIds;

    private VerifiedAccessEndpointLoadBalancerOptions(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.loadBalancerArn = builder.loadBalancerArn;
        this.subnetIds = builder.subnetIds;
    }

    public final VerifiedAccessEndpointProtocol protocol() {
        return VerifiedAccessEndpointProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer port() {
        return this.port;
    }

    public final String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessEndpointLoadBalancerOptions)) {
            return false;
        }
        VerifiedAccessEndpointLoadBalancerOptions other = (VerifiedAccessEndpointLoadBalancerOptions)obj;
        return Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds());
    }

    public final String toString() {
        return ToString.builder((String)"VerifiedAccessEndpointLoadBalancerOptions").add("Protocol", (Object)this.protocolAsString()).add("Port", (Object)this.port()).add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "LoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArn()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessEndpointLoadBalancerOptions, T> g) {
        return obj -> g.apply((VerifiedAccessEndpointLoadBalancerOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private Integer port;
        private String loadBalancerArn;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessEndpointLoadBalancerOptions model) {
            this.protocol(model.protocol);
            this.port(model.port);
            this.loadBalancerArn(model.loadBalancerArn);
            this.subnetIds(model.subnetIds);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(VerifiedAccessEndpointProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = VerifiedAccessEndpointSubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = VerifiedAccessEndpointSubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public VerifiedAccessEndpointLoadBalancerOptions build() {
            return new VerifiedAccessEndpointLoadBalancerOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerifiedAccessEndpointLoadBalancerOptions> {
        public Builder protocol(String var1);

        public Builder protocol(VerifiedAccessEndpointProtocol var1);

        public Builder port(Integer var1);

        public Builder loadBalancerArn(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);
    }
}

