/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceAutoRecoveryState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceMaintenanceOptionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ModifyInstanceMaintenanceOptionsResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ModifyInstanceMaintenanceOptionsResponse.getter(ModifyInstanceMaintenanceOptionsResponse::instanceId)).setter(ModifyInstanceMaintenanceOptionsResponse.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> AUTO_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoRecovery").getter(ModifyInstanceMaintenanceOptionsResponse.getter(ModifyInstanceMaintenanceOptionsResponse::autoRecoveryAsString)).setter(ModifyInstanceMaintenanceOptionsResponse.setter(Builder::autoRecovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRecovery").unmarshallLocationName("autoRecovery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, AUTO_RECOVERY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyInstanceMaintenanceOptionsResponse.memberNameToFieldInitializer();
    private final String instanceId;
    private final String autoRecovery;

    private ModifyInstanceMaintenanceOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.autoRecovery = builder.autoRecovery;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final InstanceAutoRecoveryState autoRecovery() {
        return InstanceAutoRecoveryState.fromValue(this.autoRecovery);
    }

    public final String autoRecoveryAsString() {
        return this.autoRecovery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRecoveryAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceMaintenanceOptionsResponse)) {
            return false;
        }
        ModifyInstanceMaintenanceOptionsResponse other = (ModifyInstanceMaintenanceOptionsResponse)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.autoRecoveryAsString(), other.autoRecoveryAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyInstanceMaintenanceOptionsResponse").add("InstanceId", (Object)this.instanceId()).add("AutoRecovery", (Object)this.autoRecoveryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "AutoRecovery": {
                return Optional.ofNullable(clazz.cast(this.autoRecoveryAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("AutoRecovery", AUTO_RECOVERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceMaintenanceOptionsResponse, T> g) {
        return obj -> g.apply((ModifyInstanceMaintenanceOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String instanceId;
        private String autoRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceMaintenanceOptionsResponse model) {
            super(model);
            this.instanceId(model.instanceId);
            this.autoRecovery(model.autoRecovery);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAutoRecovery() {
            return this.autoRecovery;
        }

        public final void setAutoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
        }

        @Override
        public final Builder autoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
            return this;
        }

        @Override
        public final Builder autoRecovery(InstanceAutoRecoveryState autoRecovery) {
            this.autoRecovery(autoRecovery == null ? null : autoRecovery.toString());
            return this;
        }

        @Override
        public ModifyInstanceMaintenanceOptionsResponse build() {
            return new ModifyInstanceMaintenanceOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstanceMaintenanceOptionsResponse> {
        public Builder instanceId(String var1);

        public Builder autoRecovery(String var1);

        public Builder autoRecovery(InstanceAutoRecoveryState var1);
    }
}

