/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.jni;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.opensearch.common.Nullable;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.query.KNNQueryResult;
import org.opensearch.knn.index.store.IndexInputWithBuffer;
import org.opensearch.knn.index.store.IndexOutputWithBuffer;
import org.opensearch.knn.index.util.IndexUtil;
import org.opensearch.knn.jni.FaissService;
import org.opensearch.knn.jni.NmslibService;

public class JNIService {
    public static long initIndex(long numDocs, int dim, Map<String, Object> parameters, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            if (IndexUtil.isBinaryIndex(knnEngine, parameters)) {
                return FaissService.initBinaryIndex(numDocs, dim, parameters);
            }
            if (IndexUtil.isByteIndex(parameters)) {
                return FaissService.initByteIndex(numDocs, dim, parameters);
            }
            return FaissService.initIndex(numDocs, dim, parameters);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "initIndexFromScratch not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void insertToIndex(int[] docs, long vectorsAddress, int dimension, Map<String, Object> parameters, long indexAddress, KNNEngine knnEngine) {
        int threadCount = (Integer)parameters.getOrDefault("indexThreadQty", 0);
        if (KNNEngine.FAISS == knnEngine) {
            if (IndexUtil.isBinaryIndex(knnEngine, parameters)) {
                FaissService.insertToBinaryIndex(docs, vectorsAddress, dimension, indexAddress, threadCount);
            } else if (IndexUtil.isByteIndex(parameters)) {
                FaissService.insertToByteIndex(docs, vectorsAddress, dimension, indexAddress, threadCount);
            } else {
                FaissService.insertToIndex(docs, vectorsAddress, dimension, indexAddress, threadCount);
            }
            return;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "insertToIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void writeIndex(IndexOutputWithBuffer output, long indexAddress, KNNEngine knnEngine, Map<String, Object> parameters) {
        if (KNNEngine.FAISS == knnEngine) {
            if (IndexUtil.isBinaryIndex(knnEngine, parameters)) {
                FaissService.writeBinaryIndex(indexAddress, output);
            } else if (IndexUtil.isByteIndex(parameters)) {
                FaissService.writeByteIndex(indexAddress, output);
            } else {
                FaissService.writeIndex(indexAddress, output);
            }
            return;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "writeIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void createIndex(int[] ids, long vectorsAddress, int dim, IndexOutputWithBuffer output, Map<String, Object> parameters, KNNEngine knnEngine) {
        if (KNNEngine.NMSLIB == knnEngine) {
            NmslibService.createIndex(ids, vectorsAddress, dim, output, parameters);
            return;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "CreateIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void createIndexFromTemplate(int[] ids, long vectorsAddress, int dim, IndexOutputWithBuffer output, byte[] templateIndex, Map<String, Object> parameters, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            if (IndexUtil.isBinaryIndex(knnEngine, parameters)) {
                FaissService.createBinaryIndexFromTemplate(ids, vectorsAddress, dim, output, templateIndex, parameters);
                return;
            }
            if (IndexUtil.isByteIndex(parameters)) {
                FaissService.createByteIndexFromTemplate(ids, vectorsAddress, dim, output, templateIndex, parameters);
                return;
            }
            FaissService.createIndexFromTemplate(ids, vectorsAddress, dim, output, templateIndex, parameters);
            return;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "CreateIndexFromTemplate not supported for provided engine : %s", knnEngine.getName()));
    }

    public static long loadIndex(IndexInputWithBuffer readStream, Map<String, Object> parameters, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            if (IndexUtil.isBinaryIndex(knnEngine, parameters)) {
                return FaissService.loadBinaryIndexWithStream(readStream);
            }
            return FaissService.loadIndexWithStream(readStream);
        }
        if (KNNEngine.NMSLIB == knnEngine) {
            return NmslibService.loadIndexWithStream(readStream, parameters);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "LoadIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    public static boolean isSharedIndexStateRequired(long indexAddr, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            return FaissService.isSharedIndexStateRequired(indexAddr);
        }
        return false;
    }

    public static long initSharedIndexState(long indexAddr, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            return FaissService.initSharedIndexState(indexAddr);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "InitSharedIndexState not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void setSharedIndexState(long indexAddr, long shareIndexStateAddr, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            FaissService.setSharedIndexState(indexAddr, shareIndexStateAddr);
            return;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "SetSharedIndexState not supported for provided engine : %s", knnEngine.getName()));
    }

    public static KNNQueryResult[] queryIndex(long indexPointer, float[] queryVector, int k, @Nullable Map<String, ?> methodParameters, KNNEngine knnEngine, long[] filteredIds, int filterIdsType, int[] parentIds) {
        if (KNNEngine.NMSLIB == knnEngine) {
            return NmslibService.queryIndex(indexPointer, queryVector, k, methodParameters);
        }
        if (KNNEngine.FAISS == knnEngine) {
            if (ArrayUtils.isNotEmpty((long[])filteredIds)) {
                return FaissService.queryIndexWithFilter(indexPointer, queryVector, k, methodParameters, filteredIds, filterIdsType, parentIds);
            }
            return FaissService.queryIndex(indexPointer, queryVector, k, methodParameters, parentIds);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "QueryIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    public static KNNQueryResult[] queryBinaryIndex(long indexPointer, byte[] queryVector, int k, @Nullable Map<String, ?> methodParameters, KNNEngine knnEngine, long[] filteredIds, int filterIdsType, int[] parentIds) {
        if (KNNEngine.FAISS == knnEngine) {
            return FaissService.queryBinaryIndexWithFilter(indexPointer, queryVector, k, methodParameters, ArrayUtils.isEmpty((long[])filteredIds) ? null : filteredIds, filterIdsType, parentIds);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "QueryBinaryIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void free(long indexPointer, KNNEngine knnEngine) {
        JNIService.free(indexPointer, knnEngine, false);
    }

    public static void free(long indexPointer, KNNEngine knnEngine, boolean isBinaryIndex) {
        if (KNNEngine.NMSLIB == knnEngine) {
            NmslibService.free(indexPointer);
            return;
        }
        if (KNNEngine.FAISS == knnEngine) {
            FaissService.free(indexPointer, isBinaryIndex);
            return;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Free not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void freeSharedIndexState(long shareIndexStateAddr, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            FaissService.freeSharedIndexState(shareIndexStateAddr);
            return;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "FreeSharedIndexState not supported for provided engine : %s", knnEngine.getName()));
    }

    public static byte[] trainIndex(Map<String, Object> indexParameters, int dimension, long trainVectorsPointer, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            if (IndexUtil.isBinaryIndex(knnEngine, indexParameters)) {
                return FaissService.trainBinaryIndex(indexParameters, dimension, trainVectorsPointer);
            }
            if (IndexUtil.isByteIndex(indexParameters)) {
                return FaissService.trainByteIndex(indexParameters, dimension, trainVectorsPointer);
            }
            return FaissService.trainIndex(indexParameters, dimension, trainVectorsPointer);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "TrainIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    @Deprecated(since="2.14.0", forRemoval=true)
    public static long transferVectors(long vectorsPointer, float[][] trainingData) {
        return FaissService.transferVectors(vectorsPointer, trainingData);
    }

    public static KNNQueryResult[] radiusQueryIndex(long indexPointer, float[] queryVector, float radius, @Nullable Map<String, ?> methodParameters, KNNEngine knnEngine, int indexMaxResultWindow, long[] filteredIds, int filterIdsType, int[] parentIds) {
        if (KNNEngine.FAISS == knnEngine) {
            if (ArrayUtils.isNotEmpty((long[])filteredIds)) {
                return FaissService.rangeSearchIndexWithFilter(indexPointer, queryVector, radius, methodParameters, indexMaxResultWindow, filteredIds, filterIdsType, parentIds);
            }
            return FaissService.rangeSearchIndex(indexPointer, queryVector, radius, methodParameters, indexMaxResultWindow, parentIds);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "RadiusQueryIndex not supported for provided engine", new Object[0]));
    }
}

