/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.datasource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.tribuo.DataSource;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.provenance.DataSourceProvenance;

public class ListDataSource<T extends Output<T>>
implements DataSource<T> {
    private final List<Example<T>> data;
    private final OutputFactory<T> factory;
    private final DataSourceProvenance provenance;

    public ListDataSource(List<Example<T>> list, OutputFactory<T> factory, DataSourceProvenance provenance) {
        this.data = Collections.unmodifiableList(new ArrayList<Example<T>>(list));
        this.factory = factory;
        this.provenance = provenance;
    }

    public int size() {
        return this.data.size();
    }

    @Override
    public OutputFactory<T> getOutputFactory() {
        return this.factory;
    }

    public DataSourceProvenance getProvenance() {
        return this.provenance;
    }

    @Override
    public Iterator<Example<T>> iterator() {
        return this.data.iterator();
    }

    public String toString() {
        return this.provenance.toString();
    }
}

