/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import java.io.IOException;
import java.util.Map;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestResponse;

public class SecurityResponse {
    public static final Map<String, String> CONTENT_TYPE_APP_JSON = Map.of("Content-Type", "application/json");
    private final int status;
    private final Map<String, String> headers;
    private final String body;

    public SecurityResponse(int status, Exception e) {
        this.status = status;
        this.headers = CONTENT_TYPE_APP_JSON;
        this.body = this.generateFailureMessage(e);
    }

    public SecurityResponse(int status, Map<String, String> headers, String body) {
        this.status = status;
        this.headers = headers;
        this.body = body;
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public RestResponse asRestResponse() {
        BytesRestResponse restResponse = new BytesRestResponse(RestStatus.fromCode((int)this.getStatus()), this.getBody());
        if (this.getHeaders() != null) {
            this.getHeaders().forEach((arg_0, arg_1) -> ((RestResponse)restResponse).addHeader(arg_0, arg_1));
        }
        return restResponse;
    }

    protected String generateFailureMessage(Exception e) {
        try {
            return XContentFactory.jsonBuilder().startObject().startObject("error").field("status", "error").field("reason", e.getMessage()).endObject().endObject().toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

