/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;

public class OpenSearchQueryRequest
implements OpenSearchRequest {
    private final OpenSearchRequest.IndexName indexName;
    private final SearchSourceBuilder sourceBuilder;
    private final OpenSearchExprValueFactory exprValueFactory;
    private final List<String> includes;
    private boolean searchDone = false;

    public OpenSearchQueryRequest(String indexName, int size, OpenSearchExprValueFactory factory, List<String> includes) {
        this(new OpenSearchRequest.IndexName(indexName), size, factory, includes);
    }

    public OpenSearchQueryRequest(OpenSearchRequest.IndexName indexName, int size, OpenSearchExprValueFactory factory, List<String> includes) {
        this.indexName = indexName;
        this.sourceBuilder = new SearchSourceBuilder();
        this.sourceBuilder.from(0);
        this.sourceBuilder.size(size);
        this.sourceBuilder.timeout(DEFAULT_QUERY_TIMEOUT);
        this.exprValueFactory = factory;
        this.includes = includes;
    }

    public OpenSearchQueryRequest(OpenSearchRequest.IndexName indexName, SearchSourceBuilder sourceBuilder, OpenSearchExprValueFactory factory, List<String> includes) {
        this.indexName = indexName;
        this.sourceBuilder = sourceBuilder;
        this.exprValueFactory = factory;
        this.includes = includes;
    }

    @Override
    public OpenSearchResponse search(Function<SearchRequest, SearchResponse> searchAction, Function<SearchScrollRequest, SearchResponse> scrollAction) {
        if (this.searchDone) {
            return new OpenSearchResponse(SearchHits.empty(), this.exprValueFactory, this.includes);
        }
        this.searchDone = true;
        return new OpenSearchResponse(searchAction.apply(new SearchRequest().indices(this.indexName.getIndexNames()).source(this.sourceBuilder)), this.exprValueFactory, this.includes);
    }

    @Override
    public void clean(Consumer<String> cleanAction) {
    }

    @Override
    public boolean hasAnotherBatch() {
        return false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("OpenSearchQueryRequest serialization is not implemented.");
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchQueryRequest)) {
            return false;
        }
        OpenSearchQueryRequest other = (OpenSearchQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSearchDone() != other.isSearchDone()) {
            return false;
        }
        OpenSearchRequest.IndexName this$indexName = this.getIndexName();
        OpenSearchRequest.IndexName other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !((Object)this$indexName).equals(other$indexName)) {
            return false;
        }
        SearchSourceBuilder this$sourceBuilder = this.getSourceBuilder();
        SearchSourceBuilder other$sourceBuilder = other.getSourceBuilder();
        return !(this$sourceBuilder == null ? other$sourceBuilder != null : !this$sourceBuilder.equals(other$sourceBuilder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchQueryRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSearchDone() ? 79 : 97);
        OpenSearchRequest.IndexName $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : ((Object)$indexName).hashCode());
        SearchSourceBuilder $sourceBuilder = this.getSourceBuilder();
        result = result * 59 + ($sourceBuilder == null ? 43 : $sourceBuilder.hashCode());
        return result;
    }

    @Generated
    public OpenSearchRequest.IndexName getIndexName() {
        return this.indexName;
    }

    @Generated
    public SearchSourceBuilder getSourceBuilder() {
        return this.sourceBuilder;
    }

    @Override
    @Generated
    public OpenSearchExprValueFactory getExprValueFactory() {
        return this.exprValueFactory;
    }

    @Generated
    public List<String> getIncludes() {
        return this.includes;
    }

    @Generated
    public boolean isSearchDone() {
        return this.searchDone;
    }

    @Generated
    public String toString() {
        return "OpenSearchQueryRequest(indexName=" + this.getIndexName() + ", sourceBuilder=" + this.getSourceBuilder() + ", searchDone=" + this.isSearchDone() + ")";
    }
}

