// Copyright (c) Lawrence Livermore National Security, LLC and other Conduit
// Project developers. See top-level LICENSE AND COPYRIGHT files for dates and
// other details. No copyright assignment is required to contribute to Conduit.

//-----------------------------------------------------------------------------
///
/// file: conduit_blueprint_c_exports.h
///
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
#ifndef CONDUIT_BLUEPRINT_C_EXPORTS_H
#define CONDUIT_BLUEPRINT_C_EXPORTS_H
//-----------------------------------------------------------------------------

#include "conduit_blueprint_exports.h"

//-----------------------------------------------------------------------------
// -- define proper lib exports for various platforms --
//-----------------------------------------------------------------------------

#if !defined(CONDUIT_BLUEPRINT_EXPORTS_DEFINED) && \
    defined(conduit_blueprint_c_EXPORTS)
    /* define catch all def */
    #define CONDUIT_BLUEPRINT_EXPORTS_DEFINED 1
#endif

#if defined(_WIN32)
    #if defined(CONDUIT_WINDOWS_DLL_EXPORTS)
        #if defined(CONDUIT_BLUEPRINT_EXPORTS_DEFINED)
            #define CONDUIT_BLUEPRINT_C_API __declspec(dllexport)
        #else
            #define CONDUIT_BLUEPRINT_C_API __declspec(dllimport)
        #endif
    #else
        #define CONDUIT_BLUEPRINT_C_API /* empty for static builds */
    #endif

    #if defined(_MSC_VER)
        /* Turn off warning about lack of DLL interface */
        #pragma warning(disable:4251)
        /* Turn off warning non-dll class is base for dll-interface class */
        #pragma warning(disable:4275)
        /* Turn off warning about identifier truncation */
        #pragma warning(disable:4786)
    #endif
#else
    #if __GNUC__ >= 4 && (defined(CONDUIT_BLUEPRINT_EXPORTS_DEFINED))
        #define CONDUIT_BLUEPRINT_C_API __attribute__ ((visibility("default")))
    #else
        #define CONDUIT_BLUEPRINT_C_API /* hidden by default */
    #endif
#endif

//-----------------------------------------------------------------------------
// CONDUIT_BLUEPRINT_C_EXPORTS_H
//-----------------------------------------------------------------------------
#endif



