/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.eps;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.AbstractCommonUGraphic;
import net.sourceforge.plantuml.klimt.drawing.AbstractUGraphic;
import net.sourceforge.plantuml.klimt.drawing.eps.DriverCenteredCharacterEps;
import net.sourceforge.plantuml.klimt.drawing.eps.DriverDotPathEps;
import net.sourceforge.plantuml.klimt.drawing.eps.DriverEllipseEps;
import net.sourceforge.plantuml.klimt.drawing.eps.DriverImageEps;
import net.sourceforge.plantuml.klimt.drawing.eps.DriverLineEps;
import net.sourceforge.plantuml.klimt.drawing.eps.DriverPathEps;
import net.sourceforge.plantuml.klimt.drawing.eps.DriverPolygonEps;
import net.sourceforge.plantuml.klimt.drawing.eps.DriverRectangleEps;
import net.sourceforge.plantuml.klimt.drawing.eps.DriverTextEps;
import net.sourceforge.plantuml.klimt.drawing.eps.EpsGraphics;
import net.sourceforge.plantuml.klimt.drawing.eps.EpsStrategy;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.DotPath;
import net.sourceforge.plantuml.klimt.shape.UCenteredCharacter;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.url.Url;

public class UGraphicEps
extends AbstractUGraphic<EpsGraphics>
implements ClipContainer {
    private final EpsStrategy strategyTOBEREMOVED;

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        UGraphicEps result = new UGraphicEps(this);
        return result;
    }

    protected UGraphicEps(UGraphicEps other) {
        super(other.getStringBounder());
        this.copy(other);
        this.strategyTOBEREMOVED = other.strategyTOBEREMOVED;
        this.register();
    }

    public UGraphicEps(HColor defaultBackground, ColorMapper colorMapper, StringBounder stringBounder, EpsStrategy strategy) {
        super(stringBounder);
        this.copy(defaultBackground, colorMapper, strategy.creatEpsGraphics());
        this.strategyTOBEREMOVED = strategy;
        this.register();
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleEps(this));
        this.registerDriver(UText.class, new DriverTextEps(this, this.strategyTOBEREMOVED));
        this.registerDriver(ULine.class, new DriverLineEps(this));
        this.registerDriver(UPolygon.class, new DriverPolygonEps(this));
        this.registerDriver(UEllipse.class, new DriverEllipseEps(this));
        this.registerDriver(UImage.class, new DriverImageEps(this));
        this.registerDriver(UPath.class, new DriverPathEps());
        this.registerDriver(DotPath.class, new DriverDotPathEps());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterEps());
    }

    public void close() {
        this.getEpsGraphics().close();
    }

    public String getEPSCode() {
        return this.getEpsGraphics().getEPSCode();
    }

    public EpsGraphics getEpsGraphics() {
        return (EpsGraphics)this.getGraphicObject();
    }

    public void drawEps(String eps, double x, double y) {
        ((EpsGraphics)this.getGraphicObject()).drawEps(eps, x, y);
    }

    public static String getEpsString(HColor defaultBackground, ColorMapper colorMapper, EpsStrategy epsStrategy, UDrawable udrawable) throws IOException {
        UGraphicEps ug = new UGraphicEps(defaultBackground, colorMapper, FileFormat.EPS_TEXT.getDefaultStringBounder(), epsStrategy);
        udrawable.drawU(ug);
        return ug.getEPSCode();
    }

    @Override
    public void startUrl(Url url) {
        ((EpsGraphics)this.getGraphicObject()).openLink(url.getUrl());
    }

    @Override
    public void closeUrl() {
        ((EpsGraphics)this.getGraphicObject()).closeLink();
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        os.write(this.getEPSCode().getBytes());
    }
}

