/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.el;

import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELManager;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.FunctionMapper;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ResourceBundleELResolver;
import jakarta.el.StaticFieldELResolver;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.jasper.Constants;

public class ELContextImpl
extends ELContext {
    private static final FunctionMapper NullFunctionMapper = new FunctionMapper(){

        @Override
        public Method resolveFunction(String prefix, String localName) {
            return null;
        }
    };
    private static final ELResolver DefaultResolver;
    private final ELResolver resolver;
    private FunctionMapper functionMapper = NullFunctionMapper;
    private VariableMapper variableMapper;

    public ELContextImpl(ExpressionFactory factory) {
        this(ELContextImpl.getDefaultResolver(factory));
    }

    public ELContextImpl(ELResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public ELResolver getELResolver() {
        return this.resolver;
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    @Override
    public VariableMapper getVariableMapper() {
        if (this.variableMapper == null) {
            this.variableMapper = new VariableMapperImpl();
        }
        return this.variableMapper;
    }

    public void setFunctionMapper(FunctionMapper functionMapper) {
        this.functionMapper = functionMapper;
    }

    public void setVariableMapper(VariableMapper variableMapper) {
        this.variableMapper = variableMapper;
    }

    public static ELResolver getDefaultResolver(ExpressionFactory factory) {
        if (Constants.IS_SECURITY_ENABLED) {
            CompositeELResolver defaultResolver = new CompositeELResolver();
            defaultResolver.add(factory.getStreamELResolver());
            defaultResolver.add(new StaticFieldELResolver());
            defaultResolver.add(new MapELResolver());
            defaultResolver.add(new ResourceBundleELResolver());
            defaultResolver.add(new ListELResolver());
            defaultResolver.add(new ArrayELResolver());
            defaultResolver.add(new BeanELResolver());
            return defaultResolver;
        }
        return DefaultResolver;
    }

    static {
        if (Constants.IS_SECURITY_ENABLED) {
            DefaultResolver = null;
        } else {
            DefaultResolver = new CompositeELResolver();
            ((CompositeELResolver)DefaultResolver).add(ELManager.getExpressionFactory().getStreamELResolver());
            ((CompositeELResolver)DefaultResolver).add(new StaticFieldELResolver());
            ((CompositeELResolver)DefaultResolver).add(new MapELResolver());
            ((CompositeELResolver)DefaultResolver).add(new ResourceBundleELResolver());
            ((CompositeELResolver)DefaultResolver).add(new ListELResolver());
            ((CompositeELResolver)DefaultResolver).add(new ArrayELResolver());
            ((CompositeELResolver)DefaultResolver).add(new BeanELResolver());
        }
    }

    private static final class VariableMapperImpl
    extends VariableMapper {
        private Map<String, ValueExpression> vars;

        private VariableMapperImpl() {
        }

        @Override
        public ValueExpression resolveVariable(String variable) {
            if (this.vars == null) {
                return null;
            }
            return this.vars.get(variable);
        }

        @Override
        public ValueExpression setVariable(String variable, ValueExpression expression) {
            if (this.vars == null) {
                this.vars = new HashMap<String, ValueExpression>();
            }
            if (expression == null) {
                return this.vars.remove(variable);
            }
            return this.vars.put(variable, expression);
        }
    }
}

