/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.glassfish.pfl.basic.algorithm.ClassAnalyzer;
import org.glassfish.pfl.basic.func.UnaryPredicateBase;
import org.glassfish.pfl.basic.proxy.CompositeInvocationHandler;

public class CompositeInvocationHandlerImpl
implements CompositeInvocationHandler {
    private static final long serialVersionUID = -5206426596331848271L;
    private Map<Class<?>, InvocationHandler> classToInvocationHandler = new LinkedHashMap();
    private InvocationHandler defaultHandler = null;

    @Override
    public void addInvocationHandler(Class<?> interf, final InvocationHandler handler) {
        ClassAnalyzer ca = ClassAnalyzer.getClassAnalyzer(interf);
        ca.findClasses(new UnaryPredicateBase<Class<?>>("AddClassToMap"){

            @Override
            public boolean eval(Class<?> cls) {
                CompositeInvocationHandlerImpl.this.classToInvocationHandler.put(cls, handler);
                return true;
            }
        });
    }

    @Override
    public void setDefaultHandler(InvocationHandler handler) {
        this.defaultHandler = handler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> cls = method.getDeclaringClass();
        if (cls.equals(Object.class)) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (Exception exc) {
                throw new RuntimeException("Invocation error on Object method", exc);
            }
        }
        InvocationHandler handler = this.classToInvocationHandler.get(cls);
        if (handler == null) {
            if (this.defaultHandler != null) {
                handler = this.defaultHandler;
            } else {
                throw new RuntimeException("No invocation handler for method \"" + method.toString() + "\"");
            }
        }
        return handler.invoke(proxy, method, args);
    }
}

