/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.guava.collect;

import io.trino.jdbc.$internal.guava.annotations.GwtCompatible;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.collect.ElementTypesAreNonnullByDefault;
import io.trino.jdbc.$internal.guava.collect.Ordering;
import io.trino.jdbc.$internal.guava.collect.ReverseNaturalOrdering;
import io.trino.jdbc.$internal.javax.annotation.CheckForNull;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class NaturalOrdering
extends Ordering<Comparable<?>>
implements Serializable {
    static final NaturalOrdering INSTANCE = new NaturalOrdering();
    @CheckForNull
    private transient Ordering<@Nullable Comparable<?>> nullsFirst;
    @CheckForNull
    private transient Ordering<@Nullable Comparable<?>> nullsLast;
    private static final long serialVersionUID = 0L;

    @Override
    public int compare(Comparable<?> left, Comparable<?> right) {
        Preconditions.checkNotNull(left);
        Preconditions.checkNotNull(right);
        return left.compareTo(right);
    }

    @Override
    public <S extends Comparable<?>> Ordering<@Nullable S> nullsFirst() {
        Ordering<@Nullable Comparable<Object>> result = this.nullsFirst;
        if (result == null) {
            result = this.nullsFirst = super.nullsFirst();
        }
        return result;
    }

    @Override
    public <S extends Comparable<?>> Ordering<@Nullable S> nullsLast() {
        Ordering<@Nullable Comparable<Object>> result = this.nullsLast;
        if (result == null) {
            result = this.nullsLast = super.nullsLast();
        }
        return result;
    }

    @Override
    public <S extends Comparable<?>> Ordering<S> reverse() {
        return ReverseNaturalOrdering.INSTANCE;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public String toString() {
        return "Ordering.natural()";
    }

    private NaturalOrdering() {
    }
}

