/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.internal.core.cql.MultiPageResultSet;
import com.datastax.oss.driver.internal.core.cql.SinglePageResultSet;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.google.common.collect.Lists;
import com.ing.data.cassandra.jdbc.AbstractStatement;
import com.ing.data.cassandra.jdbc.CassandraConnection;
import com.ing.data.cassandra.jdbc.CassandraResultSet;
import com.ing.data.cassandra.jdbc.CassandraStatementExtras;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransientException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStatement
extends AbstractStatement
implements CassandraStatementExtras,
Comparable<Object>,
Statement {
    public static final int MAX_ASYNC_QUERIES = 1000;
    public static final String STATEMENTS_SEPARATOR_REGEX = ";";
    protected static final int DEFAULT_FETCH_SIZE = 100;
    private static final Logger LOG = LoggerFactory.getLogger(CassandraStatement.class);
    protected CassandraConnection connection;
    protected String cql;
    protected ArrayList<String> batchQueries;
    protected int fetchDirection = 1000;
    protected int fetchSize = 100;
    protected int maxFieldSize = 0;
    protected int maxRows = 0;
    protected int resultSetType;
    protected int resultSetConcurrency;
    protected int resultSetHoldability;
    protected ResultSet currentResultSet = null;
    protected int updateCount = -1;
    protected boolean escapeProcessing = true;
    protected com.datastax.oss.driver.api.core.cql.Statement<?> statement;
    protected ConsistencyLevel consistencyLevel;

    CassandraStatement(CassandraConnection connection) throws SQLException {
        this(connection, null, 1003, 1007, 1);
    }

    CassandraStatement(CassandraConnection connection, String cql) throws SQLException {
        this(connection, cql, 1003, 1007, 1);
    }

    CassandraStatement(CassandraConnection connection, String cql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(connection, cql, resultSetType, resultSetConcurrency, 1);
    }

    CassandraStatement(CassandraConnection connection, String cql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.connection = connection;
        this.cql = cql;
        this.batchQueries = Lists.newArrayList();
        this.consistencyLevel = connection.getDefaultConsistencyLevel();
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new SQLSyntaxErrorException("The argument for result set type: %s is not a valid value.");
        }
        this.resultSetType = resultSetType;
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new SQLSyntaxErrorException("The argument for result set concurrency: %s is not a valid value.");
        }
        this.resultSetConcurrency = resultSetConcurrency;
        if (resultSetHoldability != 1 && resultSetHoldability != 2) {
            throw new SQLSyntaxErrorException("The argument for result set holdability: %s is not a valid value.");
        }
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public void addBatch(String query) throws SQLException {
        this.checkNotClosed();
        this.batchQueries.add(query);
    }

    protected final void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLRecoverableException("Method was called on a closed Statement.");
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        this.batchQueries = new ArrayList();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void close() {
        this.connection = null;
        this.cql = null;
    }

    @Override
    public int compareTo(@NonNull Object target) {
        if (this.equals(target)) {
            return 0;
        }
        if (this.hashCode() < target.hashCode()) {
            return -1;
        }
        return 1;
    }

    private void doExecute(String cql) throws SQLException {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        try {
            String[] cqlQueries = cql.split(STATEMENTS_SEPARATOR_REGEX);
            if (!(cqlQueries.length <= 1 || cql.trim().toLowerCase().startsWith("begin") && cql.toLowerCase().contains("batch") && cql.toLowerCase().contains("apply"))) {
                ArrayList results = Lists.newArrayList();
                if ((double)cqlQueries.length > 1100.0) {
                    throw new SQLNonTransientException("Too many queries at once (" + cqlQueries.length + "). You must split your queries into more batches !");
                }
                StringBuilder prevCqlQuery = new StringBuilder();
                for (String cqlQuery : cqlQueries) {
                    if (cqlQuery.contains("'") && (StringUtils.countMatches((CharSequence)cqlQuery, (CharSequence)"'") % 2 == 1 && prevCqlQuery.length() == 0 || StringUtils.countMatches((CharSequence)cqlQuery, (CharSequence)"'") % 2 == 0 && prevCqlQuery.length() > 0) || prevCqlQuery.toString().length() > 0 && !cqlQuery.contains("'")) {
                        prevCqlQuery.append(cqlQuery).append(STATEMENTS_SEPARATOR_REGEX);
                        continue;
                    }
                    prevCqlQuery.append(cqlQuery);
                    if (LOG.isTraceEnabled() || this.connection.isDebugMode()) {
                        LOG.debug("CQL: {}", (Object)prevCqlQuery);
                    }
                    SimpleStatement stmt = (SimpleStatement)((SimpleStatement)SimpleStatement.newInstance((String)prevCqlQuery.toString()).setConsistencyLevel(this.connection.getDefaultConsistencyLevel())).setPageSize(this.fetchSize);
                    CompletionStage resultSetFuture = ((CqlSession)this.connection.getSession()).executeAsync((com.datastax.oss.driver.api.core.cql.Statement)stmt);
                    futures.add(resultSetFuture);
                    prevCqlQuery = new StringBuilder();
                }
                for (CompletionStage future : futures) {
                    AsyncResultSet asyncResultSet = (AsyncResultSet)CompletableFutures.getUninterruptibly((CompletionStage)future);
                    Object rows = asyncResultSet.hasMorePages() ? new MultiPageResultSet(asyncResultSet) : new SinglePageResultSet(asyncResultSet);
                    results.add(rows);
                }
                this.currentResultSet = new CassandraResultSet(this, results);
            } else {
                if (LOG.isTraceEnabled() || this.connection.isDebugMode()) {
                    LOG.debug("CQL: " + cql);
                }
                SimpleStatement stmt = (SimpleStatement)((SimpleStatement)SimpleStatement.newInstance((String)cql).setConsistencyLevel(this.connection.getDefaultConsistencyLevel())).setPageSize(this.fetchSize);
                this.currentResultSet = new CassandraResultSet(this, ((CqlSession)this.connection.getSession()).execute((com.datastax.oss.driver.api.core.cql.Statement)stmt));
            }
        }
        catch (Exception e) {
            for (CompletionStage future : futures) {
                future.toCompletableFuture().cancel(true);
            }
            throw new SQLTransientException(e);
        }
    }

    @Override
    public boolean execute(String query) throws SQLException {
        this.checkNotClosed();
        this.doExecute(query);
        return this.currentResultSet != null && ((CassandraResultSet)this.currentResultSet).hasMoreRows();
    }

    @Override
    public boolean execute(String cql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLSyntaxErrorException("Auto key generation value of: %s is illegal.");
        }
        if (autoGeneratedKeys == 1) {
            throw new SQLFeatureNotSupportedException("The Cassandra implementation does not currently support returning generated keys.");
        }
        return this.execute(cql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] returnCounts = new int[this.batchQueries.size()];
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        if (LOG.isTraceEnabled() || this.connection.isDebugMode()) {
            LOG.debug("CQL statements: " + this.batchQueries.size());
        }
        for (String query : this.batchQueries) {
            if (LOG.isTraceEnabled() || this.connection.isDebugMode()) {
                LOG.debug("CQL: " + query);
            }
            SimpleStatement stmt = (SimpleStatement)SimpleStatement.newInstance((String)query).setConsistencyLevel(this.connection.getDefaultConsistencyLevel());
            CompletionStage resultSetFuture = ((CqlSession)this.connection.getSession()).executeAsync((com.datastax.oss.driver.api.core.cql.Statement)stmt);
            futures.add(resultSetFuture);
        }
        int i = 0;
        for (CompletionStage future : futures) {
            CompletableFutures.getUninterruptibly((CompletionStage)future);
            returnCounts[i] = 1;
            ++i;
        }
        return returnCounts;
    }

    @Override
    public ResultSet executeQuery(String cql) throws SQLException {
        this.checkNotClosed();
        this.doExecute(cql);
        if (this.currentResultSet == null) {
            throw new SQLNonTransientException("No ResultSet returned from the CQL statement passed in an 'executeQuery()' method.");
        }
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate(String cql) throws SQLException {
        this.checkNotClosed();
        this.doExecute(cql);
        return this.connection.getOptionSet().getSQLUpdateResponse();
    }

    @Override
    public int executeUpdate(String cql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLFeatureNotSupportedException("Auto key generation value of: %s is illegal.");
        }
        return this.executeUpdate(cql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkNotClosed();
        return this.connection;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        this.statement = this.statement.setConsistencyLevel(consistencyLevel);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        return this.fetchDirection;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkNotClosed();
        if (direction == 1000 || direction == 1001 || direction == 1002) {
            if (this.getResultSetType() == 1003 && direction != 1000) {
                throw new SQLSyntaxErrorException(String.format("Fetch direction value of: %s is illegal.", direction));
            }
        } else {
            throw new SQLSyntaxErrorException(String.format("Fetch direction value of: %s is illegal.", direction));
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkNotClosed();
        if (rows < 0) {
            throw new SQLSyntaxErrorException(String.format("Fetch size of: %s rows may not be negative.", rows));
        }
        this.fetchSize = rows;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkNotClosed();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkNotClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkNotClosed();
        this.resetResults();
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkNotClosed();
        switch (current) {
            case 1: {
                this.resetResults();
                break;
            }
            case 2: 
            case 3: {
                throw new SQLFeatureNotSupportedException("The Cassandra implementation does not currently support multiple open Result Sets.");
            }
            default: {
                throw new SQLSyntaxErrorException(String.format("The argument for keeping the current result set: %s is not a valid value.", current));
            }
        }
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        return this.currentResultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkNotClosed();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkNotClosed();
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkNotClosed();
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkNotClosed();
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.connection == null;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkNotClosed();
    }

    protected final void resetResults() {
        this.currentResultSet = null;
        this.updateCount = -1;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkNotClosed();
        this.escapeProcessing = enable;
    }
}

