/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.ing.data.cassandra.jdbc.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.JdbcAscii;
import com.ing.data.cassandra.jdbc.JdbcBoolean;
import com.ing.data.cassandra.jdbc.JdbcByte;
import com.ing.data.cassandra.jdbc.JdbcBytes;
import com.ing.data.cassandra.jdbc.JdbcCounterColumn;
import com.ing.data.cassandra.jdbc.JdbcDate;
import com.ing.data.cassandra.jdbc.JdbcDecimal;
import com.ing.data.cassandra.jdbc.JdbcDouble;
import com.ing.data.cassandra.jdbc.JdbcDuration;
import com.ing.data.cassandra.jdbc.JdbcFloat;
import com.ing.data.cassandra.jdbc.JdbcInetAddress;
import com.ing.data.cassandra.jdbc.JdbcInt32;
import com.ing.data.cassandra.jdbc.JdbcInteger;
import com.ing.data.cassandra.jdbc.JdbcLexicalUUID;
import com.ing.data.cassandra.jdbc.JdbcLong;
import com.ing.data.cassandra.jdbc.JdbcOther;
import com.ing.data.cassandra.jdbc.JdbcShort;
import com.ing.data.cassandra.jdbc.JdbcTime;
import com.ing.data.cassandra.jdbc.JdbcTimeUUID;
import com.ing.data.cassandra.jdbc.JdbcTimestamp;
import com.ing.data.cassandra.jdbc.JdbcTuple;
import com.ing.data.cassandra.jdbc.JdbcUTF8;
import com.ing.data.cassandra.jdbc.JdbcUUID;
import com.ing.data.cassandra.jdbc.JdbcUdt;
import java.util.HashMap;
import java.util.Map;

public final class TypesMap {
    private static final Map<String, AbstractJdbcType<?>> TYPES_MAP = new HashMap();

    private TypesMap() {
    }

    public static AbstractJdbcType<?> getTypeForComparator(String comparator) {
        if (comparator != null && !comparator.contains(".")) {
            return TYPES_MAP.getOrDefault("org.apache.cassandra.db.marshal." + comparator.toLowerCase(), JdbcOther.INSTANCE);
        }
        return TYPES_MAP.getOrDefault(comparator, JdbcOther.INSTANCE);
    }

    static {
        TYPES_MAP.put("org.apache.cassandra.db.marshal.AsciiType", JdbcAscii.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.BooleanType", JdbcBoolean.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.BytesType", JdbcBytes.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.ByteType", JdbcByte.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.CounterColumnType", JdbcCounterColumn.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.DateType", JdbcDate.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.DecimalType", JdbcDecimal.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.DoubleType", JdbcDouble.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.DurationType", JdbcDuration.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.FloatType", JdbcFloat.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.InetAddressType", JdbcInetAddress.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.IntegerType", JdbcInteger.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.Int32Type", JdbcInt32.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.LexicalUUIDType", JdbcLexicalUUID.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.LongType", JdbcLong.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.ShortType", JdbcShort.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.TimeType", JdbcTime.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.TimestampType", JdbcTimestamp.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.TimeUUIDType", JdbcTimeUUID.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.TupleType", JdbcTuple.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.UserType", JdbcUdt.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.UTF8Type", JdbcUTF8.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.UUIDType", JdbcUUID.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.ascii", JdbcAscii.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.bigint", JdbcLong.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.blob", JdbcBytes.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.boolean", JdbcBoolean.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.counter", JdbcLong.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.date", JdbcDate.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.decimal", JdbcDecimal.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.double", JdbcDouble.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.duration", JdbcDuration.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.float", JdbcFloat.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.inet", JdbcInetAddress.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.int", JdbcInt32.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.smallint", JdbcShort.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.text", JdbcUTF8.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.time", JdbcTime.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.timestamp", JdbcTimestamp.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.timeuuid", JdbcTimeUUID.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.tinyint", JdbcByte.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.tuple", JdbcTuple.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.udt", JdbcUdt.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.uuid", JdbcUUID.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.varchar", JdbcUTF8.INSTANCE);
        TYPES_MAP.put("org.apache.cassandra.db.marshal.varint", JdbcInteger.INSTANCE);
    }
}

