/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opencensus.tags;

import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opencensus.internal.StringUtils;
import net.snowflake.client.jdbc.internal.opencensus.internal.Utils;
import net.snowflake.client.jdbc.internal.opencensus.tags.AutoValue_TagKey;

@Immutable
public abstract class TagKey {
    public static final int MAX_LENGTH = 255;

    TagKey() {
    }

    public static TagKey create(String name) {
        Utils.checkArgument(TagKey.isValid(name), "Invalid TagKey name: %s", name);
        return new AutoValue_TagKey(name);
    }

    public abstract String getName();

    private static boolean isValid(String name) {
        return !name.isEmpty() && name.length() <= 255 && StringUtils.isPrintableString(name);
    }
}

