/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opencensus.tags;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.opencensus.internal.Provider;
import net.snowflake.client.jdbc.internal.opencensus.tags.NoopTags;
import net.snowflake.client.jdbc.internal.opencensus.tags.Tagger;
import net.snowflake.client.jdbc.internal.opencensus.tags.TaggingState;
import net.snowflake.client.jdbc.internal.opencensus.tags.TagsComponent;
import net.snowflake.client.jdbc.internal.opencensus.tags.propagation.TagPropagationComponent;

public final class Tags {
    private static final Logger logger = Logger.getLogger(Tags.class.getName());
    private static final TagsComponent tagsComponent = Tags.loadTagsComponent(TagsComponent.class.getClassLoader());

    private Tags() {
    }

    public static Tagger getTagger() {
        return tagsComponent.getTagger();
    }

    public static TagPropagationComponent getTagPropagationComponent() {
        return tagsComponent.getTagPropagationComponent();
    }

    public static TaggingState getState() {
        return tagsComponent.getState();
    }

    @Deprecated
    public static void setState(TaggingState state) {
        tagsComponent.setState(state);
    }

    static TagsComponent loadTagsComponent(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("net.snowflake.client.jdbc.internal.opencensus.impl.tags.TagsComponentImpl", true, classLoader), TagsComponent.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Couldn't load full implementation for TagsComponent, now trying to load lite implementation.", e);
            try {
                return Provider.createInstance(Class.forName("net.snowflake.client.jdbc.internal.opencensus.impllite.tags.TagsComponentImplLite", true, classLoader), TagsComponent.class);
            }
            catch (ClassNotFoundException e2) {
                logger.log(Level.FINE, "Couldn't load lite implementation for TagsComponent, now using default implementation for TagsComponent.", e2);
                return NoopTags.newNoopTagsComponent();
            }
        }
    }
}

