/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.ProtocolDetectionException;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ProtocolHeaders {
    public static final ProtocolHeaders TRINO_HEADERS = new ProtocolHeaders("Trino");
    private final String name;
    private final String prefix;

    public static ProtocolHeaders createProtocolHeaders(String name) {
        if (TRINO_HEADERS.getProtocolName().equalsIgnoreCase(name)) {
            return TRINO_HEADERS;
        }
        return new ProtocolHeaders(name);
    }

    private ProtocolHeaders(String name) {
        Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument(!name.isEmpty(), "name is empty");
        this.name = name;
        this.prefix = "X-" + name + "-";
    }

    public String getProtocolName() {
        return this.name;
    }

    public String requestUser() {
        return this.prefix + "User";
    }

    public String requestSource() {
        return this.prefix + "Source";
    }

    public String requestCatalog() {
        return this.prefix + "Catalog";
    }

    public String requestSchema() {
        return this.prefix + "Schema";
    }

    public String requestPath() {
        return this.prefix + "Path";
    }

    public String requestTimeZone() {
        return this.prefix + "Time-Zone";
    }

    public String requestLanguage() {
        return this.prefix + "Language";
    }

    public String requestTraceToken() {
        return this.prefix + "Trace-Token";
    }

    public String requestSession() {
        return this.prefix + "Session";
    }

    public String requestRole() {
        return this.prefix + "Role";
    }

    public String requestPreparedStatement() {
        return this.prefix + "Prepared-Statement";
    }

    public String requestTransactionId() {
        return this.prefix + "Transaction-Id";
    }

    public String requestClientInfo() {
        return this.prefix + "Client-Info";
    }

    public String requestClientTags() {
        return this.prefix + "Client-Tags";
    }

    public String requestClientCapabilities() {
        return this.prefix + "Client-Capabilities";
    }

    public String requestResourceEstimate() {
        return this.prefix + "Resource-Estimate";
    }

    public String requestExtraCredential() {
        return this.prefix + "Extra-Credential";
    }

    public String responseSetCatalog() {
        return this.prefix + "Set-Catalog";
    }

    public String responseSetSchema() {
        return this.prefix + "Set-Schema";
    }

    public String responseSetPath() {
        return this.prefix + "Set-Path";
    }

    public String responseSetSession() {
        return this.prefix + "Set-Session";
    }

    public String responseClearSession() {
        return this.prefix + "Clear-Session";
    }

    public String responseSetRole() {
        return this.prefix + "Set-Role";
    }

    public String responseAddedPrepare() {
        return this.prefix + "Added-Prepare";
    }

    public String responseDeallocatedPrepare() {
        return this.prefix + "Deallocated-Prepare";
    }

    public String responseStartedTransactionId() {
        return this.prefix + "Started-Transaction-Id";
    }

    public String responseClearTransactionId() {
        return this.prefix + "Clear-Transaction-Id";
    }

    public static ProtocolHeaders detectProtocol(Optional<String> alternateHeaderName, Set<String> headerNames) throws ProtocolDetectionException {
        Objects.requireNonNull(alternateHeaderName, "alternateHeaderName is null");
        Objects.requireNonNull(headerNames, "headerNames is null");
        if (alternateHeaderName.isPresent() && !alternateHeaderName.get().equalsIgnoreCase("Trino")) {
            String headerPrefix = "x-" + alternateHeaderName.get().toLowerCase(Locale.ENGLISH);
            if (headerNames.stream().anyMatch(header -> header.toLowerCase(Locale.ENGLISH).startsWith(headerPrefix))) {
                if (headerNames.stream().anyMatch(header -> header.toLowerCase(Locale.ENGLISH).startsWith("x-trino-"))) {
                    throw new ProtocolDetectionException("Both Trino and " + alternateHeaderName.get() + " headers detected");
                }
                return ProtocolHeaders.createProtocolHeaders(alternateHeaderName.get());
            }
        }
        return TRINO_HEADERS;
    }
}

