/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.ing.data.cassandra.jdbc.CassandraConnection;
import com.ing.data.cassandra.jdbc.SessionHolder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class CassandraDriver
implements Driver {
    public static final int DRIVER_MAJOR_VERSION = 4;
    public static final int DRIVER_MINOR_VERSION = 4;
    public static final int DRIVER_PATCH_VERSION = 0;
    public static final String DRIVER_NAME = "Cassandra JDBC Driver";
    private final LoadingCache<Map<String, String>, SessionHolder> sessionsCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Map<String, String>, SessionHolder>(){

        public SessionHolder load(@Nonnull Map<String, String> params) throws Exception {
            return new SessionHolder(params, (LoadingCache<Map<String, String>, SessionHolder>)CassandraDriver.this.sessionsCache);
        }
    });

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith("jdbc:cassandra:");
    }

    @Override
    public Connection connect(String url, Properties properties) throws SQLException {
        if (this.acceptsURL(url)) {
            ImmutableMap.Builder params = ImmutableMap.builder();
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                params.put((Object)key, (Object)properties.getProperty(key));
            }
            params.put((Object)"jdbcUrl", (Object)url);
            ImmutableMap cacheKey = params.build();
            try {
                SessionHolder sessionHolder;
                while (!(sessionHolder = (SessionHolder)this.sessionsCache.get((Object)cacheKey)).acquire()) {
                }
                return new CassandraConnection(sessionHolder);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLNonTransientConnectionException("Unexpected error while creating connection.", e);
            }
        }
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 4;
    }

    @Override
    public int getMinorVersion() {
        return 4;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties props) {
        Properties properties = props;
        if (props == null) {
            properties = new Properties();
        }
        DriverPropertyInfo[] info = new DriverPropertyInfo[2];
        info[0] = new DriverPropertyInfo("user", properties.getProperty("user"));
        info[0].description = "The 'user' property";
        info[1] = new DriverPropertyInfo("password", properties.getProperty("password"));
        info[1].description = "The 'password' property";
        return info;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    static {
        try {
            CassandraDriver driverInstance = new CassandraDriver();
            DriverManager.registerDriver(driverInstance);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

