/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.type.DefaultMapType;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ing.data.cassandra.jdbc.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.AbstractResultSet;
import com.ing.data.cassandra.jdbc.CassandraResultSetExtras;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.DataTypeEnum;
import com.ing.data.cassandra.jdbc.TypesMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.sql.rowset.serial.SerialBlob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraResultSet
extends AbstractResultSet
implements CassandraResultSetExtras {
    public static final CassandraResultSet EMPTY_RESULT_SET = new CassandraResultSet();
    public static final int DEFAULT_TYPE = 1003;
    public static final int DEFAULT_CONCURRENCY = 1007;
    public static final int DEFAULT_HOLDABILITY = 1;
    private static final Logger LOG = LoggerFactory.getLogger(CassandraResultSet.class);
    int rowNumber = 0;
    private final CResultSetMetaData metadata = new CResultSetMetaData();
    private final CassandraStatement statement;
    private Row currentRow;
    private Iterator<Row> rowsIterator;
    private int resultSetType;
    private int fetchDirection;
    private int fetchSize;
    private boolean wasNull;
    private ResultSet driverResultSet;

    CassandraResultSet() {
        this.statement = null;
    }

    CassandraResultSet(CassandraStatement statement, ResultSet resultSet) throws SQLException {
        this.statement = statement;
        this.resultSetType = statement.getResultSetType();
        this.fetchDirection = statement.getFetchDirection();
        this.fetchSize = statement.getFetchSize();
        this.driverResultSet = resultSet;
        this.rowsIterator = resultSet.iterator();
        if (this.hasMoreRows()) {
            this.populateColumns();
        }
    }

    CassandraResultSet(CassandraStatement statement, ArrayList<ResultSet> resultSets) throws SQLException {
        this.statement = statement;
        this.resultSetType = statement.getResultSetType();
        this.fetchDirection = statement.getFetchDirection();
        this.fetchSize = statement.getFetchSize();
        this.driverResultSet = resultSets.get(0);
        this.rowsIterator = this.driverResultSet.iterator();
        for (int i = 1; i < resultSets.size(); ++i) {
            this.rowsIterator = Iterators.concat(this.rowsIterator, (Iterator)resultSets.get(i).iterator());
        }
        if (this.hasMoreRows()) {
            this.populateColumns();
        }
    }

    private void populateColumns() {
        this.currentRow = this.rowsIterator.next();
    }

    @Override
    DataType getCqlDataType(int columnIndex) {
        return this.currentRow.getColumnDefinitions().get(columnIndex - 1).getType();
    }

    @Override
    DataType getCqlDataType(String columnLabel) {
        return this.currentRow.getColumnDefinitions().get(columnLabel).getType();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.resultSetType == 1003) {
            throw new SQLNonTransientException("Can not position cursor with a type of TYPE_FORWARD_ONLY.");
        }
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.resultSetType == 1003) {
            throw new SQLNonTransientException("Can not position cursor with a type of TYPE_FORWARD_ONLY.");
        }
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    private void checkIndex(int index) throws SQLException {
        if (this.currentRow != null) {
            this.wasNull = this.currentRow.isNull(index - 1);
            if (index < 1 || index > this.currentRow.getColumnDefinitions().size()) {
                throw new SQLSyntaxErrorException(String.format("Index must be a positive number less or equal the count of returned columns: %d", index) + " " + this.currentRow.getColumnDefinitions().size());
            }
        } else if (this.driverResultSet != null && (index < 1 || index > this.driverResultSet.getColumnDefinitions().size())) {
            throw new SQLSyntaxErrorException(String.format("Index must be a positive number less or equal the count of returned columns: %d", index) + " " + this.driverResultSet.getColumnDefinitions().size());
        }
    }

    private void checkName(String name) throws SQLException {
        if (this.currentRow != null) {
            this.wasNull = this.currentRow.isNull(name);
            if (!this.currentRow.getColumnDefinitions().contains(name)) {
                throw new SQLSyntaxErrorException(String.format("Name provided was not in the list of valid column labels: %s", name));
            }
        } else if (this.driverResultSet != null && !this.driverResultSet.getColumnDefinitions().contains(name)) {
            throw new SQLSyntaxErrorException(String.format("Name provided was not in the list of valid column labels: %s", name));
        }
    }

    private void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLRecoverableException("Method was called on a closed ResultSet.");
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.statement.close();
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkNotClosed();
        this.checkName(columnLabel);
        return this.currentRow.getColumnDefinitions().firstIndexOf(columnLabel);
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getBigDecimal(columnIndex - 1);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkIndex(columnIndex);
        BigDecimal decimalValue = this.currentRow.getBigDecimal(columnIndex - 1);
        if (decimalValue == null) {
            return null;
        }
        return decimalValue.setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getBigDecimal(columnLabel);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.checkName(columnLabel);
        BigDecimal decimalValue = this.currentRow.getBigDecimal(columnLabel);
        if (decimalValue == null) {
            return null;
        }
        return decimalValue.setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public BigInteger getBigInteger(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getBigInteger(columnIndex - 1);
    }

    @Override
    public BigInteger getBigInteger(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getBigInteger(columnLabel);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        ByteBuffer byteBuffer = this.currentRow.getByteBuffer(columnIndex - 1);
        if (byteBuffer != null) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes, 0, bytes.length);
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        ByteBuffer byteBuffer = this.currentRow.getByteBuffer(columnLabel);
        if (byteBuffer != null) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes, 0, bytes.length);
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        ByteBuffer byteBuffer = this.currentRow.getByteBuffer(columnIndex - 1);
        if (byteBuffer != null) {
            return new SerialBlob(byteBuffer.array());
        }
        return null;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        ByteBuffer byteBuffer = this.currentRow.getByteBuffer(columnLabel);
        if (byteBuffer != null) {
            return new SerialBlob(byteBuffer.array());
        }
        return null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getBoolean(columnIndex - 1);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getBoolean(columnLabel);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getByte(columnIndex - 1);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getByte(columnLabel);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        ByteBuffer byteBuffer = this.currentRow.getByteBuffer(columnIndex - 1);
        if (byteBuffer != null) {
            return byteBuffer.array();
        }
        return null;
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        ByteBuffer byteBuffer = this.currentRow.getByteBuffer(columnLabel);
        if (byteBuffer != null) {
            return byteBuffer.array();
        }
        return null;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkNotClosed();
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        LocalDate localDate = this.currentRow.getLocalDate(columnIndex - 1);
        if (localDate == null) {
            return null;
        }
        return Date.valueOf(localDate);
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        LocalDate localDate = this.currentRow.getLocalDate(columnLabel);
        if (localDate == null) {
            return null;
        }
        return Date.valueOf(localDate);
    }

    @Override
    public Date getDate(String columnLabel, Calendar calendar) throws SQLException {
        return this.getDate(columnLabel);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.isCqlType(columnIndex, DataTypeEnum.FLOAT)) {
            return this.currentRow.getFloat(columnIndex - 1);
        }
        return this.currentRow.getDouble(columnIndex - 1);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        if (this.isCqlType(columnLabel, DataTypeEnum.FLOAT)) {
            return this.currentRow.getFloat(columnLabel);
        }
        return this.currentRow.getDouble(columnLabel);
    }

    @Override
    public CqlDuration getDuration(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getCqlDuration(columnIndex - 1);
    }

    @Override
    public CqlDuration getDuration(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getCqlDuration(columnLabel);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        return this.fetchDirection;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkNotClosed();
        if (direction == 1000 || direction == 1001 || direction == 1002) {
            if (this.getType() == 1003 && direction != 1000) {
                throw new SQLSyntaxErrorException("attempt to set an illegal direction: " + direction);
            }
            this.fetchDirection = direction;
        }
        throw new SQLSyntaxErrorException(String.format("Fetch direction value of: %s is illegal.", direction));
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        this.checkNotClosed();
        if (size < 0) {
            throw new SQLException(String.format("Fetch size of: %s rows may not be negative.", size));
        }
        this.fetchSize = size;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getFloat(columnIndex - 1);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getFloat(columnLabel);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkNotClosed();
        return this.statement.getResultSetHoldability();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getInt(columnIndex - 1);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getInt(columnLabel);
    }

    @Override
    public List<?> getList(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        DataType cqlDataType = this.getCqlDataType(columnIndex);
        if (DataTypeEnum.fromCqlTypeName(cqlDataType.asCql(false, false)).isCollection()) {
            try {
                ListType listType = (ListType)cqlDataType;
                Class<?> itemsClass = Class.forName(DataTypeEnum.fromCqlTypeName(listType.getElementType().asCql(false, false)).asJavaClass().getCanonicalName());
                List resultList = this.currentRow.getList(columnIndex - 1, itemsClass);
                if (resultList == null) {
                    return null;
                }
                return Lists.newArrayList((Iterable)resultList);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Error while executing getList()", (Throwable)e);
            }
        }
        return this.currentRow.getList(columnIndex - 1, String.class);
    }

    @Override
    public List<?> getList(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        if (DataTypeEnum.fromCqlTypeName(this.getCqlDataType(columnLabel).asCql(false, false)).isCollection()) {
            try {
                ListType listType = (ListType)this.getCqlDataType(columnLabel);
                Class<?> itemsClass = Class.forName(DataTypeEnum.fromCqlTypeName(listType.getElementType().asCql(false, false)).asJavaClass().getCanonicalName());
                List resultList = this.currentRow.getList(columnLabel, itemsClass);
                if (resultList == null) {
                    return null;
                }
                return Lists.newArrayList((Iterable)resultList);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Error while executing getList()", (Throwable)e);
            }
        }
        return this.currentRow.getList(columnLabel, String.class);
    }

    public LocalDate getLocalDate(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getLocalDate(columnIndex - 1);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.isCqlType(columnIndex, DataTypeEnum.INT)) {
            return this.currentRow.getInt(columnIndex - 1);
        }
        if (this.isCqlType(columnIndex, DataTypeEnum.VARINT)) {
            BigInteger bigintValue = this.currentRow.getBigInteger(columnIndex - 1);
            if (bigintValue != null) {
                return bigintValue.longValue();
            }
            return 0L;
        }
        return this.currentRow.getLong(columnIndex - 1);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        if (this.isCqlType(columnLabel, DataTypeEnum.INT)) {
            return this.currentRow.getInt(columnLabel);
        }
        if (this.isCqlType(columnLabel, DataTypeEnum.VARINT)) {
            BigInteger bigintValue = this.currentRow.getBigInteger(columnLabel);
            if (bigintValue != null) {
                return bigintValue.longValue();
            }
            return 0L;
        }
        return this.currentRow.getLong(columnLabel);
    }

    @Override
    public Map<?, ?> getMap(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        DefaultMapType mapType = (DefaultMapType)this.getCqlDataType(columnIndex);
        Class<?> keysClass = DataTypeEnum.fromCqlTypeName((String)mapType.getKeyType().asCql((boolean)false, (boolean)false)).javaType;
        Class<?> valuesClass = DataTypeEnum.fromCqlTypeName((String)mapType.getValueType().asCql((boolean)false, (boolean)false)).javaType;
        return this.currentRow.getMap(columnIndex - 1, keysClass, valuesClass);
    }

    @Override
    public Map<?, ?> getMap(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        DefaultMapType mapType = (DefaultMapType)this.getCqlDataType(columnLabel);
        Class<?> keysClass = DataTypeEnum.fromCqlTypeName((String)mapType.getKeyType().asCql((boolean)false, (boolean)false)).javaType;
        Class<?> valuesClass = DataTypeEnum.fromCqlTypeName((String)mapType.getValueType().asCql((boolean)false, (boolean)false)).javaType;
        return this.currentRow.getMap(columnLabel, keysClass, valuesClass);
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.metadata;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        DataType cqlDataType = this.getCqlDataType(columnIndex);
        DataTypeEnum dataType = DataTypeEnum.fromCqlTypeName(cqlDataType.asCql(false, false));
        if (this.isCqlType(columnIndex, DataTypeEnum.UDT)) {
            return this.currentRow.getUdtValue(columnIndex - 1);
        }
        if (this.isCqlType(columnIndex, DataTypeEnum.TUPLE)) {
            return this.currentRow.getTupleValue(columnIndex - 1);
        }
        if (dataType.isCollection()) {
            if (this.isCqlType(columnIndex, DataTypeEnum.SET)) {
                SetType setType = (SetType)cqlDataType;
                DataType elementsType = setType.getElementType();
                Set resultSet = elementsType instanceof UserDefinedType ? this.currentRow.getSet(columnIndex - 1, TypesMap.getTypeForComparator(DataTypeEnum.UDT.asLowercaseCql()).getType()) : (elementsType instanceof TupleType ? this.currentRow.getSet(columnIndex - 1, TypesMap.getTypeForComparator(DataTypeEnum.TUPLE.asLowercaseCql()).getType()) : this.currentRow.getSet(columnIndex - 1, TypesMap.getTypeForComparator(elementsType.asCql(false, false)).getType()));
                if (resultSet == null) {
                    return null;
                }
                return Sets.newLinkedHashSet((Iterable)resultSet);
            }
            if (this.isCqlType(columnIndex, DataTypeEnum.LIST)) {
                ListType listType = (ListType)cqlDataType;
                DataType elementsType = listType.getElementType();
                List resultList = elementsType instanceof TupleType ? this.currentRow.getList(columnIndex - 1, TypesMap.getTypeForComparator(DataTypeEnum.TUPLE.asLowercaseCql()).getType()) : this.currentRow.getList(columnIndex - 1, TypesMap.getTypeForComparator(elementsType.asCql(false, false)).getType());
                if (resultList == null) {
                    return null;
                }
                return Lists.newArrayList((Iterable)resultList);
            }
            if (this.isCqlType(columnIndex, DataTypeEnum.MAP)) {
                MapType mapType = (MapType)cqlDataType;
                DataType keyType = mapType.getKeyType();
                DataType valueType = mapType.getValueType();
                Class<?> keyClass = TypesMap.getTypeForComparator(keyType.asCql(false, false)).getType();
                if (keyType instanceof UserDefinedType) {
                    keyClass = TypesMap.getTypeForComparator(DataTypeEnum.UDT.asLowercaseCql()).getType();
                } else if (keyType instanceof TupleType) {
                    keyClass = TypesMap.getTypeForComparator(DataTypeEnum.TUPLE.asLowercaseCql()).getType();
                }
                Class<?> valueClass = TypesMap.getTypeForComparator(valueType.asCql(false, false)).getType();
                if (valueType instanceof UserDefinedType) {
                    valueClass = TypesMap.getTypeForComparator(DataTypeEnum.UDT.asLowercaseCql()).getType();
                } else if (valueType instanceof TupleType) {
                    valueClass = TypesMap.getTypeForComparator(DataTypeEnum.TUPLE.asLowercaseCql()).getType();
                }
                Map resultMap = this.currentRow.getMap(columnIndex - 1, keyClass, valueClass);
                if (resultMap == null) {
                    return null;
                }
                return Maps.newHashMap((Map)resultMap);
            }
        } else {
            switch (dataType) {
                case VARCHAR: 
                case ASCII: 
                case TEXT: {
                    return this.currentRow.getString(columnIndex - 1);
                }
                case INT: 
                case VARINT: {
                    return this.currentRow.getInt(columnIndex - 1);
                }
                case SMALLINT: {
                    return this.currentRow.getShort(columnIndex - 1);
                }
                case TINYINT: {
                    return this.currentRow.getByte(columnIndex - 1);
                }
                case BIGINT: 
                case COUNTER: {
                    return this.currentRow.getLong(columnIndex - 1);
                }
                case BLOB: {
                    return this.currentRow.getByteBuffer(columnIndex - 1);
                }
                case BOOLEAN: {
                    return this.currentRow.getBoolean(columnIndex - 1);
                }
                case DECIMAL: {
                    return this.currentRow.getBigDecimal(columnIndex - 1);
                }
                case DOUBLE: {
                    return this.currentRow.getDouble(columnIndex - 1);
                }
                case FLOAT: {
                    return Float.valueOf(this.currentRow.getFloat(columnIndex - 1));
                }
                case INET: {
                    return this.currentRow.getInetAddress(columnIndex - 1);
                }
                case DATE: {
                    return this.getDate(columnIndex);
                }
                case TIME: {
                    return this.getTime(columnIndex);
                }
                case TIMESTAMP: {
                    return this.getTimestamp(columnIndex);
                }
                case DURATION: {
                    return this.currentRow.getCqlDuration(columnIndex - 1);
                }
                case UUID: 
                case TIMEUUID: {
                    return this.currentRow.getUuid(columnIndex - 1);
                }
            }
        }
        return null;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        DataType cqlDataType = this.getCqlDataType(columnLabel);
        DataTypeEnum dataType = DataTypeEnum.fromCqlTypeName(cqlDataType.asCql(false, false));
        if (this.isCqlType(columnLabel, DataTypeEnum.UDT)) {
            return this.currentRow.getUdtValue(columnLabel);
        }
        if (this.isCqlType(columnLabel, DataTypeEnum.TUPLE)) {
            return this.currentRow.getTupleValue(columnLabel);
        }
        if (dataType.isCollection()) {
            if (this.isCqlType(columnLabel, DataTypeEnum.SET)) {
                SetType setType = (SetType)cqlDataType;
                DataType elementsType = setType.getElementType();
                Set resultSet = elementsType instanceof UserDefinedType ? this.currentRow.getSet(columnLabel, TypesMap.getTypeForComparator(DataTypeEnum.UDT.asLowercaseCql()).getType()) : (elementsType instanceof TupleType ? this.currentRow.getSet(columnLabel, TypesMap.getTypeForComparator(DataTypeEnum.TUPLE.asLowercaseCql()).getType()) : this.currentRow.getSet(columnLabel, TypesMap.getTypeForComparator(elementsType.asCql(false, false)).getType()));
                if (resultSet == null) {
                    return null;
                }
                return Sets.newLinkedHashSet((Iterable)resultSet);
            }
            if (this.isCqlType(columnLabel, DataTypeEnum.LIST)) {
                ListType listType = (ListType)cqlDataType;
                DataType elementsType = listType.getElementType();
                List resultList = elementsType instanceof TupleType ? this.currentRow.getList(columnLabel, TypesMap.getTypeForComparator(DataTypeEnum.TUPLE.asLowercaseCql()).getType()) : this.currentRow.getList(columnLabel, TypesMap.getTypeForComparator(elementsType.asCql(false, false)).getType());
                if (resultList == null) {
                    return null;
                }
                return Lists.newArrayList((Iterable)resultList);
            }
            if (this.isCqlType(columnLabel, DataTypeEnum.MAP)) {
                MapType mapType = (MapType)cqlDataType;
                DataType keyType = mapType.getKeyType();
                DataType valueType = mapType.getValueType();
                Class<?> keyClass = TypesMap.getTypeForComparator(keyType.asCql(false, false)).getType();
                if (keyType instanceof UserDefinedType) {
                    keyClass = TypesMap.getTypeForComparator(DataTypeEnum.UDT.asLowercaseCql()).getType();
                } else if (keyType instanceof TupleType) {
                    keyClass = TypesMap.getTypeForComparator(DataTypeEnum.TUPLE.asLowercaseCql()).getType();
                }
                Class<?> valueClass = TypesMap.getTypeForComparator(valueType.asCql(false, false)).getType();
                if (valueType instanceof UserDefinedType) {
                    valueClass = TypesMap.getTypeForComparator(DataTypeEnum.UDT.asLowercaseCql()).getType();
                } else if (valueType instanceof TupleType) {
                    valueClass = TypesMap.getTypeForComparator(DataTypeEnum.TUPLE.asLowercaseCql()).getType();
                }
                Map resultMap = this.currentRow.getMap(columnLabel, keyClass, valueClass);
                if (resultMap == null) {
                    return null;
                }
                return Maps.newHashMap((Map)resultMap);
            }
        } else {
            switch (dataType) {
                case VARCHAR: 
                case ASCII: 
                case TEXT: {
                    return this.currentRow.getString(columnLabel);
                }
                case INT: 
                case VARINT: {
                    return this.currentRow.getInt(columnLabel);
                }
                case SMALLINT: {
                    return this.currentRow.getShort(columnLabel);
                }
                case TINYINT: {
                    return this.currentRow.getByte(columnLabel);
                }
                case BIGINT: 
                case COUNTER: {
                    return this.currentRow.getLong(columnLabel);
                }
                case BLOB: {
                    return this.currentRow.getByteBuffer(columnLabel);
                }
                case BOOLEAN: {
                    return this.currentRow.getBoolean(columnLabel);
                }
                case DECIMAL: {
                    return this.currentRow.getBigDecimal(columnLabel);
                }
                case DOUBLE: {
                    return this.currentRow.getDouble(columnLabel);
                }
                case FLOAT: {
                    return Float.valueOf(this.currentRow.getFloat(columnLabel));
                }
                case INET: {
                    return this.currentRow.getInetAddress(columnLabel);
                }
                case DATE: {
                    return this.getDate(columnLabel);
                }
                case TIME: {
                    return this.getTime(columnLabel);
                }
                case TIMESTAMP: {
                    return this.getTimestamp(columnLabel);
                }
                case DURATION: {
                    return this.currentRow.getCqlDuration(columnLabel);
                }
                case UUID: 
                case TIMEUUID: {
                    return this.currentRow.getUuid(columnLabel);
                }
            }
        }
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        int index = this.findColumn(columnLabel);
        return this.getObject(index + 1, type);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        Comparable<ChronoLocalDateTime<?>> returnValue;
        if (type == String.class) {
            returnValue = this.getString(columnIndex);
        } else if (type == Byte.class) {
            byte byteValue = this.getByte(columnIndex);
            returnValue = this.valueOrNull(byteValue);
        } else if (type == Short.class) {
            short shortValue = this.getShort(columnIndex);
            returnValue = this.valueOrNull(shortValue);
        } else if (type == Integer.class) {
            int intValue = this.getInt(columnIndex);
            returnValue = this.valueOrNull(intValue);
        } else if (type == Long.class) {
            long longValue = this.getLong(columnIndex);
            returnValue = this.valueOrNull(longValue);
        } else if (type == BigDecimal.class) {
            returnValue = this.getBigDecimal(columnIndex);
        } else if (type == Boolean.class) {
            boolean booleanValue = this.getBoolean(columnIndex);
            returnValue = this.valueOrNull(booleanValue);
        } else if (type == Date.class) {
            returnValue = this.getDate(columnIndex);
        } else if (type == Time.class) {
            returnValue = this.getTime(columnIndex);
        } else if (type == Timestamp.class) {
            returnValue = this.getTimestamp(columnIndex);
        } else if (type == LocalDate.class) {
            returnValue = this.getLocalDate(columnIndex);
        } else if (type == LocalDateTime.class || type == LocalTime.class) {
            Timestamp timestamp = this.getTimestamp(columnIndex, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            if (timestamp == null) {
                returnValue = null;
            } else {
                LocalDateTime ldt = LocalDateTime.ofInstant(timestamp.toInstant(), ZoneId.of("UTC"));
                returnValue = type == LocalDateTime.class ? ldt : ldt.toLocalTime();
            }
        } else if (type == OffsetDateTime.class) {
            Timestamp timestamp = this.getTimestamp(columnIndex);
            returnValue = timestamp == null ? null : this.getOffsetDateTime(timestamp);
        } else if (type == OffsetTime.class) {
            Time time = this.getTime(columnIndex);
            returnValue = time == null ? null : this.getOffsetTime(time);
        } else if (type == UUID.class) {
            String uuidString = this.getString(columnIndex);
            returnValue = this.valueOrNull(UUID.fromString(uuidString));
        } else if (type == SQLXML.class) {
            returnValue = this.getSQLXML(columnIndex);
        } else if (type == Blob.class) {
            returnValue = this.getBlob(columnIndex);
        } else if (type == Clob.class) {
            returnValue = this.getClob(columnIndex);
        } else if (type == NClob.class) {
            returnValue = this.getNClob(columnIndex);
        } else if (type == byte[].class) {
            returnValue = (Comparable<ChronoLocalDateTime<?>>)this.getBytes(columnIndex);
        } else if (type == Float.class) {
            float floatValue = this.getFloat(columnIndex);
            returnValue = this.valueOrNull(Float.valueOf(floatValue));
        } else if (type == Double.class) {
            double doubleValue = this.getDouble(columnIndex);
            returnValue = this.valueOrNull(doubleValue);
        } else if (type == CqlDuration.class) {
            returnValue = this.getDuration(columnIndex);
        } else if (type == URL.class) {
            returnValue = this.getURL(columnIndex);
        } else {
            throw new SQLException(String.format("Conversion to type %s not supported.", type.getSimpleName()));
        }
        return type.cast(returnValue);
    }

    private String getObjectAsString(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o != null) {
            return String.valueOf(o);
        }
        return null;
    }

    private String getObjectAsString(String columnLabel) throws SQLException {
        Object o = this.getObject(columnLabel);
        if (o != null) {
            return String.valueOf(o);
        }
        return null;
    }

    private OffsetDateTime getOffsetDateTime(Timestamp timestamp) {
        if (timestamp != null) {
            return OffsetDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault());
        }
        return null;
    }

    private OffsetTime getOffsetTime(Time time) {
        if (time != null) {
            return time.toLocalTime().atOffset(OffsetTime.now().getOffset());
        }
        return null;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber;
    }

    @Override
    public RowId getRowId(int columnIndex) {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) {
        return null;
    }

    @Override
    public Set<?> getSet(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        try {
            SetType setType = (SetType)this.getCqlDataType(columnIndex);
            return this.currentRow.getSet(columnIndex - 1, Class.forName(DataTypeEnum.fromCqlTypeName(setType.getElementType().asCql(false, false)).asJavaClass().getCanonicalName()));
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Error while executing getSet()", (Throwable)e);
            return null;
        }
    }

    @Override
    public Set<?> getSet(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        try {
            SetType setType = (SetType)this.getCqlDataType(columnLabel);
            return this.currentRow.getSet(columnLabel, Class.forName(DataTypeEnum.fromCqlTypeName(setType.getElementType().asCql(false, false)).asJavaClass().getCanonicalName()));
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Error while executing getSet()", (Throwable)e);
            return null;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getShort(columnIndex - 1);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getShort(columnLabel);
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkNotClosed();
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        try {
            if (DataTypeEnum.fromCqlTypeName(this.getCqlDataType(columnIndex).asCql(false, false)).isCollection()) {
                return this.getObjectAsString(columnIndex);
            }
            return this.currentRow.getString(columnIndex - 1);
        }
        catch (Exception e) {
            return this.getObjectAsString(columnIndex);
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        try {
            if (DataTypeEnum.fromCqlTypeName(this.getCqlDataType(columnLabel).asCql(false, false)).isCollection()) {
                return this.getObjectAsString(columnLabel);
            }
            return this.currentRow.getString(columnLabel);
        }
        catch (Exception e) {
            return this.getObjectAsString(columnLabel);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        LocalTime localTime = this.currentRow.getLocalTime(columnIndex - 1);
        if (localTime == null) {
            return null;
        }
        return Time.valueOf(localTime);
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        LocalTime localTime = this.currentRow.getLocalTime(columnLabel);
        if (localTime == null) {
            return null;
        }
        return Time.valueOf(localTime);
    }

    @Override
    public Time getTime(String columnLabel, Calendar calendar) throws SQLException {
        return this.getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        Instant instant = this.currentRow.getInstant(columnIndex - 1);
        if (instant == null) {
            return null;
        }
        return Timestamp.from(instant);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        Instant instant = this.currentRow.getInstant(columnLabel);
        if (instant == null) {
            return null;
        }
        return Timestamp.from(instant);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar calendar) throws SQLException {
        return this.getTimestamp(columnLabel);
    }

    @Override
    public int getType() throws SQLException {
        this.checkNotClosed();
        return this.resultSetType;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        String storedUrl = this.currentRow.getString(columnIndex - 1);
        if (storedUrl == null) {
            return null;
        }
        try {
            return new URL(storedUrl);
        }
        catch (MalformedURLException e) {
            throw new SQLException(String.format("The string '%s' is not a valid URL.", storedUrl), e);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        String storedUrl = this.currentRow.getString(columnLabel);
        if (storedUrl == null) {
            return null;
        }
        try {
            return new URL(storedUrl);
        }
        catch (MalformedURLException e) {
            throw new SQLException(String.format("The string '%s' is not a valid URL.", storedUrl), e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    protected boolean hasMoreRows() {
        return this.rowsIterator != null && (this.rowsIterator.hasNext() || this.rowNumber == 0 && this.currentRow != null);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber == Integer.MAX_VALUE;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber == 0;
    }

    @Override
    public boolean isClosed() {
        if (this.statement == null) {
            return true;
        }
        return this.statement.isClosed();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkNotClosed();
        return !this.rowsIterator.hasNext();
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public synchronized boolean next() {
        if (this.hasMoreRows()) {
            if (this.rowNumber != 0) {
                this.populateColumns();
            }
            ++this.rowNumber;
            return true;
        }
        this.rowNumber = Integer.MAX_VALUE;
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public boolean relative(int arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    private <T> T valueOrNull(T value) {
        if (this.wasNull()) {
            return null;
        }
        return value;
    }

    class CResultSetMetaData
    implements ResultSetMetaData {
        CResultSetMetaData() {
        }

        @Override
        public String getCatalogName(int column) throws SQLException {
            if (CassandraResultSet.this.statement == null) {
                return null;
            }
            return ((CassandraResultSet)CassandraResultSet.this).statement.connection.getCatalog();
        }

        @Override
        public String getColumnClassName(int column) {
            if (CassandraResultSet.this.currentRow != null) {
                return DataTypeEnum.fromCqlTypeName(CassandraResultSet.this.getCqlDataType(column).asCql(false, false)).asJavaClass().getCanonicalName();
            }
            return DataTypeEnum.fromCqlTypeName(CassandraResultSet.this.driverResultSet.getColumnDefinitions().get(column - 1).getType().asCql(false, false)).asJavaClass().getCanonicalName();
        }

        @Override
        public int getColumnCount() {
            try {
                if (CassandraResultSet.this.currentRow != null) {
                    return CassandraResultSet.this.currentRow.getColumnDefinitions().size();
                }
                return CassandraResultSet.this.driverResultSet.getColumnDefinitions().size();
            }
            catch (Exception e) {
                return 0;
            }
        }

        @Override
        public int getColumnDisplaySize(int column) {
            try {
                ColumnDefinition columnDefinition = CassandraResultSet.this.currentRow != null ? CassandraResultSet.this.currentRow.getColumnDefinitions().get(column - 1) : CassandraResultSet.this.driverResultSet.getColumnDefinitions().get(column - 1);
                AbstractJdbcType<?> jdbcEquivalentType = TypesMap.getTypeForComparator(columnDefinition.getType().toString());
                int length = -1;
                if (jdbcEquivalentType != null) {
                    length = jdbcEquivalentType.getPrecision(null);
                }
                return length;
            }
            catch (Exception e) {
                return -1;
            }
        }

        @Override
        public String getColumnLabel(int column) {
            return this.getColumnName(column);
        }

        @Override
        public String getColumnName(int column) {
            if (CassandraResultSet.this.currentRow != null) {
                return CassandraResultSet.this.currentRow.getColumnDefinitions().get(column - 1).getName().asInternal();
            }
            return CassandraResultSet.this.driverResultSet.getColumnDefinitions().get(column - 1).getName().asInternal();
        }

        @Override
        public int getColumnType(int column) {
            DataType dataType = CassandraResultSet.this.currentRow != null ? CassandraResultSet.this.currentRow.getColumnDefinitions().get(column - 1).getType() : CassandraResultSet.this.driverResultSet.getColumnDefinitions().get(column - 1).getType();
            return TypesMap.getTypeForComparator(dataType.toString()).getJdbcType();
        }

        @Override
        public String getColumnTypeName(int column) {
            DataType dataType = CassandraResultSet.this.currentRow != null ? CassandraResultSet.this.currentRow.getColumnDefinitions().get(column - 1).getType() : CassandraResultSet.this.driverResultSet.getColumnDefinitions().get(column - 1).getType();
            return dataType.toString();
        }

        @Override
        public int getPrecision(int column) {
            return Math.max(this.getColumnDisplaySize(column), 0);
        }

        @Override
        public int getScale(int column) {
            try {
                ColumnDefinition columnDefinition = CassandraResultSet.this.currentRow != null ? CassandraResultSet.this.currentRow.getColumnDefinitions().get(column - 1) : CassandraResultSet.this.driverResultSet.getColumnDefinitions().get(column - 1);
                AbstractJdbcType<?> jdbcEquivalentType = TypesMap.getTypeForComparator(columnDefinition.getType().toString());
                int scale = 0;
                if (jdbcEquivalentType != null) {
                    scale = jdbcEquivalentType.getScale(null);
                }
                return scale;
            }
            catch (Exception e) {
                return 0;
            }
        }

        @Override
        public String getSchemaName(int column) throws SQLException {
            if (CassandraResultSet.this.statement == null) {
                return null;
            }
            return ((CassandraResultSet)CassandraResultSet.this).statement.connection.getSchema();
        }

        @Override
        public String getTableName(int column) {
            String tableName = CassandraResultSet.this.currentRow != null ? CassandraResultSet.this.currentRow.getColumnDefinitions().get(column - 1).getTable().asInternal() : CassandraResultSet.this.driverResultSet.getColumnDefinitions().get(column - 1).getTable().asInternal();
            return tableName;
        }

        @Override
        public boolean isAutoIncrement(int column) {
            return false;
        }

        @Override
        public boolean isCaseSensitive(int column) {
            return true;
        }

        @Override
        public boolean isCurrency(int column) {
            return false;
        }

        @Override
        public boolean isDefinitelyWritable(int column) {
            return this.isWritable(column);
        }

        @Override
        public int isNullable(int column) {
            return 1;
        }

        @Override
        public boolean isReadOnly(int column) {
            return column == 0;
        }

        @Override
        public boolean isSearchable(int column) {
            return false;
        }

        @Override
        public boolean isSigned(int column) {
            return false;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return false;
        }

        @Override
        public boolean isWritable(int column) {
            return column > 0;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLFeatureNotSupportedException(String.format("No object was found that matched the provided interface: %s", iface.getSimpleName()));
        }
    }
}

