/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummary;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.UnsupportedOperationException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlob;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.ListBlobItem;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class AzureObjectSummariesIterator
implements Iterator<StorageObjectSummary> {
    private static final SFLogger logger = SFLoggerFactory.getLogger(AzureObjectSummariesIterator.class);
    Iterator<ListBlobItem> itemIterator;

    public AzureObjectSummariesIterator(Iterable<ListBlobItem> azCloudBlobIterable) {
        this.itemIterator = azCloudBlobIterable.iterator();
    }

    @Override
    public boolean hasNext() {
        try {
            return this.itemIterator.hasNext();
        }
        catch (NoSuchElementException ex) {
            logger.debug("Failed to run azure iterator.hasNext().", ex);
            throw new StorageProviderException((Exception)ex.getCause());
        }
    }

    @Override
    public StorageObjectSummary next() {
        ListBlobItem listBlobItem = this.itemIterator.next();
        if (!(listBlobItem instanceof CloudBlob)) {
            logger.debug("Unexpected listBlobItem instance type: {}", listBlobItem.getClass());
            throw new IllegalArgumentException("Unexpected listBlobItem instance type");
        }
        return StorageObjectSummary.createFromAzureListBlobItem(listBlobItem);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method not supported");
    }
}

