/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.crmf;

import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Encodable;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1EncodableVector;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Object;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Primitive;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Sequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1UTF8String;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERSequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.GeneralName;

public class EncKeyWithID
extends ASN1Object {
    private final PrivateKeyInfo privKeyInfo;
    private final ASN1Encodable identifier;

    public static EncKeyWithID getInstance(Object object) {
        if (object instanceof EncKeyWithID) {
            return (EncKeyWithID)object;
        }
        if (object != null) {
            return new EncKeyWithID(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private EncKeyWithID(ASN1Sequence aSN1Sequence) {
        this.privKeyInfo = PrivateKeyInfo.getInstance(aSN1Sequence.getObjectAt(0));
        this.identifier = aSN1Sequence.size() > 1 ? (!(aSN1Sequence.getObjectAt(1) instanceof ASN1UTF8String) ? GeneralName.getInstance(aSN1Sequence.getObjectAt(1)) : aSN1Sequence.getObjectAt(1)) : null;
    }

    public EncKeyWithID(PrivateKeyInfo privateKeyInfo) {
        this.privKeyInfo = privateKeyInfo;
        this.identifier = null;
    }

    public EncKeyWithID(PrivateKeyInfo privateKeyInfo, ASN1UTF8String aSN1UTF8String) {
        this.privKeyInfo = privateKeyInfo;
        this.identifier = aSN1UTF8String;
    }

    public EncKeyWithID(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        this.privKeyInfo = privateKeyInfo;
        this.identifier = generalName;
    }

    public PrivateKeyInfo getPrivateKey() {
        return this.privKeyInfo;
    }

    public boolean hasIdentifier() {
        return this.identifier != null;
    }

    public boolean isIdentifierUTF8String() {
        return this.identifier instanceof ASN1UTF8String;
    }

    public ASN1Encodable getIdentifier() {
        return this.identifier;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.privKeyInfo);
        if (this.identifier != null) {
            aSN1EncodableVector.add(this.identifier);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

