/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.wire.AbstractFbWireOutputBlob;
import org.firebirdsql.gds.ng.wire.FbWireBlob;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.GenericResponse;

public class V10OutputBlob
extends AbstractFbWireOutputBlob
implements FbWireBlob,
DatabaseListener {
    public V10OutputBlob(FbWireDatabase database, FbWireTransaction transaction, BlobParameterBuffer blobParameterBuffer) {
        super(database, transaction, blobParameterBuffer);
    }

    @Override
    public void open() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkDatabaseAttached();
            this.checkTransactionActive();
            this.checkBlobClosed();
            if (this.getBlobId() != 0L) {
                throw new FbExceptionBuilder().nonTransientException(335544368).toSQLException();
            }
            FbWireDatabase database = this.getDatabase();
            try {
                XdrOutputStream xdrOut = database.getXdrStreamAccess().getXdrOut();
                BlobParameterBuffer blobParameterBuffer = this.getBlobParameterBuffer();
                if (blobParameterBuffer == null) {
                    xdrOut.writeInt(34);
                } else {
                    xdrOut.writeInt(57);
                    xdrOut.writeTyped(blobParameterBuffer);
                }
                xdrOut.writeInt(this.getTransaction().getHandle());
                xdrOut.writeLong(0L);
                xdrOut.flush();
            }
            catch (IOException e) {
                throw new FbExceptionBuilder().exception(335544727).cause(e).toSQLException();
            }
            try {
                GenericResponse genericResponse = database.readGenericResponse(null);
                this.setHandle(genericResponse.getObjectHandle());
                this.setBlobId(genericResponse.getBlobId());
                this.setOpen(true);
            }
            catch (IOException e) {
                throw new FbExceptionBuilder().exception(335544726).cause(e).toSQLException();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public void putSegment(byte[] segment) throws SQLException {
        try {
            if (segment.length == 0) {
                throw new FbExceptionBuilder().exception(337248258).toSQLException();
            }
            if (segment.length > this.getMaximumSegmentSize()) {
                throw new FbExceptionBuilder().exception(337248259).toSQLException();
            }
            try (LockCloseable ignored = this.withLock();){
                this.checkDatabaseAttached();
                this.checkTransactionActive();
                this.checkBlobOpen();
                FbWireDatabase database = this.getDatabase();
                try {
                    XdrOutputStream xdrOut = database.getXdrStreamAccess().getXdrOut();
                    xdrOut.writeInt(37);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.writeInt(segment.length);
                    xdrOut.writeBuffer(segment);
                    xdrOut.flush();
                }
                catch (IOException e) {
                    throw new FbExceptionBuilder().exception(335544727).cause(e).toSQLException();
                }
                try {
                    database.readResponse(null);
                }
                catch (IOException e) {
                    throw new FbExceptionBuilder().exception(335544726).cause(e).toSQLException();
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }
}

