/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Regeneration;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ShieldBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.FloatingText;
import com.shatteredpixel.shatteredpixeldungeon.effects.SpellSprite;
import com.shatteredpixel.shatteredpixeldungeon.items.BrokenSeal;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.GameMath;
import java.util.Iterator;

public class Berserk
extends Buff
implements ActionIndicator.Action {
    private State state;
    private static final float LEVEL_RECOVER_START = 4.0f;
    private float levelRecovery;
    private static final int TURN_RECOVERY_START = 100;
    private int turnRecovery;
    public int powerLossBuffer;
    private float power;
    private static final String STATE = "state";
    private static final String LEVEL_RECOVERY = "levelrecovery";
    private static final String TURN_RECOVERY = "turn_recovery";
    private static final String POWER = "power";
    private static final String POWER_BUFFER = "power_buffer";

    public Berserk() {
        this.type = Buff.buffType.POSITIVE;
        this.state = State.NORMAL;
        this.powerLossBuffer = 0;
        this.power = 0.0f;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(STATE, this.state);
        bundle.put(POWER, this.power);
        bundle.put(POWER_BUFFER, this.powerLossBuffer);
        bundle.put(LEVEL_RECOVERY, this.levelRecovery);
        bundle.put(TURN_RECOVERY, this.turnRecovery);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.state = bundle.getEnum(STATE, State.class);
        this.power = bundle.getFloat(POWER);
        this.powerLossBuffer = bundle.getInt(POWER_BUFFER);
        this.levelRecovery = bundle.getFloat(LEVEL_RECOVERY);
        this.turnRecovery = bundle.getInt(TURN_RECOVERY);
        if (this.power >= 1.0f && this.state == State.NORMAL) {
            ActionIndicator.setAction(this);
        }
    }

    @Override
    public boolean act() {
        if (this.state == State.BERSERK) {
            ShieldBuff buff = this.target.buff(BrokenSeal.WarriorShield.class);
            if (this.target.shielding() > 0) {
                int dmg = (int)Math.ceil((float)this.target.shielding() * 0.025f);
                if (buff != null && buff.shielding() > 0) {
                    dmg = buff.absorbDamage(dmg);
                }
                if (dmg > 0) {
                    ShieldBuff s;
                    Iterator<ShieldBuff> iterator = this.target.buffs(ShieldBuff.class).iterator();
                    while (iterator.hasNext() && (dmg = (s = iterator.next()).absorbDamage(dmg)) != 0) {
                    }
                }
                if (this.target.shielding() <= 0) {
                    this.state = State.RECOVERING;
                    this.power = 0.0f;
                    BuffIndicator.refreshHero();
                    if (!this.target.isAlive()) {
                        this.target.die(this);
                        if (!this.target.isAlive()) {
                            Dungeon.fail(this);
                        }
                    }
                }
            } else {
                this.state = State.RECOVERING;
                this.power = 0.0f;
                if (!this.target.isAlive()) {
                    this.target.die(this);
                    if (!this.target.isAlive()) {
                        Dungeon.fail(this);
                    }
                }
            }
        } else if (this.state == State.NORMAL) {
            if (this.powerLossBuffer > 0) {
                --this.powerLossBuffer;
            } else {
                this.power = (float)((double)this.power - (double)(GameMath.gate(0.1f, this.power, 1.0f) * 0.067f) * Math.pow((float)this.target.HP / (float)this.target.HT, 2.0));
                if (this.power < 1.0f) {
                    ActionIndicator.clearAction(this);
                } else {
                    ActionIndicator.refresh();
                }
                if (this.power <= 0.0f) {
                    this.detach();
                }
            }
        } else if (this.state == State.RECOVERING && this.levelRecovery == 0.0f && Regeneration.regenOn()) {
            --this.turnRecovery;
            if (this.turnRecovery <= 0) {
                this.turnRecovery = 0;
                this.state = State.NORMAL;
            }
        }
        this.spend(1.0f);
        return true;
    }

    @Override
    public void detach() {
        super.detach();
        ActionIndicator.clearAction(this);
    }

    public float enchantFactor(float chance) {
        return chance + Math.min(1.0f, this.power) * 0.15f * (float)((Hero)this.target).pointsInTalent(Talent.ENRAGED_CATALYST);
    }

    public float damageFactor(float dmg) {
        return dmg * Math.min(1.5f, 1.0f + this.power / 2.0f);
    }

    public boolean berserking() {
        if (this.target.HP == 0 && this.state == State.NORMAL && this.power >= 1.0f && this.target.buff(BrokenSeal.WarriorShield.class) != null && ((Hero)this.target).hasTalent(Talent.DEATHLESS_FURY)) {
            this.startBerserking();
            ActionIndicator.clearAction(this);
        }
        return this.state == State.BERSERK && this.target.shielding() > 0;
    }

    private void startBerserking() {
        this.state = State.BERSERK;
        SpellSprite.show(this.target, 3);
        Sample.INSTANCE.play("sounds/challenge.mp3");
        GameScene.flash(0xFF0000);
        if (this.target.HP > 0) {
            this.turnRecovery = 100;
            this.levelRecovery = 0.0f;
        } else {
            this.levelRecovery = 4.0f - (float)((Hero)this.target).pointsInTalent(Talent.DEATHLESS_FURY);
            this.turnRecovery = 0;
        }
        float shieldMultiplier = 2.0f + 4.0f * (float)Math.pow(1.0f - (float)this.target.HP / (float)this.target.HT, 3.0);
        if (this.power > 1.0f) {
            shieldMultiplier *= this.power;
            this.levelRecovery *= 2.0f - this.power;
            this.turnRecovery = (int)((float)this.turnRecovery * (2.0f - this.power));
        }
        BrokenSeal.WarriorShield shield = this.target.buff(BrokenSeal.WarriorShield.class);
        int shieldAmount = Math.round((float)shield.maxShield() * shieldMultiplier);
        shield.supercharge(shieldAmount);
        this.target.sprite.showStatusWithIcon(65280, Integer.toString(shieldAmount), FloatingText.SHIELDING, new Object[0]);
        BuffIndicator.refreshHero();
    }

    public void damage(int damage) {
        if (this.state != State.NORMAL) {
            return;
        }
        float maxPower = 1.0f + 0.1667f * (float)((Hero)this.target).pointsInTalent(Talent.ENDLESS_RAGE);
        this.power = Math.min(maxPower, this.power + (float)damage / (float)this.target.HT / 3.0f);
        BuffIndicator.refreshHero();
        this.powerLossBuffer = 3;
        if (this.power >= 1.0f) {
            ActionIndicator.setAction(this);
        }
    }

    public void recover(float percent) {
        if (this.state == State.RECOVERING && this.levelRecovery > 0.0f) {
            this.levelRecovery -= percent;
            if (this.levelRecovery <= 0.0f) {
                this.levelRecovery = 0.0f;
                if (this.turnRecovery == 0) {
                    this.state = State.NORMAL;
                }
            }
        }
    }

    @Override
    public String actionName() {
        return Messages.get(this, "action_name", new Object[0]);
    }

    @Override
    public int actionIcon() {
        return 32;
    }

    @Override
    public Visual secondaryVisual() {
        BitmapText txt = new BitmapText(PixelScene.pixelFont);
        txt.text((int)(this.power * 100.0f) + "%");
        txt.hardlight(65280);
        txt.measure();
        return txt;
    }

    @Override
    public int indicatorColor() {
        return 0x660000;
    }

    @Override
    public void doAction() {
        BrokenSeal.WarriorShield shield = this.target.buff(BrokenSeal.WarriorShield.class);
        if (shield != null && shield.maxShield() > 0) {
            this.startBerserking();
            ActionIndicator.clearAction(this);
        } else {
            GLog.w(Messages.get(this, "no_seal", new Object[0]), new Object[0]);
        }
    }

    @Override
    public int icon() {
        return 40;
    }

    @Override
    public void tintIcon(Image icon) {
        switch (this.state) {
            default: {
                if (this.power < 1.0f) {
                    icon.hardlight(1.0f, 0.5f, 0.0f);
                    break;
                }
                icon.hardlight(1.0f, 0.0f, 0.0f);
                break;
            }
            case BERSERK: {
                icon.hardlight(1.0f, 0.0f, 0.0f);
                break;
            }
            case RECOVERING: {
                icon.hardlight(0.0f, 0.0f, 1.0f);
            }
        }
    }

    @Override
    public float iconFadePercent() {
        switch (this.state) {
            default: {
                float maxPower = 1.0f + 0.1667f * (float)((Hero)this.target).pointsInTalent(Talent.ENDLESS_RAGE);
                return (maxPower - this.power) / maxPower;
            }
            case BERSERK: {
                return 0.0f;
            }
            case RECOVERING: 
        }
        if (this.levelRecovery > 0.0f) {
            return 1.0f - this.levelRecovery / (4.0f - (float)Dungeon.hero.pointsInTalent(Talent.DEATHLESS_FURY));
        }
        return 1.0f - (float)this.turnRecovery / 100.0f;
    }

    @Override
    public String iconTextDisplay() {
        switch (this.state) {
            default: {
                return (int)(this.power * 100.0f) + "%";
            }
            case RECOVERING: 
        }
        if (this.levelRecovery > 0.0f) {
            return Messages.decimalFormat("#.##", this.levelRecovery);
        }
        return Integer.toString(this.turnRecovery);
    }

    @Override
    public String name() {
        switch (this.state) {
            default: {
                return Messages.get(this, "angered", new Object[0]);
            }
            case BERSERK: {
                return Messages.get(this, "berserk", new Object[0]);
            }
            case RECOVERING: 
        }
        return Messages.get(this, "recovering", new Object[0]);
    }

    @Override
    public String desc() {
        float dispDamage = (float)((int)this.damageFactor(10000.0f)) / 100.0f - 100.0f;
        switch (this.state) {
            default: {
                return Messages.get(this, "angered_desc", Math.floor(this.power * 100.0f), Float.valueOf(dispDamage));
            }
            case BERSERK: {
                return Messages.get(this, "berserk_desc", new Object[0]);
            }
            case RECOVERING: 
        }
        if (this.levelRecovery > 0.0f) {
            return Messages.get(this, "recovering_desc", new Object[0]) + "\n\n" + Messages.get(this, "recovering_desc_levels", Float.valueOf(this.levelRecovery));
        }
        return Messages.get(this, "recovering_desc", new Object[0]) + "\n\n" + Messages.get(this, "recovering_desc_turns", this.turnRecovery);
    }

    private static enum State {
        NORMAL,
        BERSERK,
        RECOVERING;

    }
}

