/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import java.util.Iterator;

public final class IntMapUtils {
    public static final int[] flattenSortedByKey(IntIntHashMap map) {
        int[] result = new int[map.size() * 2];
        int index = 0;
        if (map.size() == 2) {
            Iterator iterator = map.iterator();
            IntIntCursor c = (IntIntCursor)iterator.next();
            int k1 = c.key;
            int v1 = c.value;
            c = (IntIntCursor)iterator.next();
            int k2 = c.key;
            int v2 = c.value;
            if (k1 <= k2) {
                result[0] = k1;
                result[1] = v1;
                result[2] = k2;
                result[3] = v2;
            } else {
                result[0] = k2;
                result[1] = v2;
                result[2] = k1;
                result[3] = v1;
            }
        } else {
            BitSet bset = new BitSet((long)map.size());
            for (IntIntCursor c : map) {
                bset.set((long)c.key);
            }
            int key = bset.nextSetBit(0);
            while (key >= 0) {
                result[index++] = key;
                result[index++] = map.get(key);
                key = bset.nextSetBit(key + 1);
            }
        }
        return result;
    }

    public static final int[] flatten(IntIntHashMap map) {
        int[] result = new int[map.size() * 2];
        int index = 0;
        for (IntIntCursor c : map) {
            result[index++] = c.key;
            result[index++] = c.value;
        }
        return result;
    }

    public static final IntIntHashMap addAllFromFlattened(IntIntHashMap map, int[] flattened) {
        for (int i = 0; i < flattened.length / 2; ++i) {
            int key = flattened[i * 2];
            int v = flattened[i * 2 + 1];
            map.putOrAdd(key, v, v);
        }
        return map;
    }

    private IntMapUtils() {
    }
}

