/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.codahale.metrics.Timer;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.cloud.ExclusiveSliceProperty;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.OverseerCollectionConfigSetProcessor;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.SizeLimitedDistributedMap;
import org.apache.solr.cloud.Stats;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkDistributedQueue;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.overseer.CollectionMutator;
import org.apache.solr.cloud.overseer.NodeMutator;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.cloud.overseer.ReplicaMutator;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.overseer.ZkStateWriter;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Compressor;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.ZLibCompressor;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overseer
implements SolrCloseable {
    public static final String QUEUE_OPERATION = "operation";
    public static final int STATE_UPDATE_DELAY = ZkStateReader.STATE_UPDATE_DELAY;
    public static final int STATE_UPDATE_BATCH_SIZE = Integer.getInteger("solr.OverseerStateUpdateBatchSize", 10000);
    public static final int STATE_UPDATE_MAX_QUEUE = Integer.getInteger("solr.OverseerStateUpdateMaxQueueSize", 20000);
    public static final int NUM_RESPONSES_TO_STORE = 10000;
    public static final String OVERSEER_ELECT = "/overseer_elect";
    private final CopyOnWriteArrayList<Message> unprocessedMessages = new CopyOnWriteArrayList();
    private SolrMetricsContext solrMetricsContext;
    private volatile String metricTag = SolrMetricProducer.getUniqueMetricTag(this, null);
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private OverseerThread ccThread;
    private OverseerThread updaterThread;
    private final ZkStateReader reader;
    private final HttpShardHandler shardHandler;
    private final UpdateShardHandler updateShardHandler;
    private final String adminPath;
    private OverseerCollectionConfigSetProcessor overseerCollectionConfigSetProcessor;
    private ZkController zkController;
    private Stats stats;
    private String id;
    private volatile boolean closed;
    private volatile boolean systemCollCompatCheck = true;
    private CloudConfig config;
    private final DistributedClusterStateUpdater distributedClusterStateUpdater;

    public Overseer(HttpShardHandler shardHandler, UpdateShardHandler updateShardHandler, String adminPath, ZkStateReader reader, ZkController zkController, CloudConfig config) throws KeeperException, InterruptedException {
        this.reader = reader;
        this.shardHandler = shardHandler;
        this.updateShardHandler = updateShardHandler;
        this.adminPath = adminPath;
        this.zkController = zkController;
        this.stats = new Stats();
        this.config = config;
        this.distributedClusterStateUpdater = new DistributedClusterStateUpdater(config.getDistributedClusterStateUpdates());
        this.solrMetricsContext = new SolrMetricsContext(zkController.getCoreContainer().getMetricManager(), SolrInfoBean.Group.overseer.toString(), this.metricTag);
    }

    public synchronized void start(String id) {
        MDCLoggingContext.setNode(this.zkController == null ? null : this.zkController.getNodeName());
        this.id = id;
        this.closed = false;
        this.doClose();
        this.stats = new Stats();
        log.info("Overseer (id={}) starting", (Object)id);
        this.createOverseerNode(this.reader.getZkClient());
        ThreadGroup tg = new ThreadGroup("Overseer state updater.");
        String stateCompressionProviderClass = this.config.getStateCompressorClass();
        ZLibCompressor compressor = StrUtils.isNullOrEmpty((String)stateCompressionProviderClass) ? new ZLibCompressor() : this.zkController.getCoreContainer().getResourceLoader().newInstance(stateCompressionProviderClass, Compressor.class);
        this.updaterThread = new OverseerThread(tg, new ClusterStateUpdater(this.reader, id, this.stats, this.config.getMinStateByteLenForCompression(), (Compressor)compressor), "OverseerStateUpdate-" + id);
        this.updaterThread.setDaemon(true);
        ThreadGroup ccTg = new ThreadGroup("Overseer collection creation process.");
        OverseerNodePrioritizer overseerPrioritizer = new OverseerNodePrioritizer(this.reader, this, this.adminPath, this.shardHandler.getShardHandlerFactory());
        this.overseerCollectionConfigSetProcessor = new OverseerCollectionConfigSetProcessor(this.reader, id, this.shardHandler, this.adminPath, this.stats, this, overseerPrioritizer, this.solrMetricsContext);
        this.ccThread = new OverseerThread(ccTg, this.overseerCollectionConfigSetProcessor, "OverseerCollectionConfigSetProcessor-" + id);
        this.ccThread.setDaemon(true);
        this.updaterThread.start();
        this.ccThread.start();
        this.systemCollectionCompatCheck(new BiConsumer<String, Object>(){
            boolean firstPair = true;

            @Override
            public void accept(String s, Object o) {
                if (this.firstPair) {
                    log.warn("WARNING: Collection '.system' may need re-indexing due to compatibility issues listed below. See REINDEXCOLLECTION documentation for more details.");
                    this.firstPair = false;
                }
                log.warn("WARNING: *\t{}:\t{}", (Object)s, o);
            }
        });
        this.getCoreContainer().getClusterSingletons().startClusterSingletons();
        assert (ObjectReleaseTracker.track((Object)this));
    }

    public void systemCollectionCompatCheck(BiConsumer<String, Object> consumer) {
        ClusterState clusterState = this.zkController.getClusterState();
        if (clusterState == null) {
            log.warn("Unable to check back-compat of .system collection - can't obtain ClusterState.");
            return;
        }
        DocCollection coll = clusterState.getCollectionOrNull(".system");
        if (coll == null) {
            return;
        }
        boolean allActive = true;
        for (Slice s : coll.getActiveSlices()) {
            if (s.getLeader() != null && s.getLeader().isActive(clusterState.getLiveNodes())) continue;
            allActive = false;
            break;
        }
        if (allActive) {
            this.doCompatCheck(consumer);
        } else {
            this.zkController.zkStateReader.registerCollectionStateWatcher(".system", (liveNodes, state) -> {
                boolean active = true;
                if (state == null || liveNodes.isEmpty()) {
                    return true;
                }
                for (Slice s : state.getActiveSlices()) {
                    if (s.getLeader() != null && s.getLeader().isActive(liveNodes)) continue;
                    active = false;
                    break;
                }
                if (active) {
                    this.doCompatCheck(consumer);
                }
                return active;
            });
        }
    }

    private void doCompatCheck(BiConsumer<String, Object> consumer) {
        if (!this.systemCollCompatCheck) {
            return;
        }
        this.systemCollCompatCheck = false;
        try (CloudLegacySolrClient client = ((CloudLegacySolrClient.Builder)((CloudLegacySolrClient.Builder)((CloudLegacySolrClient.Builder)new CloudLegacySolrClient.Builder(Collections.singletonList(this.getZkController().getZkServerAddress()), Optional.empty()).withSocketTimeout(30000, TimeUnit.MILLISECONDS)).withConnectionTimeout(15000, TimeUnit.MILLISECONDS)).withHttpClient(this.updateShardHandler.getDefaultHttpClient())).build();){
            CollectionAdminRequest.ColStatus req = CollectionAdminRequest.collectionStatus((String)".system").setWithSegments(true).setWithFieldInfo(true);
            CollectionAdminResponse rsp = (CollectionAdminResponse)req.process((SolrClient)client);
            NamedList status = (NamedList)rsp.getResponse().get(".system");
            Collection nonCompliant = (Collection)status.get("schemaNonCompliant");
            if (!nonCompliant.contains("(NONE)")) {
                consumer.accept("indexFieldsNotMatchingSchema", nonCompliant);
            }
            HashSet<Integer> segmentCreatedMajorVersions = new HashSet<Integer>();
            HashSet<String> segmentVersions = new HashSet<String>();
            int currentMajorVersion = Version.LATEST.major;
            String currentVersion = Version.LATEST.toString();
            segmentVersions.add(currentVersion);
            segmentCreatedMajorVersions.add(currentMajorVersion);
            NamedList shards = (NamedList)status.get("shards");
            for (Map.Entry entry : shards) {
                NamedList segInfos;
                NamedList leader = (NamedList)((NamedList)entry.getValue()).get("leader");
                if (leader == null || (segInfos = (NamedList)leader.get("segInfos")) == null) continue;
                NamedList infos = (NamedList)segInfos.get("info");
                if (((Number)infos.get("numSegments")).intValue() > 0) {
                    segmentVersions.add(infos.get("minSegmentLuceneVersion").toString());
                }
                if (infos.get("commitLuceneVersion") != null) {
                    segmentVersions.add(infos.get("commitLuceneVersion").toString());
                }
                NamedList segmentInfos = (NamedList)segInfos.get("segments");
                segmentInfos.forEach((k, v) -> {
                    NamedList segment = (NamedList)v;
                    segmentVersions.add(segment.get("version").toString());
                    if (segment.get("minVersion") != null) {
                        segmentVersions.add(segment.get("version").toString());
                    }
                    if (segment.get("createdVersionMajor") != null) {
                        segmentCreatedMajorVersions.add(((Number)segment.get("createdVersionMajor")).intValue());
                    }
                });
            }
            if (segmentVersions.size() > 1) {
                consumer.accept("differentSegmentVersions", segmentVersions);
                consumer.accept("currentLuceneVersion", currentVersion);
            }
            if (segmentCreatedMajorVersions.size() > 1) {
                consumer.accept("differentMajorSegmentVersions", segmentCreatedMajorVersions);
                consumer.accept("currentLuceneMajorVersion", currentMajorVersion);
            }
        }
        catch (IOException | SolrServerException e) {
            log.warn("Unable to perform back-compat check of .system collection", e);
        }
    }

    public Stats getStats() {
        return this.stats;
    }

    ZkController getZkController() {
        return this.zkController;
    }

    public CoreContainer getCoreContainer() {
        return this.zkController.getCoreContainer();
    }

    public SolrCloudManager getSolrCloudManager() {
        return this.zkController.getSolrCloudManager();
    }

    public DistributedClusterStateUpdater getDistributedClusterStateUpdater() {
        return this.distributedClusterStateUpdater;
    }

    public synchronized OverseerThread getUpdaterThread() {
        return this.updaterThread;
    }

    public synchronized void close() {
        if (this.id != null) {
            log.info("Overseer (id={}) closing", (Object)this.id);
        }
        if (!this.closed) {
            this.getCoreContainer().getClusterSingletons().stopClusterSingletons();
        }
        this.closed = true;
        this.doClose();
        assert (ObjectReleaseTracker.release((Object)this));
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void doClose() {
        if (this.updaterThread != null) {
            IOUtils.closeQuietly((Closeable)this.updaterThread);
            this.updaterThread.interrupt();
        }
        if (this.ccThread != null) {
            IOUtils.closeQuietly((Closeable)this.ccThread);
            this.ccThread.interrupt();
        }
        if (this.updaterThread != null) {
            try {
                this.updaterThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.ccThread != null) {
            try {
                this.ccThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.updaterThread = null;
        this.ccThread = null;
    }

    ZkDistributedQueue getStateUpdateQueue() {
        if (this.distributedClusterStateUpdater.isDistributedStateUpdate()) {
            throw new IllegalStateException("Cluster state is done in a distributed way, should not try to access ZK queue");
        }
        return this.getStateUpdateQueue(new Stats());
    }

    ZkDistributedQueue getOverseerQuitNotificationQueue() {
        return this.getStateUpdateQueue(new Stats());
    }

    ZkDistributedQueue getStateUpdateQueue(Stats zkStats) {
        return new ZkDistributedQueue(this.reader.getZkClient(), "/overseer/queue", zkStats, STATE_UPDATE_MAX_QUEUE, () -> this.isClosed() || this.zkController.getCoreContainer().isShutDown());
    }

    static ZkDistributedQueue getInternalWorkQueue(SolrZkClient zkClient, Stats zkStats) {
        return new ZkDistributedQueue(zkClient, "/overseer/queue-work", zkStats);
    }

    static DistributedMap getRunningMap(SolrZkClient zkClient) {
        return new DistributedMap(zkClient, "/overseer/collection-map-running");
    }

    static DistributedMap getCompletedMap(SolrZkClient zkClient) {
        return new SizeLimitedDistributedMap(zkClient, "/overseer/collection-map-completed", 10000, child -> Overseer.getAsyncIdsMap(zkClient).remove(child));
    }

    static DistributedMap getFailureMap(SolrZkClient zkClient) {
        return new SizeLimitedDistributedMap(zkClient, "/overseer/collection-map-failure", 10000, child -> Overseer.getAsyncIdsMap(zkClient).remove(child));
    }

    static DistributedMap getAsyncIdsMap(SolrZkClient zkClient) {
        return new DistributedMap(zkClient, "/overseer/async_ids");
    }

    OverseerTaskQueue getCollectionQueue(SolrZkClient zkClient) {
        return this.getCollectionQueue(zkClient, new Stats());
    }

    OverseerTaskQueue getCollectionQueue(SolrZkClient zkClient, Stats zkStats) {
        return new OverseerTaskQueue(zkClient, "/overseer/collection-queue-work", zkStats);
    }

    OverseerTaskQueue getConfigSetQueue(SolrZkClient zkClient) {
        return this.getConfigSetQueue(zkClient, new Stats());
    }

    OverseerTaskQueue getConfigSetQueue(SolrZkClient zkClient, Stats zkStats) {
        return this.getCollectionQueue(zkClient, zkStats);
    }

    private void createOverseerNode(SolrZkClient zkClient) {
        try {
            zkClient.create("/overseer", new byte[0], CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (InterruptedException e) {
            log.error("Could not create Overseer node", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (KeeperException e) {
            log.error("Could not create Overseer node", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ZkStateReader getZkStateReader() {
        return this.reader;
    }

    public void offerStateUpdate(MapWriter mw) throws KeeperException, InterruptedException {
        this.offerStateUpdate(Utils.toJSON((Object)mw));
    }

    public void offerStateUpdate(byte[] data) throws KeeperException, InterruptedException {
        if (this.distributedClusterStateUpdater.isDistributedStateUpdate()) {
            ZkNodeProps message = ZkNodeProps.load((byte[])data);
            String operation = message.getStr(QUEUE_OPERATION);
            log.error("Received unexpected message on Overseer cluster state updater for " + operation + " when distributed updates are configured");
            throw new RuntimeException("Message " + operation + " offered to state update queue when distributed state update is configured.");
        }
        if (this.zkController.getZkClient().isClosed()) {
            throw new AlreadyClosedException();
        }
        this.getStateUpdateQueue().offer(data);
    }

    public void submit(Message message) {
        this.unprocessedMessages.add(message);
    }

    public void sendQuitToOverseer(String overseerId) throws KeeperException, InterruptedException {
        this.getOverseerQuitNotificationQueue().offer(ew -> ew.put((CharSequence)QUEUE_OPERATION, (CharSequence)OverseerAction.QUIT.toLower()).put((CharSequence)"id", (CharSequence)overseerId));
    }

    public static interface Message {
        public ClusterState run(ClusterState var1, Overseer var2, ZkStateWriter var3) throws Exception;
    }

    public static class OverseerThread
    extends Thread
    implements Closeable {
        protected volatile boolean isClosed;
        private final Closeable thread;

        public <T extends Runnable & Closeable> OverseerThread(ThreadGroup ccTg, T thread, String name) {
            super(ccTg, thread, name);
            this.thread = thread;
        }

        @Override
        public void close() throws IOException {
            this.thread.close();
            this.isClosed = true;
        }

        public Closeable getThread() {
            return this.thread;
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }

    private class ClusterStateUpdater
    implements Runnable,
    Closeable {
        private final ZkStateReader reader;
        private final SolrZkClient zkClient;
        private final String myId;
        private final ZkDistributedQueue stateUpdateQueue;
        private final ZkDistributedQueue workQueue;
        private final DistributedMap runningMap;
        private final DistributedMap completedMap;
        private final DistributedMap failureMap;
        private final Stats zkStats;
        private SolrMetricsContext clusterStateUpdaterMetricContext;
        private final int minStateByteLenForCompression;
        private final Compressor compressor;
        private boolean isClosed = false;

        public ClusterStateUpdater(ZkStateReader reader, String myId, Stats zkStats, int minStateByteLenForCompression, Compressor compressor) {
            this.zkClient = reader.getZkClient();
            this.zkStats = zkStats;
            this.stateUpdateQueue = Overseer.this.getStateUpdateQueue(zkStats);
            this.workQueue = Overseer.getInternalWorkQueue(this.zkClient, zkStats);
            this.failureMap = Overseer.getFailureMap(this.zkClient);
            this.runningMap = Overseer.getRunningMap(this.zkClient);
            this.completedMap = Overseer.getCompletedMap(this.zkClient);
            this.myId = myId;
            this.reader = reader;
            this.minStateByteLenForCompression = minStateByteLenForCompression;
            this.compressor = compressor;
            this.clusterStateUpdaterMetricContext = Overseer.this.solrMetricsContext.getChildContext(this);
            this.clusterStateUpdaterMetricContext.gauge(() -> this.stateUpdateQueue.getZkStats().getQueueLength(), true, "stateUpdateQueueSize", "queue");
        }

        public Stats getStateUpdateQueueStats() {
            return this.stateUpdateQueue.getZkStats();
        }

        public Stats getWorkQueueStats() {
            return this.workQueue.getZkStats();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 28[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean isBadMessage(Exception e) {
            if (e instanceof KeeperException) {
                KeeperException ke = (KeeperException)((Object)e);
                return ke.code() == KeeperException.Code.NONODE || ke.code() == KeeperException.Code.NODEEXISTS;
            }
            return !(e instanceof InterruptedException);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClusterState processQueueItem(ZkNodeProps message, ClusterState clusterState, ZkStateWriter zkStateWriter, boolean enableBatching, ZkStateWriter.ZkWriteCallback callback) throws Exception {
            String operation = message.getStr(Overseer.QUEUE_OPERATION);
            if (operation == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Message missing operation:" + message);
            }
            List<ZkWriteCommand> zkWriteCommands = null;
            Timer.Context timerContext = Overseer.this.stats.time(operation);
            try {
                zkWriteCommands = this.processMessage(clusterState, message, operation);
                Overseer.this.stats.success(operation);
            }
            catch (Exception e) {
                log.error("Overseer could not process the current clusterstate state update message, skipping the message: {}", (Object)message, (Object)e);
                Overseer.this.stats.error(operation);
            }
            finally {
                timerContext.stop();
            }
            if (zkWriteCommands != null) {
                clusterState = zkStateWriter.enqueueUpdate(clusterState, zkWriteCommands, callback);
                if (!enableBatching) {
                    clusterState = zkStateWriter.writePendingUpdates();
                }
            }
            return clusterState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkIfIamStillLeader() {
            byte[] data;
            if (Overseer.this.zkController != null && (Overseer.this.zkController.getCoreContainer().isShutDown() || Overseer.this.zkController.isClosed())) {
                return;
            }
            Stat stat = new Stat();
            String path = "/overseer_elect/leader";
            try {
                data = this.zkClient.getData("/overseer_elect/leader", null, stat, true);
            }
            catch (AlreadyClosedException e) {
                return;
            }
            catch (Exception e) {
                log.warn("Error communicating with ZooKeeper", (Throwable)e);
                return;
            }
            try {
                Map m = (Map)Utils.fromJSON((byte[])data);
                String id = (String)m.get("id");
                if (Overseer.this.overseerCollectionConfigSetProcessor.getId().equals(id)) {
                    try {
                        log.warn("I (id={}) am exiting, but I'm still the leader", (Object)Overseer.this.overseerCollectionConfigSetProcessor.getId());
                        this.zkClient.delete("/overseer_elect/leader", stat.getVersion(), true);
                    }
                    catch (KeeperException.BadVersionException badVersionException) {
                    }
                    catch (Exception e) {
                        log.error("Could not delete my leader node {}", (Object)"/overseer_elect/leader", (Object)e);
                    }
                } else {
                    log.info("somebody else (id={}) has already taken up the overseer position", (Object)id);
                }
            }
            finally {
                try {
                    if (Overseer.this.zkController != null && !Overseer.this.zkController.getCoreContainer().isShutDown()) {
                        Overseer.this.zkController.rejoinOverseerElection(null, false);
                    }
                }
                catch (Exception e) {
                    log.warn("Unable to rejoinElection ", (Throwable)e);
                }
            }
        }

        private List<ZkWriteCommand> processMessage(ClusterState clusterState, ZkNodeProps message, String operation) {
            block26: {
                block25: {
                    CollectionParams.CollectionAction collectionAction = CollectionParams.CollectionAction.get((String)operation);
                    if (collectionAction == null) break block25;
                    switch (collectionAction) {
                        case CREATE: {
                            return Collections.singletonList(new ClusterStateMutator(Overseer.this.getSolrCloudManager()).createCollection(clusterState, message));
                        }
                        case DELETE: {
                            return Collections.singletonList(new ClusterStateMutator(Overseer.this.getSolrCloudManager()).deleteCollection(clusterState, message));
                        }
                        case CREATESHARD: {
                            return Collections.singletonList(new CollectionMutator(Overseer.this.getSolrCloudManager()).createShard(clusterState, message));
                        }
                        case DELETESHARD: {
                            return Collections.singletonList(new CollectionMutator(Overseer.this.getSolrCloudManager()).deleteShard(clusterState, message));
                        }
                        case ADDREPLICA: {
                            return Collections.singletonList(new SliceMutator(Overseer.this.getSolrCloudManager()).addReplica(clusterState, message));
                        }
                        case ADDREPLICAPROP: {
                            return Collections.singletonList(new ReplicaMutator(Overseer.this.getSolrCloudManager()).addReplicaProperty(clusterState, message));
                        }
                        case DELETEREPLICAPROP: {
                            return Collections.singletonList(new ReplicaMutator(Overseer.this.getSolrCloudManager()).deleteReplicaProperty(clusterState, message));
                        }
                        case BALANCESHARDUNIQUE: {
                            ExclusiveSliceProperty dProp = new ExclusiveSliceProperty(clusterState, message);
                            if (dProp.balanceProperty()) {
                                String collName = message.getStr("collection");
                                return Collections.singletonList(new ZkWriteCommand(collName, dProp.getDocCollection()));
                            }
                            break block26;
                        }
                        case MODIFYCOLLECTION: {
                            return Collections.singletonList(new CollectionMutator(Overseer.this.getSolrCloudManager()).modifyCollection(clusterState, message));
                        }
                        default: {
                            throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
                        }
                    }
                }
                OverseerAction overseerAction = OverseerAction.get(operation);
                if (overseerAction == null) {
                    throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
                }
                switch (overseerAction) {
                    case STATE: {
                        return Collections.singletonList(new ReplicaMutator(Overseer.this.getSolrCloudManager()).setState(clusterState, message));
                    }
                    case LEADER: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getSolrCloudManager()).setShardLeader(clusterState, message));
                    }
                    case DELETECORE: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getSolrCloudManager()).removeReplica(clusterState, message));
                    }
                    case ADDROUTINGRULE: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getSolrCloudManager()).addRoutingRule(clusterState, message));
                    }
                    case REMOVEROUTINGRULE: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getSolrCloudManager()).removeRoutingRule(clusterState, message));
                    }
                    case UPDATESHARDSTATE: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getSolrCloudManager()).updateShardState(clusterState, message));
                    }
                    case QUIT: {
                        if (this.myId.equals(message.get("id"))) {
                            if (log.isInfoEnabled()) {
                                log.info("Quit command received {} {}", (Object)message, (Object)LeaderElector.getNodeName(this.myId));
                            }
                            IOUtils.closeQuietly((Closeable)Overseer.this.overseerCollectionConfigSetProcessor);
                            IOUtils.closeQuietly((Closeable)this);
                            break;
                        }
                        log.warn("Overseer received wrong QUIT message {}", (Object)message);
                        break;
                    }
                    case DOWNNODE: {
                        return new NodeMutator(Overseer.this.getSolrCloudManager()).downNode(clusterState, message);
                    }
                    default: {
                        throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
                    }
                }
            }
            return Collections.singletonList(ZkStateWriter.NO_OP);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LeaderStatus amILeader() {
            Timer.Context timerContext = Overseer.this.stats.time("am_i_leader");
            boolean success = true;
            String propsId = null;
            try {
                ZkNodeProps props = ZkNodeProps.load((byte[])this.zkClient.getData("/overseer_elect/leader", null, null, true));
                propsId = props.getStr("id");
                if (this.myId.equals(propsId)) {
                    LeaderStatus leaderStatus = LeaderStatus.YES;
                    return leaderStatus;
                }
            }
            catch (KeeperException e) {
                success = false;
                if (e.code() == KeeperException.Code.CONNECTIONLOSS) {
                    log.error("", (Throwable)e);
                    LeaderStatus leaderStatus = LeaderStatus.DONT_KNOW;
                    return leaderStatus;
                }
                if (e.code() != KeeperException.Code.SESSIONEXPIRED) {
                    log.warn("", (Throwable)e);
                } else {
                    log.debug("", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                success = false;
                Thread.currentThread().interrupt();
            }
            catch (AlreadyClosedException e) {
                success = false;
            }
            catch (Exception e) {
                success = false;
                log.warn("Unexpected exception", (Throwable)e);
            }
            finally {
                timerContext.stop();
                if (success) {
                    Overseer.this.stats.success("am_i_leader");
                } else {
                    Overseer.this.stats.error("am_i_leader");
                }
            }
            log.info("According to ZK I (id={}) am no longer a leader. propsId={}", (Object)this.myId, (Object)propsId);
            return LeaderStatus.NO;
        }

        @Override
        public void close() {
            this.isClosed = true;
            this.clusterStateUpdaterMetricContext.unregister();
        }

        private static /* synthetic */ boolean lambda$run$3(Set processedNodes, String node) {
            return !processedNodes.contains(node);
        }

        private /* synthetic */ void lambda$run$2(Set processedNodes) throws Exception {
            this.stateUpdateQueue.remove(processedNodes);
            processedNodes.clear();
        }

        private static /* synthetic */ boolean lambda$run$1(String x) {
            return true;
        }
    }

    static enum LeaderStatus {
        DONT_KNOW,
        NO,
        YES;

    }
}

