/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import java.util.Map;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.jersey.CatchAllExceptionMapper;
import org.apache.solr.jersey.InjectionFactories;
import org.apache.solr.jersey.MediaTypeOverridingFilter;
import org.apache.solr.jersey.MessageBodyReaders;
import org.apache.solr.jersey.MessageBodyWriters;
import org.apache.solr.jersey.NotFoundExceptionMapper;
import org.apache.solr.jersey.PostRequestDecorationFilter;
import org.apache.solr.jersey.PostRequestLoggingFilter;
import org.apache.solr.jersey.RequestMetricHandling;
import org.apache.solr.jersey.SolrJacksonMapper;
import org.apache.solr.jersey.SolrRequestAuthorizer;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJsonProvider;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ResourceConfig;

public class JerseyApplications {

    public static class SolrCoreApp
    extends CoreContainerApp {
        public SolrCoreApp() {
            this.register(new AbstractBinder(){

                protected void configure() {
                    this.bindFactory(InjectionFactories.ReuseFromContextSolrCoreFactory.class).to(SolrCore.class).in(RequestScoped.class);
                    this.bindFactory(InjectionFactories.ReuseFromContextIndexSchemaFactory.class).to(IndexSchema.class).in(RequestScoped.class);
                    this.bindFactory(InjectionFactories.ReuseFromContextSolrParamsFactory.class).to(SolrParams.class).in(RequestScoped.class);
                }
            });
        }
    }

    public static class CoreContainerApp
    extends ResourceConfig {
        public CoreContainerApp() {
            this.register(SolrRequestAuthorizer.class);
            this.register(MessageBodyWriters.JavabinMessageBodyWriter.class);
            this.register(MessageBodyWriters.XmlMessageBodyWriter.class);
            this.register(MessageBodyWriters.CsvMessageBodyWriter.class);
            this.register(MessageBodyWriters.RawMessageBodyWriter.class);
            this.register(JacksonJsonProvider.class, 5);
            this.register(MessageBodyReaders.CachingJsonMessageBodyReader.class, 10);
            this.register(SolrJacksonMapper.class);
            this.register(CatchAllExceptionMapper.class);
            this.register(NotFoundExceptionMapper.class);
            this.register(MediaTypeOverridingFilter.class);
            this.register(RequestMetricHandling.PreRequestMetricsFilter.class);
            this.register(RequestMetricHandling.PostRequestMetricsFilter.class);
            this.register(PostRequestDecorationFilter.class);
            this.register(PostRequestLoggingFilter.class);
            this.register(new AbstractBinder(){

                protected void configure() {
                    this.bindFactory(InjectionFactories.SolrQueryRequestFactory.class).to(SolrQueryRequest.class).in(RequestScoped.class);
                }
            });
            this.register(new AbstractBinder(){

                protected void configure() {
                    this.bindFactory(InjectionFactories.SolrQueryResponseFactory.class).to(SolrQueryResponse.class).in(RequestScoped.class);
                }
            });
            this.setProperties(Map.of("jersey.config.server.wadl.disableWadl", "true", "jersey.config.beanValidation.disable.server", "true", "jersey.config.server.disableAutoDiscovery", "true", "jersey.config.server.disableJsonProcessing", "true", "jersey.config.server.disableMetainfServicesLookup", "true", "jersey.config.server.disableMoxyJson", "true", "jersey.config.server.resource.validation.disable", "true"));
        }
    }
}

