/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.GrpcUtils;
import com.google.cloud.storage.ResumableSessionFailureScenario;
import com.google.cloud.storage.ResumableWrite;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.storage.WriteCtx;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.storage.v2.ChecksummedData;
import com.google.storage.v2.ObjectChecksums;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.checkerframework.checker.nullness.qual.NonNull;

final class GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel
implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
    private final SettableApiFuture<WriteObjectResponse> resultFuture;
    private final ChunkSegmenter chunkSegmenter;
    private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write;
    private final WriteCtx<ResumableWrite> writeCtx;
    private final Observer responseObserver;
    private volatile ApiStreamObserver<WriteObjectRequest> stream;
    private boolean open = true;
    private boolean first = true;
    private boolean finished = false;
    private volatile WriteObjectRequest lastWrittenRequest;

    GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel(SettableApiFuture<WriteObjectResponse> resultFuture, ChunkSegmenter chunkSegmenter, ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write, WriteCtx<ResumableWrite> writeCtx) {
        String bucketName = writeCtx.getRequestFactory().bucketName();
        this.resultFuture = resultFuture;
        this.chunkSegmenter = chunkSegmenter;
        GrpcCallContext internalContext = GrpcUtils.contextWithBucketName(bucketName, GrpcCallContext.createDefault());
        this.write = write.withDefaultCallContext((ApiCallContext)internalContext);
        this.writeCtx = writeCtx;
        this.responseObserver = new Observer(internalContext);
    }

    @Override
    public long write(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException {
        return this.internalWrite(srcs, srcsOffset, srcsLength, false);
    }

    @Override
    public long writeAndClose(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException {
        long write = this.internalWrite(srcs, srcsOffset, srcsLength, true);
        this.close();
        return write;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        ApiStreamObserver<WriteObjectRequest> openedStream = this.openedStream();
        try {
            if (!this.finished) {
                WriteObjectRequest message;
                this.lastWrittenRequest = message = this.finishMessage();
                openedStream.onNext((Object)message);
                this.finished = true;
            }
            openedStream.onCompleted();
            this.responseObserver.await();
        }
        catch (RuntimeException e) {
            this.resultFuture.setException((Throwable)e);
            throw e;
        }
    }

    private long internalWrite(ByteBuffer[] srcs, int srcsOffset, int srcsLength, boolean finalize) throws ClosedChannelException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        ChunkSegmenter.ChunkSegment[] data = this.chunkSegmenter.segmentBuffers(srcs, srcsOffset, srcsLength);
        if (data.length == 0) {
            return 0L;
        }
        ApiStreamObserver<WriteObjectRequest> openedStream = this.openedStream();
        int bytesConsumed = 0;
        try {
            for (int i = 0; i < data.length; ++i) {
                ChunkSegmenter.ChunkSegment datum = data[i];
                Crc32cValue.Crc32cLengthKnown crc32c = datum.getCrc32c();
                ByteString b = datum.getB();
                int contentSize = b.size();
                long offset = this.writeCtx.getTotalSentBytes().getAndAdd(contentSize);
                Crc32cValue.Crc32cLengthKnown cumulative = this.writeCtx.getCumulativeCrc32c().accumulateAndGet(crc32c, this.chunkSegmenter.getHasher()::nullSafeConcat);
                ChecksummedData.Builder checksummedData = ChecksummedData.newBuilder().setContent(b);
                if (crc32c != null) {
                    checksummedData.setCrc32C(crc32c.getValue());
                }
                WriteObjectRequest.Builder builder = this.writeCtx.newRequestBuilder();
                if (!this.first) {
                    builder.clearUploadId();
                    builder.clearWriteObjectSpec();
                    builder.clearObjectChecksums();
                }
                builder.setWriteOffset(offset).setChecksummedData(checksummedData.build());
                if (!datum.isOnlyFullBlocks() || finalize && i + 1 == data.length) {
                    builder.setFinishWrite(true);
                    if (cumulative != null) {
                        builder.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(cumulative.getValue()).build());
                    }
                    this.finished = true;
                }
                WriteObjectRequest build = builder.build();
                this.first = false;
                this.lastWrittenRequest = build;
                openedStream.onNext((Object)build);
                bytesConsumed += contentSize;
            }
            if (finalize && !this.finished) {
                WriteObjectRequest finishMessage;
                this.lastWrittenRequest = finishMessage = this.finishMessage();
                openedStream.onNext((Object)finishMessage);
                this.finished = true;
            }
        }
        catch (RuntimeException e) {
            this.resultFuture.setException((Throwable)e);
            throw e;
        }
        return bytesConsumed;
    }

    private @NonNull WriteObjectRequest finishMessage() {
        long offset = this.writeCtx.getTotalSentBytes().get();
        Crc32cValue.Crc32cLengthKnown crc32cValue = this.writeCtx.getCumulativeCrc32c().get();
        WriteObjectRequest.Builder b = this.writeCtx.newRequestBuilder().setFinishWrite(true).setWriteOffset(offset);
        if (crc32cValue != null) {
            b.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(crc32cValue.getValue()).build());
        }
        WriteObjectRequest message = b.build();
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiStreamObserver<WriteObjectRequest> openedStream() {
        if (this.stream == null) {
            GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel gapicUnbufferedFinalizeOnCloseResumableWritableByteChannel = this;
            synchronized (gapicUnbufferedFinalizeOnCloseResumableWritableByteChannel) {
                if (this.stream == null) {
                    this.stream = this.write.clientStreamingCall((ApiStreamObserver)this.responseObserver);
                }
            }
        }
        return this.stream;
    }

    class Observer
    implements ApiStreamObserver<WriteObjectResponse> {
        private final GrpcCallContext context;
        private final SettableApiFuture<Void> invocationHandle;
        private volatile WriteObjectResponse last;

        Observer(GrpcCallContext context) {
            this.context = context;
            this.invocationHandle = SettableApiFuture.create();
        }

        public void onNext(WriteObjectResponse value) {
            this.last = value;
        }

        public void onError(Throwable t) {
            if (t instanceof ApiException) {
                StorageException tmp = StorageException.asStorageException((ApiException)t);
                StorageException storageException = ResumableSessionFailureScenario.toStorageException(tmp.getCode(), tmp.getMessage(), tmp.getReason(), (List)ImmutableList.of((Object)GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.lastWrittenRequest), null, this.context, t);
                GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.resultFuture.setException((Throwable)((Object)storageException));
                this.invocationHandle.setException((Throwable)((Object)storageException));
            } else {
                GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.resultFuture.setException(t);
                this.invocationHandle.setException(t);
            }
        }

        public void onCompleted() {
            boolean finalizing = GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.lastWrittenRequest.getFinishWrite();
            if (this.last == null) {
                this.clientDetectedError(ResumableSessionFailureScenario.toStorageException(0, "onComplete without preceding onNext, unable to determine success.", "invalid", (List)ImmutableList.of((Object)GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.lastWrittenRequest), null, this.context, null));
            } else if (this.last.hasResource()) {
                long finalSize;
                long totalSentBytes = GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.writeCtx.getTotalSentBytes().get();
                if (totalSentBytes == (finalSize = this.last.getResource().getSize())) {
                    this.ok(finalSize);
                } else if (finalSize < totalSentBytes) {
                    this.clientDetectedError(ResumableSessionFailureScenario.SCENARIO_4_1.toStorageException((List)ImmutableList.of((Object)GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.lastWrittenRequest), (Message)this.last, this.context, null));
                } else {
                    this.clientDetectedError(ResumableSessionFailureScenario.SCENARIO_4_2.toStorageException((List)ImmutableList.of((Object)GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.lastWrittenRequest), (Message)this.last, this.context, null));
                }
            } else if (!finalizing || this.last.hasPersistedSize()) {
                this.clientDetectedError(ResumableSessionFailureScenario.toStorageException(0, "Unexpected incremental response for finalizing request.", "invalid", (List)ImmutableList.of((Object)GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.lastWrittenRequest), (Message)this.last, this.context, null));
            } else {
                this.clientDetectedError(ResumableSessionFailureScenario.SCENARIO_0.toStorageException((List)ImmutableList.of((Object)GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.lastWrittenRequest), (Message)this.last, this.context, null));
            }
        }

        private void ok(long persistedSize) {
            GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.writeCtx.getConfirmedBytes().set(persistedSize);
            GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.resultFuture.set((Object)this.last);
            this.invocationHandle.set(null);
        }

        private void clientDetectedError(StorageException storageException) {
            GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.open = false;
            GapicUnbufferedFinalizeOnCloseResumableWritableByteChannel.this.resultFuture.setException((Throwable)((Object)storageException));
            this.invocationHandle.setException((Throwable)((Object)storageException));
        }

        void await() {
            try {
                this.invocationHandle.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
    }
}

