/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value.constant;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.constant.ConstantBooleanValue;
import org.apache.solr.analytics.value.constant.ConstantDateValue;
import org.apache.solr.analytics.value.constant.ConstantDoubleValue;
import org.apache.solr.analytics.value.constant.ConstantIntValue;
import org.apache.solr.analytics.value.constant.ConstantLongValue;
import org.apache.solr.analytics.value.constant.ConstantStringValue;
import org.apache.solr.common.SolrException;

public abstract class ConstantValue
implements AnalyticsValue {
    private static final Pattern truePattern = Pattern.compile("^true|t$", 2);
    private static final Pattern falsePattern = Pattern.compile("^false|f$", 2);
    public static final ExpressionFactory.ConstantFunction creatorFunction = param -> {
        if ((param = param.trim()).charAt(0) == '\"' && param.charAt(param.length() - 1) == '\"' || param.charAt(0) == '\'' && param.charAt(param.length() - 1) == '\'') {
            return new ConstantStringValue(param.substring(1, param.length() - 1));
        }
        Matcher m = truePattern.matcher(param);
        if (m.matches()) {
            return new ConstantBooleanValue(true);
        }
        m = falsePattern.matcher(param);
        if (m.matches()) {
            return new ConstantBooleanValue(false);
        }
        try {
            long longTemp = Long.parseLong(param);
            if (longTemp == (long)((int)longTemp)) {
                return new ConstantIntValue((int)longTemp);
            }
            return new ConstantLongValue(longTemp);
        }
        catch (NumberFormatException e1) {
            try {
                return new ConstantDoubleValue(Double.parseDouble(param));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return new ConstantDateValue(Instant.parse(param).toEpochMilli());
                }
                catch (DateTimeParseException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The parameter " + param + " could not be cast to any constant.");
                }
            }
        }
    };

    @Override
    public AnalyticsValue convertToConstant() {
        return this;
    }

    static String createExpressionString(AnalyticsValueStream func, Object param) {
        return String.format(Locale.ROOT, "%s(%s)", func.getName(), param.toString());
    }
}

