/*

 * A JavaScript implementation of the SHA family of hashes - defined in FIPS PUB 180-4, FIPS PUB 202,
 * and SP 800-185 - as well as the corresponding HMAC implementation as defined in FIPS PUB 198-1.
 *
 * Copyright 2008-2023 Brian Turek, 1998-2009 Paul Johnston & Contributors
 * Distributed under the BSD License
 * See http://caligatio.github.com/jsSHA/ for more information
 *
 * Two ECMAScript polyfill functions carry the following license:
 *
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION ANY IMPLIED WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
 * MERCHANTABLITY OR NON-INFRINGEMENT.
 *
 * See the Apache Version 2.0 License for specific language governing permissions and limitations under the License.

 */

!function(t,r){"object"==typeof exports&&"undefined"!=typeof module?module.exports=r():"function"==typeof define&&define.amd?define(r):(t="undefined"!=typeof globalThis?globalThis:t||self).jsSHA=r()}(this,function(){"use strict";var n=function(t,r){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,r){t.__proto__=r}||function(t,r){for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(t[n]=r[n])})(t,r)},v="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",r="ARRAYBUFFER not supported by this environment",e="UINT8ARRAY not supported by this environment";function o(t,r,n,e){for(var o,i,s=r||[0],u=(n=n||0)>>>3,h=-1===e?3:0,a=0;a<t.length;a+=1)o=(i=a+u)>>>2,s.length<=o&&s.push(0),s[o]|=t[a]<<8*(h+e*(i%4));return{value:s,binLen:8*t.length+n}}function i(t,A,g){switch(A){case"UTF8":case"UTF16BE":case"UTF16LE":break;default:throw new Error("encoding must be UTF8, UTF16BE, or UTF16LE")}switch(t){case"HEX":return function(t,r,n){var e,o,i,s=t,t=r,r=n,u=g;if(0!=s.length%2)throw new Error("String of HEX type must be in byte increments");for(var h=t||[0],a=(r=r||0)>>>3,f=-1===u?3:0,c=0;c<s.length;c+=2){if(e=parseInt(s.substr(c,2),16),isNaN(e))throw new Error("String of HEX type contains invalid characters");for(o=(i=(c>>>1)+a)>>>2;h.length<=o;)h.push(0);h[o]|=e<<8*(f+u*(i%4))}return{value:h,binLen:4*s.length+r}};case"TEXT":return function(t,r,n){var e,o,i,s,u,h,a,f,c=t,t=A,p=0,l=g,w=0,d=r||[0],v=(p=n||0)>>>3;if("UTF8"===t)for(a=-1===l?3:0,i=0;i<c.length;i+=1)for(o=[],(e=c.charCodeAt(i))<128?o.push(e):e<2048?(o.push(192|e>>>6),o.push(128|63&e)):e<55296||57344<=e?o.push(224|e>>>12,128|e>>>6&63,128|63&e):(e=65536+((1023&e)<<10|1023&c.charCodeAt(i+=1)),o.push(240|e>>>18,128|e>>>12&63,128|e>>>6&63,128|63&e)),s=0;s<o.length;s+=1){for(u=(h=w+v)>>>2;d.length<=u;)d.push(0);d[u]|=o[s]<<8*(a+l*(h%4)),w+=1}else for(a=-1===l?2:0,f="UTF16LE"===t&&1!==l||"UTF16LE"!==t&&1===l,i=0;i<c.length;i+=1){for(e=c.charCodeAt(i),!0==f&&(e=(s=255&e)<<8|e>>>8),u=(h=w+v)>>>2;d.length<=u;)d.push(0);d[u]|=e<<8*(a+l*(h%4)),w+=2}return{value:d,binLen:8*w+p}};case"B64":return function(t,r,n){var e,o,i,s,u,h,a=t,t=0,f=g,c=0,p=r||[0],l=(t=n||0)>>>3,w=-1===f?3:0,r=a.indexOf("=");if(-1===a.search(/^[a-zA-Z0-9=+/]+$/))throw new Error("Invalid character in base-64 string");if(a=a.replace(/=/g,""),-1!==r&&r<a.length)throw new Error("Invalid '=' found in base-64 string");for(e=0;e<a.length;e+=4){for(s=a.substr(e,4),o=i=0;o<s.length;o+=1)i|=v.indexOf(s.charAt(o))<<18-6*o;for(o=0;o<s.length-1;o+=1){for(u=(h=c+l)>>>2;p.length<=u;)p.push(0);p[u]|=(i>>>16-8*o&255)<<8*(w+f*(h%4)),c+=1}}return{value:p,binLen:8*c+t}};case"BYTES":return function(t,r,n){for(var e,o,i,s=t,t=0,u=g,h=r||[0],a=(t=n||0)>>>3,f=-1===u?3:0,c=0;c<s.length;c+=1)e=s.charCodeAt(c),o=(i=c+a)>>>2,h.length<=o&&h.push(0),h[o]|=e<<8*(f+u*(i%4));return{value:h,binLen:8*s.length+t}};case"ARRAYBUFFER":try{new ArrayBuffer(0)}catch(t){throw new Error(r)}return function(t,r,n){return r=r,n=n,e=g,o(new Uint8Array(t),r,n,e);var e};case"UINT8ARRAY":try{new Uint8Array(0)}catch(t){throw new Error(e)}return function(t,r,n){return o(t,r,n,g)};default:throw new Error("format must be HEX, TEXT, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY")}}function s(t,l,w,d){switch(t){case"HEX":return function(t){for(var r,n=t,e=w,t=d,o="0123456789abcdef",i="",s=l/8,u=-1===e?3:0,h=0;h<s;h+=1)r=n[h>>>2]>>>8*(u+e*(h%4)),i+=o.charAt(r>>>4&15)+o.charAt(15&r);return t.outputUpper?i.toUpperCase():i};case"B64":return function(t){for(var r,n,e,o,i=t,s=l,u=w,h=d,a="",f=s/8,c=-1===u?3:0,p=0;p<f;p+=3)for(e=p+1<f?i[p+1>>>2]:0,o=p+2<f?i[p+2>>>2]:0,n=(i[p>>>2]>>>8*(c+u*(p%4))&255)<<16|(e>>>8*(c+u*((p+1)%4))&255)<<8|o>>>8*(c+u*((p+2)%4))&255,r=0;r<4;r+=1)a+=8*p+6*r<=s?v.charAt(n>>>6*(3-r)&63):h.b64Pad;return a};case"BYTES":return function(t){for(var r,n=t,e=w,o="",i=l/8,s=-1===e?3:0,u=0;u<i;u+=1)r=n[u>>>2]>>>8*(s+e*(u%4))&255,o+=String.fromCharCode(r);return o};case"ARRAYBUFFER":try{new ArrayBuffer(0)}catch(t){throw new Error(r)}return function(t){for(var r=t,n=w,e=l/8,t=new ArrayBuffer(e),o=new Uint8Array(t),i=-1===n?3:0,s=0;s<e;s+=1)o[s]=r[s>>>2]>>>8*(i+n*(s%4))&255;return t};case"UINT8ARRAY":try{new Uint8Array(0)}catch(t){throw new Error(e)}return function(t){for(var r=t,n=w,e=l/8,o=-1===n?3:0,i=new Uint8Array(e),s=0;s<e;s+=1)i[s]=r[s>>>2]>>>8*(o+n*(s%4))&255;return i};default:throw new Error("format must be HEX, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY")}}var E=[1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298],u=[3238371032,914150663,812702999,4144912697,4290775857,1750603025,1694076839,3204075428],h=[1779033703,3144134277,1013904242,2773480762,1359893119,2600822924,528734635,1541459225];function a(t){var r={outputUpper:!1,b64Pad:"=",outputLen:-1},t=t||{},n="Output length must be a multiple of 8";if(r.outputUpper=t.outputUpper||!1,t.b64Pad&&(r.b64Pad=t.b64Pad),t.outputLen){if(t.outputLen%8!=0)throw new Error(n);r.outputLen=t.outputLen}else if(t.shakeLen){if(t.shakeLen%8!=0)throw new Error(n);r.outputLen=t.shakeLen}if("boolean"!=typeof r.outputUpper)throw new Error("Invalid outputUpper formatting option");if("string"!=typeof r.b64Pad)throw new Error("Invalid b64Pad formatting option");return r}function y(t,r){return t>>>r|t<<32-r}function m(t,r){var n=(65535&t)+(65535&r);return(65535&(t>>>16)+(r>>>16)+(n>>>16))<<16|65535&n}function f(t){return("SHA-224"==t?u:h).slice()}function c(t,r){for(var n,e,o,i,s,u,h,a=[],f=r[0],c=r[1],p=r[2],l=r[3],w=r[4],d=r[5],v=r[6],A=r[7],g=0;g<64;g+=1)a[g]=g<16?t[g]:(o=y(o=a[g-2],17)^y(o,19)^o>>>10,i=a[g-7],h=a[g-15],h=y(h,7)^y(h,18)^h>>>3,s=a[g-16],u=void 0,(65535&(o>>>16)+(i>>>16)+(h>>>16)+(s>>>16)+((u=(65535&o)+(65535&i)+(65535&h)+(65535&s))>>>16))<<16|65535&u),o=A,i=y(w,6)^y(w,11)^y(w,25),h=w&d^~w&v,s=E[g],u=a[g],e=void 0,n=m(y(f,2)^y(f,13)^y(f,22),f&c^f&p^c&p),A=v,v=d,d=w,w=m(l,e=(65535&(o>>>16)+(i>>>16)+(h>>>16)+(s>>>16)+(u>>>16)+((e=(65535&o)+(65535&i)+(65535&h)+(65535&s)+(65535&u))>>>16))<<16|65535&e),l=p,p=c,c=f,f=m(e,n);return r[0]=m(f,r[0]),r[1]=m(c,r[1]),r[2]=m(p,r[2]),r[3]=m(l,r[3]),r[4]=m(w,r[4]),r[5]=m(d,r[5]),r[6]=m(v,r[6]),r[7]=m(A,r[7]),r}A.prototype.update=function(t){for(var r=0,n=this.m>>>5,t=this.h(t,this.H,this.Y),e=t.binLen,o=t.value,i=e>>>5,s=0;s<i;s+=n)r+this.m<=e&&(this.R=this.p(o.slice(s,s+n),this.R),r+=this.m);return this.I+=r,this.H=o.slice(r>>>5),this.Y=e%this.m,this.C=!0,this},A.prototype.getHash=function(t,r){var n,e,o=this.F,r=a(r);if(this.g){if(-1===r.outputLen)throw new Error("Output length must be specified in options");o=r.outputLen}t=s(t,o,this.u,r);if(this.L&&this.t)return t(this.t(r));for(e=this.T(this.H.slice(),this.Y,this.I,this.A(this.R),o),n=1;n<this.numRounds;n+=1)this.g&&o%32!=0&&(e[e.length-1]&=16777215>>>24-o%32),e=this.T(e,o,0,this.U(this.S),o);return t(e)},A.prototype.setHMACKey=function(t,r,n){if(!this.o)throw new Error("Variant does not support HMAC");if(this.C)throw new Error("Cannot set MAC key after calling update");r=i(r,(n||{}).encoding||"UTF8",this.u);this.B(r(t))},A.prototype.B=function(t){var r,n=this.m>>>3,e=n/4-1;if(1!==this.numRounds)throw new Error("Cannot set numRounds with MAC");if(this.L)throw new Error("MAC key already set");for(n<t.binLen/8&&(t.value=this.T(t.value,t.binLen,0,this.U(this.S),this.F));t.value.length<=e;)t.value.push(0);for(r=0;r<=e;r+=1)this.N[r]=909522486^t.value[r],this.X[r]=1549556828^t.value[r];this.R=this.p(this.N,this.R),this.I=this.m,this.L=!0},A.prototype.getHMAC=function(t,r){r=a(r);return s(t,this.F,this.u,r)(this.i())},A.prototype.i=function(){if(!this.L)throw new Error("Cannot call getHMAC without first setting MAC key");var t=this.T(this.H.slice(),this.Y,this.I,this.A(this.R),this.F),r=this.p(this.X,this.U(this.S));return this.T(t,this.F,this.m,r,this.F)};var p=A;function t(h,t,r){var n=this;if("SHA-224"!==h&&"SHA-256"!==h)throw new Error("Chosen SHA variant is not supported");var e=r||{};return(n=p.call(this,h,t,r)||this).t=n.i,n.o=!0,n.u=-1,n.h=i(n.v,n.l,n.u),n.p=c,n.A=function(t){return t.slice()},n.U=f,n.T=function(t,r,n,e){for(var o,i=t,t=r,s=e,r=h,u=15+(t+65>>>9<<4),e=t+n;i.length<=u;)i.push(0);for(i[t>>>5]|=128<<24-t%32,i[u]=4294967295&e,i[u-1]=e/4294967296|0,o=0;o<i.length;o+=16)s=c(i.slice(o,o+16),s);return"SHA-224"===r?[s[0],s[1],s[2],s[3],s[4],s[5],s[6]]:s},n.R=f(h),n.m=512,n.F="SHA-224"===h?224:256,n.g=!1,e.hmacKey&&n.B(function(t,r){var n="hmacKey must include a value and format";if(!t)throw new Error(n);if(void 0!==t.value&&t.format)return i(t.format,t.encoding||"UTF8",r)(t.value);throw new Error(n)}(e.hmacKey,n.u)),n}var l=t,w=p;if("function"!=typeof w&&null!==w)throw new TypeError("Class extends value "+String(w)+" is not a constructor or null");function d(){this.constructor=l}return n(l,w),l.prototype=null===w?Object.create(w):(d.prototype=w.prototype,new d),t;function A(t,r,n){n=n||{};if(this.v=r,this.l=n.encoding||"UTF8",this.numRounds=n.numRounds||1,isNaN(this.numRounds)||this.numRounds!==parseInt(this.numRounds,10)||this.numRounds<1)throw new Error("numRounds must a integer >= 1");this.S=t,this.H=[],this.Y=0,this.C=!1,this.I=0,this.L=!1,this.N=[],this.X=[]}});