/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Polyline;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.Home3DAttributesController;
import com.eteks.sweethome3d.viewcontroller.PlanController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.View3D;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.undo.UndoableEditSupport;

public class HomeController3D
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private PlanController planController;
    private View home3DView;
    private final CameraControllerState topCameraState;
    private final CameraControllerState observerCameraState;
    private CameraControllerState cameraState;

    public HomeController3D(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.topCameraState = new TopCameraState(userPreferences);
        this.observerCameraState = new ObserverCameraState();
        this.setCameraState(home.getCamera() == home.getTopCamera() ? this.topCameraState : this.observerCameraState);
        this.addModelListeners(home);
    }

    public HomeController3D(Home home, PlanController planController, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this(home, userPreferences, viewFactory, contentManager, undoableEditSupport);
        this.planController = planController;
    }

    private void addModelListeners(final Home home) {
        home.addPropertyChangeListener(Home.Property.CAMERA, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeController3D.this.setCameraState(home.getCamera() == home.getTopCamera() ? HomeController3D.this.topCameraState : HomeController3D.this.observerCameraState);
            }
        });
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Level.Property.ELEVATION.name().equals(propertyChangeEvent.getPropertyName()) && home.getEnvironment().isObserverCameraElevationAdjusted()) {
                    home.getObserverCamera().setZ(Math.max(HomeController3D.this.getObserverCameraMinimumElevation(home), home.getObserverCamera().getZ() + ((Float)propertyChangeEvent.getNewValue()).floatValue() - ((Float)propertyChangeEvent.getOldValue()).floatValue()));
                }
            }
        };
        Level level = home.getSelectedLevel();
        if (level != null) {
            level.addPropertyChangeListener(propertyChangeListener);
        }
        home.addPropertyChangeListener(Home.Property.SELECTED_LEVEL, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Level level = (Level)propertyChangeEvent.getOldValue();
                Level level2 = home.getSelectedLevel();
                if (home.getEnvironment().isObserverCameraElevationAdjusted()) {
                    home.getObserverCamera().setZ(Math.max(HomeController3D.this.getObserverCameraMinimumElevation(home), home.getObserverCamera().getZ() + (level2 == null ? 0.0f : level2.getElevation()) - (level == null ? 0.0f : level.getElevation())));
                }
                if (level != null) {
                    level.removePropertyChangeListener(propertyChangeListener);
                }
                if (level2 != null) {
                    level2.addPropertyChangeListener(propertyChangeListener);
                }
            }
        });
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                List<Level> list = home.getLevels();
                Level level = home.getSelectedLevel();
                boolean bl = true;
                for (int i = 0; i < list.size(); ++i) {
                    list.get(i).setVisible(bl);
                    if (list.get(i) != level || home.getEnvironment().isAllLevelsVisible()) continue;
                    bl = false;
                }
            }
        };
        home.addPropertyChangeListener(Home.Property.SELECTED_LEVEL, propertyChangeListener2);
        home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.ALL_LEVELS_VISIBLE, propertyChangeListener2);
    }

    private float getObserverCameraMinimumElevation(Home home) {
        List<Level> list = home.getLevels();
        float f = list.size() == 0 ? 10.0f : 10.0f + list.get(0).getElevation();
        return f;
    }

    @Override
    public View getView() {
        if (this.home3DView == null) {
            this.home3DView = this.viewFactory.createView3D(this.home, this.preferences, this);
        }
        return this.home3DView;
    }

    public void viewFromTop() {
        this.home.setCamera(this.home.getTopCamera());
    }

    public void viewFromObserver() {
        this.home.setCamera(this.home.getObserverCamera());
    }

    public void storeCamera(String string) {
        Camera camera = (Camera)this.home.getCamera().duplicate();
        camera.setName(string);
        List<Camera> list = this.home.getStoredCameras();
        ArrayList<Camera> arrayList = new ArrayList<Camera>(list.size() + 1);
        arrayList.addAll(list);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Camera camera2 = (Camera)arrayList.get(i);
            if (!string.equals(camera2.getName()) && (camera.getX() != camera2.getX() || camera.getY() != camera2.getY() || camera.getZ() != camera2.getZ() || camera.getPitch() != camera2.getPitch() || camera.getYaw() != camera2.getYaw() || camera.getFieldOfView() != camera2.getFieldOfView() || camera.getTime() != camera2.getTime() || camera.getLens() != camera2.getLens() || camera.getRenderer() != camera2.getRenderer() && (camera.getRenderer() == null || !camera.getRenderer().equals(camera2.getRenderer())))) continue;
            arrayList.remove(i);
        }
        arrayList.add(0, camera);
        while (arrayList.size() > this.preferences.getStoredCamerasMaxCount()) {
            arrayList.remove(arrayList.size() - 1);
        }
        this.home.setStoredCameras(arrayList);
    }

    public void goToCamera(Camera camera) {
        if (camera instanceof ObserverCamera) {
            this.viewFromObserver();
        } else {
            this.viewFromTop();
        }
        this.cameraState.goToCamera(camera);
        ArrayList<Camera> arrayList = new ArrayList<Camera>(this.home.getStoredCameras());
        arrayList.remove(camera);
        arrayList.add(0, camera);
        this.home.setStoredCameras(arrayList);
    }

    public void deleteCameras(List<Camera> list) {
        List<Camera> list2 = this.home.getStoredCameras();
        ArrayList<Camera> arrayList = new ArrayList<Camera>(list2.size() - list.size());
        for (Camera camera : list2) {
            if (list.contains(camera)) continue;
            arrayList.add(camera);
        }
        this.home.setStoredCameras(arrayList);
    }

    public void displayAllLevels() {
        this.home.getEnvironment().setAllLevelsVisible(true);
    }

    public void displaySelectedLevel() {
        this.home.getEnvironment().setAllLevelsVisible(false);
    }

    public void modifyAttributes() {
        new Home3DAttributesController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
    }

    protected void setCameraState(CameraControllerState cameraControllerState) {
        if (this.cameraState != null) {
            this.cameraState.exit();
        }
        this.cameraState = cameraControllerState;
        this.cameraState.enter();
    }

    public void moveCamera(float f) {
        this.cameraState.moveCamera(f);
    }

    public void moveCameraSideways(float f) {
        this.cameraState.moveCameraSideways(f);
    }

    public void elevateCamera(float f) {
        this.cameraState.elevateCamera(f);
    }

    public void rotateCameraYaw(float f) {
        this.cameraState.rotateCameraYaw(f);
    }

    public void rotateCameraPitch(float f) {
        this.cameraState.rotateCameraPitch(f);
    }

    public void modifyFieldOfView(float f) {
        this.cameraState.modifyFieldOfView(f);
    }

    public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, View.PointerType pointerType) {
        this.cameraState.pressMouse(f, f2, n, bl, bl2, bl3, bl4, pointerType);
    }

    public void releaseMouse(float f, float f2) {
        this.cameraState.releaseMouse(f, f2);
    }

    public void moveMouse(float f, float f2) {
        this.cameraState.moveMouse(f, f2);
    }

    public boolean isEditingState() {
        return this.cameraState.isEditingState();
    }

    public void escape() {
        this.cameraState.escape();
    }

    public void toggleMagnetism(boolean bl) {
        this.cameraState.toggleMagnetism(bl);
    }

    public void setAlignmentActivated(boolean bl) {
        this.cameraState.setAlignmentActivated(bl);
    }

    public void setDuplicationActivated(boolean bl) {
        this.cameraState.setDuplicationActivated(bl);
    }

    protected CameraControllerState getObserverCameraState() {
        return this.observerCameraState;
    }

    protected CameraControllerState getTopCameraState() {
        return this.topCameraState;
    }

    private class ObserverCameraState
    extends EditingCameraState {
        private ObserverCamera observerCamera;
        private PropertyChangeListener levelElevationChangeListener;
        private CollectionListener<Level> levelsListener;

        private ObserverCameraState() {
            this.levelElevationChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (Level.Property.ELEVATION.name().equals(propertyChangeEvent.getPropertyName())) {
                        ObserverCameraState.this.updateCameraMinimumElevation();
                    }
                }
            };
            this.levelsListener = new CollectionListener<Level>(){

                @Override
                public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                    if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                        collectionEvent.getItem().addPropertyChangeListener(ObserverCameraState.this.levelElevationChangeListener);
                    } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                        collectionEvent.getItem().removePropertyChangeListener(ObserverCameraState.this.levelElevationChangeListener);
                    }
                    ObserverCameraState.this.updateCameraMinimumElevation();
                }
            };
        }

        @Override
        public void enter() {
            this.observerCamera = (ObserverCamera)HomeController3D.this.home.getCamera();
            for (Level level : HomeController3D.this.home.getLevels()) {
                level.addPropertyChangeListener(this.levelElevationChangeListener);
            }
            HomeController3D.this.home.addLevelsListener(this.levelsListener);
            this.selectCamera();
        }

        private void selectCamera() {
            if (HomeController3D.this.preferences.isObserverCameraSelectedAtChange()) {
                List<Selectable> list = HomeController3D.this.home.getSelectedItems();
                if (!HomeController3D.this.preferences.isEditingIn3DViewEnabled() || list.isEmpty() || list.size() == 1 && list.get(0) == this.observerCamera) {
                    HomeController3D.this.home.setSelectedItems(Arrays.asList(this.observerCamera));
                }
            }
        }

        @Override
        public void moveCamera(float f) {
            super.moveCamera(f);
            this.observerCamera.setX(this.observerCamera.getX() - (float)Math.sin(this.observerCamera.getYaw()) * f);
            this.observerCamera.setY(this.observerCamera.getY() + (float)Math.cos(this.observerCamera.getYaw()) * f);
            this.selectCamera();
        }

        @Override
        public void moveCameraSideways(float f) {
            super.moveCameraSideways(f);
            this.observerCamera.setX(this.observerCamera.getX() - (float)Math.cos(this.observerCamera.getYaw()) * f);
            this.observerCamera.setY(this.observerCamera.getY() - (float)Math.sin(this.observerCamera.getYaw()) * f);
            this.selectCamera();
        }

        @Override
        public void elevateCamera(float f) {
            super.elevateCamera(f);
            float f2 = this.observerCamera.getZ() + f;
            f2 = Math.min(Math.max(f2, this.getMinimumElevation()), HomeController3D.this.preferences.getLengthUnit().getMaximumElevation());
            this.observerCamera.setZ(f2);
            this.selectCamera();
        }

        private void updateCameraMinimumElevation() {
            this.observerCamera.setZ(Math.max(this.observerCamera.getZ(), this.getMinimumElevation()));
        }

        public float getMinimumElevation() {
            List<Level> list = HomeController3D.this.home.getLevels();
            if (list.size() > 0) {
                return 10.0f + list.get(0).getElevation();
            }
            return 10.0f;
        }

        @Override
        public void rotateCameraYaw(float f) {
            super.rotateCameraYaw(f);
            this.observerCamera.setYaw(this.observerCamera.getYaw() + f);
            this.selectCamera();
        }

        @Override
        public void rotateCameraPitch(float f) {
            super.rotateCameraPitch(f);
            float f2 = this.observerCamera.getPitch() + f;
            f2 = Math.min(Math.max(-1.5707964f, f2), 1.5707964f);
            this.observerCamera.setPitch(f2);
            this.selectCamera();
        }

        @Override
        public void modifyFieldOfView(float f) {
            super.modifyFieldOfView(f);
            float f2 = this.observerCamera.getFieldOfView() + f;
            f2 = (float)Math.min(Math.max(Math.toRadians(2.0), (double)f2), Math.toRadians(120.0));
            this.observerCamera.setFieldOfView(f2);
            this.selectCamera();
        }

        @Override
        public void goToCamera(Camera camera) {
            super.goToCamera(camera);
            this.observerCamera.setCamera(camera);
            this.observerCamera.setTime(camera.getTime());
            this.observerCamera.setLens(camera.getLens());
            this.observerCamera.setRenderer(camera.getRenderer());
        }

        @Override
        public void exit() {
            List<Selectable> list = HomeController3D.this.home.getSelectedItems();
            if (list.contains(this.observerCamera)) {
                list = new ArrayList<Selectable>(list);
                list.remove(this.observerCamera);
                HomeController3D.this.home.setSelectedItems(list);
            }
            for (Level level : HomeController3D.this.home.getLevels()) {
                level.removePropertyChangeListener(this.levelElevationChangeListener);
            }
            HomeController3D.this.home.removeLevelsListener(this.levelsListener);
            this.observerCamera = null;
        }
    }

    private static class UserPreferencesChangeListener
    implements PropertyChangeListener {
        private WeakReference<TopCameraState> topCameraState;

        public UserPreferencesChangeListener(TopCameraState topCameraState) {
            this.topCameraState = new WeakReference<TopCameraState>(topCameraState);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TopCameraState topCameraState = (TopCameraState)this.topCameraState.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            if (topCameraState == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName()), this);
            } else {
                topCameraState.setAerialViewCenteredOnSelectionEnabled(userPreferences.isAerialViewCenteredOnSelectionEnabled());
            }
        }
    }

    private class TopCameraState
    extends EditingCameraState {
        private final float MIN_WIDTH = 100.0f;
        private final float MIN_DEPTH = 100.0f;
        private final float MIN_HEIGHT = 20.0f;
        private Camera topCamera;
        private float[] aerialViewBoundsLowerPoint;
        private float[] aerialViewBoundsUpperPoint;
        private float minDistanceToAerialViewCenter;
        private float maxDistanceToAerialViewCenter;
        private boolean aerialViewCenteredOnSelectionEnabled;
        private boolean previousSelectionEmpty;
        private float distanceToCenterWithSelection;
        private PropertyChangeListener objectChangeListener;
        private CollectionListener<Level> levelsListener;
        private CollectionListener<Wall> wallsListener;
        private CollectionListener<HomePieceOfFurniture> furnitureListener;
        private CollectionListener<Room> roomsListener;
        private CollectionListener<Polyline> polylinesListener;
        private CollectionListener<DimensionLine> dimensionLinesListener;
        private CollectionListener<Label> labelsListener;
        private SelectionListener selectionListener;
        private UserPreferencesChangeListener userPreferencesChangeListener;

        public TopCameraState(UserPreferences userPreferences) {
            this.MIN_WIDTH = 100.0f;
            this.MIN_DEPTH = 100.0f;
            this.MIN_HEIGHT = 20.0f;
            this.distanceToCenterWithSelection = -1.0f;
            this.objectChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TopCameraState.this.updateCameraFromHomeBounds(false, false);
                }
            };
            this.levelsListener = new CollectionListener<Level>(){

                @Override
                public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                    if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                        collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                    } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                        collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                    }
                    TopCameraState.this.updateCameraFromHomeBounds(false, false);
                }
            };
            this.wallsListener = new CollectionListener<Wall>(){

                @Override
                public void collectionChanged(CollectionEvent<Wall> collectionEvent) {
                    if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                        collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                    } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                        collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                    }
                    TopCameraState.this.updateCameraFromHomeBounds(false, false);
                }
            };
            this.furnitureListener = new CollectionListener<HomePieceOfFurniture>(){

                @Override
                public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                    if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                        TopCameraState.this.addPropertyChangeListener(collectionEvent.getItem(), TopCameraState.this.objectChangeListener);
                        TopCameraState.this.updateCameraFromHomeBounds(HomeController3D.this.home.getFurniture().size() == 1 && HomeController3D.this.home.getWalls().isEmpty() && HomeController3D.this.home.getRooms().isEmpty(), false);
                    } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                        TopCameraState.this.removePropertyChangeListener(collectionEvent.getItem(), TopCameraState.this.objectChangeListener);
                        TopCameraState.this.updateCameraFromHomeBounds(false, false);
                    }
                }
            };
            this.roomsListener = new CollectionListener<Room>(){

                @Override
                public void collectionChanged(CollectionEvent<Room> collectionEvent) {
                    if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                        collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                    } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                        collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                    }
                    TopCameraState.this.updateCameraFromHomeBounds(false, false);
                }
            };
            this.polylinesListener = new CollectionListener<Polyline>(){

                @Override
                public void collectionChanged(CollectionEvent<Polyline> collectionEvent) {
                    if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                        collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                    } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                        collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                    }
                    TopCameraState.this.updateCameraFromHomeBounds(false, false);
                }
            };
            this.dimensionLinesListener = new CollectionListener<DimensionLine>(){

                @Override
                public void collectionChanged(CollectionEvent<DimensionLine> collectionEvent) {
                    if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                        collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                    } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                        collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                    }
                    TopCameraState.this.updateCameraFromHomeBounds(false, false);
                }
            };
            this.labelsListener = new CollectionListener<Label>(){

                @Override
                public void collectionChanged(CollectionEvent<Label> collectionEvent) {
                    if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                        collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                    } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                        collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                    }
                    TopCameraState.this.updateCameraFromHomeBounds(false, false);
                }
            };
            this.selectionListener = new SelectionListener(){

                @Override
                public void selectionChanged(SelectionEvent selectionEvent) {
                    boolean bl = selectionEvent.getSelectedItems().isEmpty();
                    TopCameraState.this.updateCameraFromHomeBounds(false, TopCameraState.this.previousSelectionEmpty && !bl);
                    TopCameraState.this.previousSelectionEmpty = bl;
                }
            };
            this.userPreferencesChangeListener = new UserPreferencesChangeListener(this);
        }

        private void addPropertyChangeListener(HomePieceOfFurniture homePieceOfFurniture, PropertyChangeListener propertyChangeListener) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                    this.addPropertyChangeListener(homePieceOfFurniture2, propertyChangeListener);
                }
            } else {
                homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener);
            }
        }

        private void removePropertyChangeListener(HomePieceOfFurniture homePieceOfFurniture, PropertyChangeListener propertyChangeListener) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                    this.removePropertyChangeListener(homePieceOfFurniture2, propertyChangeListener);
                }
            } else {
                homePieceOfFurniture.removePropertyChangeListener(propertyChangeListener);
            }
        }

        @Override
        public void enter() {
            this.topCamera = HomeController3D.this.home.getCamera();
            this.previousSelectionEmpty = HomeController3D.this.home.getSelectedItems().isEmpty();
            this.aerialViewCenteredOnSelectionEnabled = HomeController3D.this.preferences.isAerialViewCenteredOnSelectionEnabled();
            this.updateCameraFromHomeBounds(false, false);
            for (Level homeObject : HomeController3D.this.home.getLevels()) {
                homeObject.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addLevelsListener(this.levelsListener);
            for (Wall wall : HomeController3D.this.home.getWalls()) {
                wall.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addWallsListener(this.wallsListener);
            for (HomePieceOfFurniture homePieceOfFurniture : HomeController3D.this.home.getFurniture()) {
                this.addPropertyChangeListener(homePieceOfFurniture, this.objectChangeListener);
            }
            HomeController3D.this.home.addFurnitureListener(this.furnitureListener);
            for (Room room : HomeController3D.this.home.getRooms()) {
                room.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addRoomsListener(this.roomsListener);
            for (Polyline polyline : HomeController3D.this.home.getPolylines()) {
                polyline.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addPolylinesListener(this.polylinesListener);
            for (DimensionLine dimensionLine : HomeController3D.this.home.getDimensionLines()) {
                dimensionLine.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addDimensionLinesListener(this.dimensionLinesListener);
            for (Label label : HomeController3D.this.home.getLabels()) {
                label.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addLabelsListener(this.labelsListener);
            HomeController3D.this.home.addSelectionListener(this.selectionListener);
            HomeController3D.this.preferences.addPropertyChangeListener(UserPreferences.Property.AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED, this.userPreferencesChangeListener);
        }

        public void setAerialViewCenteredOnSelectionEnabled(boolean bl) {
            this.aerialViewCenteredOnSelectionEnabled = bl;
            this.updateCameraFromHomeBounds(false, false);
        }

        private void updateCameraFromHomeBounds(boolean bl, boolean bl2) {
            if (!this.isEditingState()) {
                if (this.aerialViewBoundsLowerPoint == null) {
                    this.updateAerialViewBoundsFromHomeBounds(this.aerialViewCenteredOnSelectionEnabled);
                }
                float f = bl2 && HomeController3D.this.preferences.isAerialViewCenteredOnSelectionEnabled() && this.distanceToCenterWithSelection != -1.0f ? this.distanceToCenterWithSelection : this.getCameraToAerialViewCenterDistance();
                if (!HomeController3D.this.home.getSelectedItems().isEmpty()) {
                    this.distanceToCenterWithSelection = f;
                }
                this.updateAerialViewBoundsFromHomeBounds(this.aerialViewCenteredOnSelectionEnabled);
                this.updateCameraIntervalToAerialViewCenter();
                this.placeCameraAt(f, bl);
            }
        }

        private float getCameraToAerialViewCenterDistance() {
            return (float)Math.sqrt(Math.pow((this.aerialViewBoundsLowerPoint[0] + this.aerialViewBoundsUpperPoint[0]) / 2.0f - this.topCamera.getX(), 2.0) + Math.pow((this.aerialViewBoundsLowerPoint[1] + this.aerialViewBoundsUpperPoint[1]) / 2.0f - this.topCamera.getY(), 2.0) + Math.pow((this.aerialViewBoundsLowerPoint[2] + this.aerialViewBoundsUpperPoint[2]) / 2.0f - this.topCamera.getZ(), 2.0));
        }

        private void updateAerialViewBoundsFromHomeBounds(boolean bl) {
            Object object;
            float f;
            float f2;
            this.aerialViewBoundsUpperPoint = null;
            this.aerialViewBoundsLowerPoint = null;
            List list = Collections.emptyList();
            if (bl) {
                list = new ArrayList();
                for (Selectable selectable : HomeController3D.this.home.getSelectedItems()) {
                    if (!(selectable instanceof Elevatable) || !this.isItemAtVisibleLevel((Elevatable)((Object)selectable)) || selectable instanceof HomePieceOfFurniture && !((HomePieceOfFurniture)selectable).isVisible() || selectable instanceof Polyline && !((Polyline)selectable).isVisibleIn3D() || selectable instanceof DimensionLine && !((DimensionLine)selectable).isVisibleIn3D() || selectable instanceof Label && ((Label)selectable).getPitch() == null) continue;
                    list.add(selectable);
                }
            }
            boolean bl2 = list.size() == 0 || !bl;
            boolean bl3 = false;
            for (Wall homeObject : bl2 ? HomeController3D.this.home.getWalls() : Home.getWallsSubList(list)) {
                if (!this.isItemAtVisibleLevel(homeObject)) continue;
                bl3 = true;
                f2 = homeObject.getLevel() != null ? homeObject.getLevel().getElevation() : 0.0f;
                f = bl2 ? 0.0f : f2;
                object = homeObject.getHeight();
                float f3 = object != null ? f2 + ((Float)object).floatValue() : f2 + HomeController3D.this.home.getWallHeight();
                Float f4 = homeObject.getHeightAtEnd();
                if (f4 != null) {
                    f3 = Math.max(f3, f2 + f4.floatValue());
                }
                for (float[] fArray : homeObject.getPoints()) {
                    this.updateAerialViewBounds(fArray[0], fArray[1], f, f3);
                }
            }
            for (HomePieceOfFurniture homePieceOfFurniture : bl2 ? HomeController3D.this.home.getFurniture() : Home.getFurnitureSubList(list)) {
                if (!homePieceOfFurniture.isVisible() || !this.isItemAtVisibleLevel(homePieceOfFurniture)) continue;
                if (bl2) {
                    f2 = Math.max(0.0f, homePieceOfFurniture.getGroundElevation());
                    f = Math.max(0.0f, homePieceOfFurniture.getGroundElevation() + homePieceOfFurniture.getHeightInPlan());
                } else {
                    f2 = homePieceOfFurniture.getGroundElevation();
                    f = homePieceOfFurniture.getGroundElevation() + homePieceOfFurniture.getHeightInPlan();
                }
                for (Object object2 : (Object)homePieceOfFurniture.getPoints()) {
                    this.updateAerialViewBounds((float)object2[0], (float)object2[1], f2, f);
                }
            }
            for (Room room : bl2 ? HomeController3D.this.home.getRooms() : Home.getRoomsSubList(list)) {
                if (!this.isItemAtVisibleLevel(room)) continue;
                f2 = 0.0f;
                f = 20.0f;
                object = room.getLevel();
                if (object != null) {
                    f2 = ((Level)object).getElevation() - ((Level)object).getFloorThickness();
                    f = ((Level)object).getElevation();
                    if (bl2) {
                        f2 = Math.max(0.0f, f2);
                        f = Math.max(20.0f, ((Level)object).getElevation());
                    }
                }
                for (float[] fArray : room.getPoints()) {
                    this.updateAerialViewBounds(fArray[0], fArray[1], f2, f);
                }
            }
            for (Polyline polyline : bl2 ? HomeController3D.this.home.getPolylines() : Home.getPolylinesSubList(list)) {
                if (!polyline.isVisibleIn3D() || !this.isItemAtVisibleLevel(polyline)) continue;
                if (bl2) {
                    f2 = Math.max(0.0f, polyline.getGroundElevation());
                    f = Math.max(20.0f, polyline.getGroundElevation());
                } else {
                    f2 = f = polyline.getGroundElevation();
                }
                for (Object object3 : (Object)polyline.getPoints()) {
                    this.updateAerialViewBounds((float)object3[0], (float)object3[1], f2, f);
                }
            }
            for (DimensionLine dimensionLine : bl2 ? HomeController3D.this.home.getDimensionLines() : Home.getDimensionLinesSubList(list)) {
                float f5;
                if (!dimensionLine.isVisibleIn3D() || !this.isItemAtVisibleLevel(dimensionLine)) continue;
                float f6 = f2 = dimensionLine.getLevel() != null ? dimensionLine.getLevel().getElevation() : 0.0f;
                if (bl2) {
                    f = Math.max(0.0f, f2 + dimensionLine.getElevationStart());
                    f5 = Math.max(20.0f, f2 + dimensionLine.getElevationEnd());
                } else {
                    f = f2 + dimensionLine.getElevationStart();
                    f5 = f2 + dimensionLine.getElevationEnd();
                }
                for (float[] fArray : dimensionLine.getPoints()) {
                    this.updateAerialViewBounds(fArray[0], fArray[1], f, f5);
                }
            }
            for (Label label : bl2 ? HomeController3D.this.home.getLabels() : Home.getLabelsSubList(list)) {
                if (label.getPitch() == null || !this.isItemAtVisibleLevel(label)) continue;
                if (bl2) {
                    f2 = Math.max(0.0f, label.getGroundElevation());
                    f = Math.max(20.0f, label.getGroundElevation());
                } else {
                    f2 = f = label.getGroundElevation();
                }
                for (float[] fArray : label.getPoints()) {
                    this.updateAerialViewBounds(fArray[0], fArray[1], f2, f);
                }
            }
            if (this.aerialViewBoundsLowerPoint == null) {
                this.aerialViewBoundsLowerPoint = new float[]{0.0f, 0.0f, 0.0f};
                this.aerialViewBoundsUpperPoint = new float[]{100.0f, 100.0f, 20.0f};
            } else if (bl3 && bl2) {
                if (100.0f > this.aerialViewBoundsUpperPoint[0] - this.aerialViewBoundsLowerPoint[0]) {
                    this.aerialViewBoundsLowerPoint[0] = (this.aerialViewBoundsLowerPoint[0] + this.aerialViewBoundsUpperPoint[0]) / 2.0f - 50.0f;
                    this.aerialViewBoundsUpperPoint[0] = this.aerialViewBoundsLowerPoint[0] + 100.0f;
                }
                if (100.0f > this.aerialViewBoundsUpperPoint[1] - this.aerialViewBoundsLowerPoint[1]) {
                    this.aerialViewBoundsLowerPoint[1] = (this.aerialViewBoundsLowerPoint[1] + this.aerialViewBoundsUpperPoint[1]) / 2.0f - 50.0f;
                    this.aerialViewBoundsUpperPoint[1] = this.aerialViewBoundsLowerPoint[1] + 100.0f;
                }
                if (20.0f > this.aerialViewBoundsUpperPoint[2] - this.aerialViewBoundsLowerPoint[2]) {
                    this.aerialViewBoundsLowerPoint[2] = (this.aerialViewBoundsLowerPoint[2] + this.aerialViewBoundsUpperPoint[2]) / 2.0f - 10.0f;
                    this.aerialViewBoundsUpperPoint[2] = this.aerialViewBoundsLowerPoint[2] + 20.0f;
                }
            }
        }

        private void updateAerialViewBounds(float f, float f2, float f3, float f4) {
            if (this.aerialViewBoundsLowerPoint == null) {
                this.aerialViewBoundsLowerPoint = new float[]{f, f2, f3};
                this.aerialViewBoundsUpperPoint = new float[]{f, f2, f4};
            } else {
                this.aerialViewBoundsLowerPoint[0] = Math.min(this.aerialViewBoundsLowerPoint[0], f);
                this.aerialViewBoundsUpperPoint[0] = Math.max(this.aerialViewBoundsUpperPoint[0], f);
                this.aerialViewBoundsLowerPoint[1] = Math.min(this.aerialViewBoundsLowerPoint[1], f2);
                this.aerialViewBoundsUpperPoint[1] = Math.max(this.aerialViewBoundsUpperPoint[1], f2);
                this.aerialViewBoundsLowerPoint[2] = Math.min(this.aerialViewBoundsLowerPoint[2], f3);
                this.aerialViewBoundsUpperPoint[2] = Math.max(this.aerialViewBoundsUpperPoint[2], f4);
            }
        }

        private boolean isItemAtVisibleLevel(Elevatable elevatable) {
            return elevatable.getLevel() == null || elevatable.getLevel().isViewableAndVisible();
        }

        private void updateCameraIntervalToAerialViewCenter() {
            float f = this.aerialViewBoundsUpperPoint[0] - this.aerialViewBoundsLowerPoint[0];
            float f2 = this.aerialViewBoundsUpperPoint[1] - this.aerialViewBoundsLowerPoint[1];
            float f3 = this.aerialViewBoundsUpperPoint[2] - this.aerialViewBoundsLowerPoint[2];
            float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3) / 2.0f;
            this.minDistanceToAerialViewCenter = f4 * 1.05f;
            this.maxDistanceToAerialViewCenter = Math.max(5.0f * this.minDistanceToAerialViewCenter, 5000.0f);
        }

        @Override
        public void moveCamera(float f) {
            super.moveCamera(f);
            float f2 = this.getCameraToAerialViewCenterDistance() - (f *= 5.0f);
            this.placeCameraAt(f2, false);
        }

        public void placeCameraAt(float f, boolean bl) {
            f = Math.max(f, this.minDistanceToAerialViewCenter);
            f = Math.min(f, this.maxDistanceToAerialViewCenter);
            if (bl) {
                f = Math.min(f, 3.0f * this.minDistanceToAerialViewCenter);
            }
            double d = (double)f * Math.cos(this.topCamera.getPitch());
            this.topCamera.setX((this.aerialViewBoundsLowerPoint[0] + this.aerialViewBoundsUpperPoint[0]) / 2.0f + (float)(Math.sin(this.topCamera.getYaw()) * d));
            this.topCamera.setY((this.aerialViewBoundsLowerPoint[1] + this.aerialViewBoundsUpperPoint[1]) / 2.0f - (float)(Math.cos(this.topCamera.getYaw()) * d));
            this.topCamera.setZ((this.aerialViewBoundsLowerPoint[2] + this.aerialViewBoundsUpperPoint[2]) / 2.0f + (float)Math.sin(this.topCamera.getPitch()) * f);
        }

        @Override
        public void rotateCameraYaw(float f) {
            super.rotateCameraYaw(f);
            float f2 = this.topCamera.getYaw() + f;
            double d = (double)this.getCameraToAerialViewCenterDistance() * Math.cos(this.topCamera.getPitch());
            this.topCamera.setYaw(f2);
            this.topCamera.setX((this.aerialViewBoundsLowerPoint[0] + this.aerialViewBoundsUpperPoint[0]) / 2.0f + (float)(Math.sin(f2) * d));
            this.topCamera.setY((this.aerialViewBoundsLowerPoint[1] + this.aerialViewBoundsUpperPoint[1]) / 2.0f - (float)(Math.cos(f2) * d));
        }

        @Override
        public void rotateCameraPitch(float f) {
            super.rotateCameraPitch(f);
            float f2 = this.topCamera.getPitch() + f;
            f2 = Math.max(f2, 0.0f);
            f2 = Math.min(f2, 1.5707964f);
            double d = this.getCameraToAerialViewCenterDistance();
            double d2 = d * Math.cos(f2);
            this.topCamera.setPitch(f2);
            this.topCamera.setX((this.aerialViewBoundsLowerPoint[0] + this.aerialViewBoundsUpperPoint[0]) / 2.0f + (float)(Math.sin(this.topCamera.getYaw()) * d2));
            this.topCamera.setY((this.aerialViewBoundsLowerPoint[1] + this.aerialViewBoundsUpperPoint[1]) / 2.0f - (float)(Math.cos(this.topCamera.getYaw()) * d2));
            this.topCamera.setZ((this.aerialViewBoundsLowerPoint[2] + this.aerialViewBoundsUpperPoint[2]) / 2.0f + (float)(d * Math.sin(f2)));
        }

        @Override
        public void goToCamera(Camera camera) {
            super.goToCamera(camera);
            this.topCamera.setCamera(camera);
            this.topCamera.setTime(camera.getTime());
            this.topCamera.setLens(camera.getLens());
            this.topCamera.setRenderer(camera.getRenderer());
            this.updateCameraFromHomeBounds(false, false);
        }

        @Override
        public void releaseMouse(float f, float f2) {
            super.releaseMouse(f, f2);
            this.updateCameraFromHomeBounds(false, false);
        }

        @Override
        public void exit() {
            this.topCamera = null;
            for (Wall homeObject : HomeController3D.this.home.getWalls()) {
                homeObject.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removeWallsListener(this.wallsListener);
            for (HomePieceOfFurniture homePieceOfFurniture : HomeController3D.this.home.getFurniture()) {
                this.removePropertyChangeListener(homePieceOfFurniture, this.objectChangeListener);
            }
            HomeController3D.this.home.removeFurnitureListener(this.furnitureListener);
            for (Room room : HomeController3D.this.home.getRooms()) {
                room.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removeRoomsListener(this.roomsListener);
            for (Polyline polyline : HomeController3D.this.home.getPolylines()) {
                polyline.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removePolylinesListener(this.polylinesListener);
            for (DimensionLine dimensionLine : HomeController3D.this.home.getDimensionLines()) {
                dimensionLine.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removeDimensionLinesListener(this.dimensionLinesListener);
            for (Label label : HomeController3D.this.home.getLabels()) {
                label.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removeLabelsListener(this.labelsListener);
            for (Level level : HomeController3D.this.home.getLevels()) {
                level.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removeLevelsListener(this.levelsListener);
            HomeController3D.this.home.removeSelectionListener(this.selectionListener);
            HomeController3D.this.preferences.removePropertyChangeListener(UserPreferences.Property.AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED, this.userPreferencesChangeListener);
        }
    }

    protected abstract class EditingCameraState
    extends CameraControllerState {
        private boolean cameraMoved;
        private boolean mouseMoved;
        private boolean elevationActivated;
        private boolean rotationActivated;
        private float[] lastMousePressedPoint3D;
        private float distancesRatio;
        private float yLastMousePress;
        private Float angleMousePress;
        private boolean alignmentActivated;
        private boolean duplicationActivated;
        private boolean magnetismToggled;
        private View.PointerType pointerType;
        private ArrayList<HomePieceOfFurniture> movedItems;
        private HomePieceOfFurniture closestMovedPiece;
        private float[] movedItemsStartPoint;
        private Float movedItemsDeltaX;
        private Float movedItemsDeltaY;

        protected EditingCameraState() {
        }

        @Override
        public boolean isEditingState() {
            return this.movedItems != null;
        }

        @Override
        public void moveCamera(float f) {
            this.cameraMoved = true;
        }

        @Override
        public void moveCameraSideways(float f) {
            this.cameraMoved = true;
        }

        @Override
        public void elevateCamera(float f) {
            this.cameraMoved = true;
        }

        @Override
        public void rotateCameraYaw(float f) {
            this.cameraMoved = true;
        }

        @Override
        public void rotateCameraPitch(float f) {
            this.cameraMoved = true;
        }

        @Override
        public void modifyFieldOfView(float f) {
            this.cameraMoved = true;
        }

        @Override
        public void goToCamera(Camera camera) {
            this.cameraMoved = true;
        }

        @Override
        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, View.PointerType pointerType) {
            if (HomeController3D.this.planController != null && HomeController3D.this.preferences.isEditingIn3DViewEnabled() && HomeController3D.this.getView() instanceof View3D && !HomeController3D.this.planController.isModificationState()) {
                if (n == 1) {
                    Selectable selectable = ((View3D)HomeController3D.this.getView()).getClosestSelectableItemAt(Math.round(f), Math.round(f2));
                    ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
                    List<Selectable> list = HomeController3D.this.home.getSelectedItems();
                    for (Selectable selectable2 : list) {
                        if (selectable2 instanceof HomeFurnitureGroup) {
                            arrayList.addAll(((HomeFurnitureGroup)selectable2).getAllFurniture());
                            continue;
                        }
                        arrayList.add(selectable2);
                    }
                    if (arrayList.contains(selectable) && HomeController3D.this.planController.isItemMovable(selectable) && selectable instanceof HomePieceOfFurniture) {
                        this.movedItems = new ArrayList();
                        for (Selectable selectable2 : list) {
                            if (!HomeController3D.this.planController.isItemMovable(selectable2) || !(selectable2 instanceof HomePieceOfFurniture)) continue;
                            this.movedItems.add((HomePieceOfFurniture)selectable2);
                        }
                        this.elevationActivated = !bl2 && bl3;
                        boolean bl5 = this.rotationActivated = bl2 && bl3;
                        if ((this.elevationActivated || this.rotationActivated) && selectable instanceof HomePieceOfFurniture && list.size() > 1) {
                            this.elevationActivated = false;
                            this.rotationActivated = false;
                        }
                        if (this.movedItems != null) {
                            this.closestMovedPiece = (HomePieceOfFurniture)selectable;
                            float f3 = this.closestMovedPiece.getGroundElevation() + this.closestMovedPiece.getHeightInPlan() / 2.0f * (float)Math.cos(HomeController3D.this.home.getCamera().getPitch());
                            this.lastMousePressedPoint3D = ((View3D)HomeController3D.this.getView()).convertPixelLocationToVirtualWorld(Math.round(f), Math.round(f2));
                            float f4 = (float)Math.sqrt((HomeController3D.this.home.getCamera().getX() - this.closestMovedPiece.getX()) * (HomeController3D.this.home.getCamera().getX() - this.closestMovedPiece.getX()) + (HomeController3D.this.home.getCamera().getY() - this.closestMovedPiece.getY()) * (HomeController3D.this.home.getCamera().getY() - this.closestMovedPiece.getY()) + (HomeController3D.this.home.getCamera().getZ() - f3) * (HomeController3D.this.home.getCamera().getZ() - f3));
                            float f5 = (float)Math.sqrt((HomeController3D.this.home.getCamera().getX() - this.lastMousePressedPoint3D[0]) * (HomeController3D.this.home.getCamera().getX() - this.lastMousePressedPoint3D[0]) + (HomeController3D.this.home.getCamera().getY() - this.lastMousePressedPoint3D[1]) * (HomeController3D.this.home.getCamera().getY() - this.lastMousePressedPoint3D[1]) + (HomeController3D.this.home.getCamera().getZ() - this.lastMousePressedPoint3D[2]) * (HomeController3D.this.home.getCamera().getZ() - this.lastMousePressedPoint3D[2]));
                            this.distancesRatio = f4 / f5;
                        }
                        this.movedItemsDeltaX = null;
                        this.movedItemsDeltaY = null;
                    }
                } else if (n == 2 && !HomeController3D.this.home.getSelectedItems().isEmpty()) {
                    HomeController3D.this.planController.modifySelectedItem();
                }
                this.mouseMoved = false;
                this.cameraMoved = false;
                this.yLastMousePress = f2;
                this.alignmentActivated = bl2;
                this.duplicationActivated = bl3;
                this.magnetismToggled = bl4;
                this.pointerType = pointerType;
            }
        }

        @Override
        public void releaseMouse(float f, float f2) {
            if (HomeController3D.this.planController != null && HomeController3D.this.preferences.isEditingIn3DViewEnabled() && HomeController3D.this.getView() instanceof View3D) {
                if (this.movedItems != null && this.movedItemsDeltaY != null) {
                    HomeController3D.this.planController.releaseMouse(this.movedItemsStartPoint[0] + this.movedItemsDeltaX.floatValue(), this.movedItemsStartPoint[1] + this.movedItemsDeltaY.floatValue());
                    HomeController3D.this.planController.setFeedbackDisplayed(true);
                } else if (!(HomeController3D.this.planController.isModificationState() || this.mouseMoved || this.cameraMoved)) {
                    Selectable selectable = ((View3D)HomeController3D.this.getView()).getClosestSelectableItemAt(Math.round(f), Math.round(f2));
                    if (selectable != null && HomeController3D.this.home.isBasePlanLocked() && HomeController3D.this.planController.isItemPartOfBasePlan(selectable)) {
                        selectable = null;
                    }
                    if (this.alignmentActivated) {
                        if (selectable != null) {
                            ArrayList<Selectable> arrayList = new ArrayList<Selectable>(HomeController3D.this.home.getSelectedItems());
                            if (arrayList.contains(selectable)) {
                                HomeController3D.this.home.deselectItem(selectable);
                            } else {
                                arrayList.add(selectable);
                                HomeController3D.this.home.setSelectedItems(arrayList);
                            }
                        }
                    } else if (selectable != null) {
                        HomeController3D.this.home.setSelectedItems(Arrays.asList(selectable));
                    } else {
                        List list = Collections.emptyList();
                        HomeController3D.this.home.setSelectedItems(list);
                    }
                }
                this.movedItems = null;
                this.closestMovedPiece = null;
                this.elevationActivated = false;
                this.rotationActivated = false;
            }
        }

        @Override
        public void moveMouse(float f, float f2) {
            if (HomeController3D.this.planController != null && HomeController3D.this.preferences.isEditingIn3DViewEnabled() && this.movedItems != null) {
                if (this.movedItemsDeltaY == null) {
                    float[] fArray;
                    if (this.rotationActivated) {
                        fArray = this.movedItems.get(0).getPoints()[0];
                    } else {
                        float[] fArray2 = new float[2];
                        fArray2[0] = this.closestMovedPiece.getX();
                        fArray = fArray2;
                        fArray2[1] = this.closestMovedPiece.getY();
                    }
                    this.movedItemsStartPoint = fArray;
                    this.angleMousePress = null;
                    HomeController3D.this.planController.setFeedbackDisplayed(false);
                    HomeController3D.this.planController.moveMouse(this.movedItemsStartPoint[0], this.movedItemsStartPoint[1]);
                    HomeController3D.this.planController.pressMouse(this.movedItemsStartPoint[0], this.movedItemsStartPoint[1], 1, false, false, this.duplicationActivated, this.magnetismToggled);
                    if (this.elevationActivated) {
                        HomeController3D.this.planController.setState(HomeController3D.this.planController.getPieceOfFurnitureElevationState());
                    } else if (this.rotationActivated) {
                        HomeController3D.this.planController.setState(HomeController3D.this.planController.getPieceOfFurnitureRotationState());
                    } else {
                        HomeController3D.this.home.setSelectedItems(this.movedItems);
                        HomeController3D.this.planController.setState(HomeController3D.this.planController.getSelectionMoveState());
                        HomeController3D.this.planController.setAlignmentActivated(this.alignmentActivated);
                    }
                }
                if (this.rotationActivated && this.angleMousePress == null) {
                    this.angleMousePress = Float.valueOf((float)Math.atan2(this.movedItemsStartPoint[1] - this.movedItems.get(0).getY(), this.movedItemsStartPoint[0] - this.movedItems.get(0).getX()));
                    if (this.pointerType == View.PointerType.TOUCH) {
                        this.lastMousePressedPoint3D = ((View3D)HomeController3D.this.getView()).convertPixelLocationToVirtualWorld(Math.round(f), Math.round(f2));
                    }
                }
                float[] fArray = ((View3D)HomeController3D.this.getView()).convertPixelLocationToVirtualWorld(Math.round(f), Math.round(f2));
                if (this.rotationActivated) {
                    float f3 = this.angleMousePress.floatValue() - (fArray[0] - this.lastMousePressedPoint3D[0]) * this.distancesRatio / 50.0f;
                    float f4 = (float)Point2D.distance(this.movedItems.get(0).getX(), this.movedItems.get(0).getY(), this.movedItemsStartPoint[0], this.movedItemsStartPoint[1]);
                    this.movedItemsDeltaX = Float.valueOf(this.movedItems.get(0).getX() + f4 * (float)Math.cos(f3) - this.movedItemsStartPoint[0]);
                    this.movedItemsDeltaY = Float.valueOf(this.movedItems.get(0).getY() + f4 * (float)Math.sin(f3) - this.movedItemsStartPoint[1]);
                } else if (this.elevationActivated) {
                    this.movedItemsDeltaX = Float.valueOf(0.0f);
                    this.movedItemsDeltaY = Float.valueOf((this.lastMousePressedPoint3D[2] - fArray[2]) * this.distancesRatio + (f2 - this.yLastMousePress) * (float)(1.0 - Math.cos(HomeController3D.this.home.getCamera().getPitch())));
                } else {
                    this.movedItemsDeltaX = Float.valueOf((fArray[0] - this.lastMousePressedPoint3D[0]) * this.distancesRatio);
                    this.movedItemsDeltaY = Float.valueOf((fArray[1] - this.lastMousePressedPoint3D[1]) * this.distancesRatio);
                }
                HomeController3D.this.planController.moveMouse(this.movedItemsStartPoint[0] + this.movedItemsDeltaX.floatValue(), this.movedItemsStartPoint[1] + this.movedItemsDeltaY.floatValue());
            }
            this.mouseMoved = true;
        }

        @Override
        public void escape() {
            if (HomeController3D.this.planController != null && HomeController3D.this.preferences.isEditingIn3DViewEnabled()) {
                this.movedItems = null;
                HomeController3D.this.planController.escape();
            }
        }

        @Override
        public void toggleMagnetism(boolean bl) {
            if (HomeController3D.this.planController != null && HomeController3D.this.preferences.isEditingIn3DViewEnabled()) {
                this.magnetismToggled = bl;
                HomeController3D.this.planController.toggleMagnetism(bl);
            }
        }

        @Override
        public void setAlignmentActivated(boolean bl) {
            if (HomeController3D.this.planController != null && HomeController3D.this.preferences.isEditingIn3DViewEnabled()) {
                if (this.pointerType == View.PointerType.TOUCH && bl && HomeController3D.this.home.getSelectedItems().size() == 1 && !this.mouseMoved) {
                    this.elevationActivated = true;
                    this.rotationActivated = false;
                }
                this.alignmentActivated = bl;
                HomeController3D.this.planController.setAlignmentActivated(bl);
            }
        }

        @Override
        public void setDuplicationActivated(boolean bl) {
            if (HomeController3D.this.planController != null && HomeController3D.this.preferences.isEditingIn3DViewEnabled()) {
                if (this.pointerType == View.PointerType.TOUCH && bl && HomeController3D.this.home.getSelectedItems().size() == 1) {
                    if (this.elevationActivated && !this.mouseMoved) {
                        this.elevationActivated = false;
                        this.rotationActivated = true;
                    } else {
                        this.movedItemsStartPoint[0] = this.movedItemsStartPoint[0] + this.movedItemsDeltaX.floatValue();
                        this.movedItemsStartPoint[1] = this.movedItemsStartPoint[1] + this.movedItemsDeltaY.floatValue();
                        this.angleMousePress = null;
                    }
                }
                this.duplicationActivated = bl;
                if (!this.elevationActivated) {
                    HomeController3D.this.planController.setDuplicationActivated(bl);
                }
            }
        }
    }

    protected static abstract class CameraControllerState {
        protected CameraControllerState() {
        }

        public void enter() {
        }

        public void exit() {
        }

        public void moveCamera(float f) {
        }

        public void moveCameraSideways(float f) {
        }

        public void elevateCamera(float f) {
        }

        public void rotateCameraYaw(float f) {
        }

        public void rotateCameraPitch(float f) {
        }

        public void modifyFieldOfView(float f) {
        }

        public void goToCamera(Camera camera) {
        }

        public boolean isEditingState() {
            return false;
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, View.PointerType pointerType) {
        }

        public void releaseMouse(float f, float f2) {
        }

        public void moveMouse(float f, float f2) {
        }

        public void escape() {
        }

        public void toggleMagnetism(boolean bl) {
        }

        public void setAlignmentActivated(boolean bl) {
        }

        public void setDuplicationActivated(boolean bl) {
        }

        public void setEditionActivated(boolean bl) {
        }
    }
}

