/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.catalina.filters.CsrfPreventionFilterBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CsrfPreventionFilter
extends CsrfPreventionFilterBase {
    private final Log log = LogFactory.getLog(CsrfPreventionFilter.class);
    private final Set<String> entryPoints = new HashSet<String>();
    private int nonceCacheSize = 5;
    private String nonceRequestParameterName = "org.apache.catalina.filters.CSRF_NONCE";

    public void setEntryPoints(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",")) {
            this.entryPoints.add(string2.trim());
        }
    }

    public void setNonceCacheSize(int n) {
        this.nonceCacheSize = n;
    }

    public void setNonceRequestParameterName(String string) {
        this.nonceRequestParameterName = string;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        filterConfig.getServletContext().setAttribute("org.apache.catalina.filters.CSRF_NONCE_PARAM_NAME", (Object)this.nonceRequestParameterName);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        CsrfResponseWrapper csrfResponseWrapper = null;
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            String string;
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            HttpSession httpSession = httpServletRequest.getSession(false);
            boolean bl = this.skipNonceCheck(httpServletRequest);
            NonceCache<String> nonceCache = null;
            if (!bl) {
                string = httpServletRequest.getParameter(this.nonceRequestParameterName);
                if (string == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Rejecting request for " + this.getRequestedPath(httpServletRequest) + ", session " + (null == httpSession ? "(none)" : httpSession.getId()) + " with no CSRF nonce found in request"));
                    }
                    httpServletResponse.sendError(this.getDenyStatus());
                    return;
                }
                nonceCache = this.getNonceCache(httpServletRequest, httpSession);
                if (nonceCache == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Rejecting request for " + this.getRequestedPath(httpServletRequest) + ", session " + (null == httpSession ? "(none)" : httpSession.getId()) + " due to empty / missing nonce cache"));
                    }
                    httpServletResponse.sendError(this.getDenyStatus());
                    return;
                }
                if (!nonceCache.contains(string)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Rejecting request for " + this.getRequestedPath(httpServletRequest) + ", session " + (null == httpSession ? "(none)" : httpSession.getId()) + " due to invalid nonce " + string));
                    }
                    httpServletResponse.sendError(this.getDenyStatus());
                    return;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Allowing request to " + this.getRequestedPath(httpServletRequest) + " with valid CSRF nonce " + string));
                }
            }
            if (!this.skipNonceGeneration(httpServletRequest)) {
                if (bl) {
                    nonceCache = this.getNonceCache(httpServletRequest, httpSession);
                }
                if (nonceCache == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Creating new CSRF nonce cache with size=" + this.nonceCacheSize + " for session " + (null == httpSession ? "(will create)" : httpSession.getId())));
                    }
                    if (httpSession == null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Creating new session to store CSRF nonce cache");
                        }
                        httpSession = httpServletRequest.getSession(true);
                    }
                    nonceCache = this.createNonceCache(httpServletRequest, httpSession);
                }
                string = this.generateNonce(httpServletRequest);
                nonceCache.add(string);
                servletRequest.setAttribute("org.apache.catalina.filters.CSRF_REQUEST_NONCE", (Object)string);
                csrfResponseWrapper = new CsrfResponseWrapper(httpServletResponse, this.nonceRequestParameterName, string);
            }
        }
        filterChain.doFilter(servletRequest, (ServletResponse)(csrfResponseWrapper == null ? servletResponse : csrfResponseWrapper));
    }

    protected boolean skipNonceCheck(HttpServletRequest httpServletRequest) {
        if (!"GET".equals(httpServletRequest.getMethod())) {
            return false;
        }
        String string = this.getRequestedPath(httpServletRequest);
        if (!this.entryPoints.contains(string)) {
            return false;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Skipping CSRF nonce-check for GET request to entry point " + string));
        }
        return true;
    }

    protected boolean skipNonceGeneration(HttpServletRequest httpServletRequest) {
        return false;
    }

    protected NonceCache<String> createNonceCache(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        LruCache<String> lruCache = new LruCache<String>(this.nonceCacheSize);
        httpSession.setAttribute("org.apache.catalina.filters.CSRF_NONCE", lruCache);
        return lruCache;
    }

    protected NonceCache<String> getNonceCache(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        if (httpSession == null) {
            return null;
        }
        NonceCache nonceCache = (NonceCache)httpSession.getAttribute("org.apache.catalina.filters.CSRF_NONCE");
        return nonceCache;
    }

    protected static interface NonceCache<T>
    extends Serializable {
        public void add(T var1);

        public boolean contains(T var1);
    }

    protected static class CsrfResponseWrapper
    extends HttpServletResponseWrapper {
        private final String nonceRequestParameterName;
        private final String nonce;

        public CsrfResponseWrapper(HttpServletResponse httpServletResponse, String string, String string2) {
            super(httpServletResponse);
            this.nonceRequestParameterName = string;
            this.nonce = string2;
        }

        @Deprecated
        public String encodeRedirectUrl(String string) {
            return this.encodeRedirectURL(string);
        }

        public String encodeRedirectURL(String string) {
            return this.addNonce(super.encodeRedirectURL(string));
        }

        @Deprecated
        public String encodeUrl(String string) {
            return this.encodeURL(string);
        }

        public String encodeURL(String string) {
            return this.addNonce(super.encodeURL(string));
        }

        private String addNonce(String string) {
            int n;
            if (string == null || this.nonce == null) {
                return string;
            }
            String string2 = string;
            String string3 = "";
            String string4 = "";
            int n2 = string2.indexOf(35);
            if (n2 >= 0) {
                string4 = string2.substring(n2);
                string2 = string2.substring(0, n2);
            }
            if ((n = string2.indexOf(63)) >= 0) {
                string3 = string2.substring(n);
                string2 = string2.substring(0, n);
            }
            StringBuilder stringBuilder = new StringBuilder(string2);
            if (string3.length() > 0) {
                stringBuilder.append(string3);
                stringBuilder.append('&');
            } else {
                stringBuilder.append('?');
            }
            stringBuilder.append(this.nonceRequestParameterName);
            stringBuilder.append('=');
            stringBuilder.append(this.nonce);
            stringBuilder.append(string4);
            return stringBuilder.toString();
        }
    }

    protected static class LruCache<T>
    implements NonceCache<T> {
        private static final long serialVersionUID = 1L;
        private final Map<T, T> cache;

        public LruCache(final int n) {
            this.cache = new LinkedHashMap<T, T>(){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<T, T> entry) {
                    return this.size() > n;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(T t) {
            Map<T, T> map = this.cache;
            synchronized (map) {
                this.cache.put(t, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(T t) {
            Map<T, T> map = this.cache;
            synchronized (map) {
                return this.cache.containsKey(t);
            }
        }
    }
}

