/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sysopen;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class SystemOpenAction
extends AbstractAction
implements ContextAwareAction {
    private static final RequestProcessor PROC = new RequestProcessor(SystemOpenAction.class);

    public SystemOpenAction() {
        super(NbBundle.getMessage(SystemOpenAction.class, (String)"CTL_SystemOpenAction"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        new ContextAction(Utilities.actionsGlobalContext()).actionPerformed(actionEvent);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAction(lookup);
    }

    private static final class ContextAction
    extends AbstractAction {
        private final Set<File> files;

        public ContextAction(Lookup lookup) {
            super(NbBundle.getMessage(SystemOpenAction.class, (String)"CTL_SystemOpenAction"));
            this.putValue("hideWhenDisabled", true);
            this.files = new HashSet<File>();
            for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
                File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
                if (file == null || Utilities.isWindows() && file.isFile() && !file.getName().contains(".")) {
                    this.files.clear();
                    break;
                }
                this.files.add(file);
            }
        }

        @Override
        public boolean isEnabled() {
            return !this.files.isEmpty() && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PROC.post(new Runnable(){

                @Override
                public void run() {
                    Desktop desktop = Desktop.getDesktop();
                    for (File file : files) {
                        try {
                            desktop.open(file);
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(SystemOpenAction.class.getName()).log(Level.INFO, null, iOException);
                        }
                    }
                }
            });
        }
    }
}

