import { Zcl } from "zigbee-herdsman";
import type { Ota, Zh } from "./types";
export interface QueryNextImageRequestPayload {
    fieldControl: number;
    manufacturerCode: Zcl.ManufacturerCode;
    imageType: number;
    fileVersion: number;
    hardwareVersion?: number;
}
export interface ImageBlockRequestPayload {
    fieldControl: number;
    manufacturerCode: Zcl.ManufacturerCode;
    imageType: number;
    fileVersion: number;
    fileOffset: number;
    maximumDataSize: number;
}
export interface ImagePageRequestPayload extends ImageBlockRequestPayload {
    pageSize: number;
    responseSpacing: number;
}
export interface UpdateEndRequestPayload {
    status: Zcl.Status;
    manufacturerCode: Zcl.ManufacturerCode;
    imageType: number;
    fileVersion: number;
}
export type ImageNotifyPayload = {
    payloadType: number;
    queryJitter: number;
};
export type QueryNextImageResponsePayload = {
    status: Zcl.Status;
} | {
    status: Zcl.Status.SUCCESS;
    manufacturerCode: Zcl.ManufacturerCode;
    imageType: number;
    fileVersion: number;
    imageSize: number;
};
export type ImageBlockResponsePayload = {
    status: Zcl.Status;
    manufacturerCode: Zcl.ManufacturerCode;
    imageType: number;
    fileVersion: number;
    fileOffset: number;
    dataSize: number;
    data: Buffer;
};
export type UpgradeEndResponsePayload = {
    manufacturerCode: Zcl.ManufacturerCode;
    imageType: number;
    fileVersion: number;
    currentTime: number;
    upgradeTime: number;
};
export declare const ZIGBEE_OTA_LATEST_URL = "https://raw.githubusercontent.com/Koenkk/zigbee-OTA/master/index.json";
export declare const ZIGBEE_OTA_PREVIOUS_URL = "https://raw.githubusercontent.com/Koenkk/zigbee-OTA/master/index1.json";
/** When the data size is too big, OTA gets unstable, so default it to 50 bytes maximum. */
export declare const DEFAULT_MAXIMUM_DATA_SIZE = 50;
/** Use to reduce network congestion by throttling response if necessary */
export declare const DEFAULT_IMAGE_BLOCK_RESPONSE_DELAY = 250;
export declare const UPGRADE_FILE_IDENTIFIER: Buffer<ArrayBuffer>;
export declare function setConfiguration(settings: Ota.Settings): void;
export declare function isValidUrl(url: string): boolean;
export declare function parseImage(buffer: Buffer, suppressElementImageParseFailure?: boolean): Ota.Image;
export declare function isUpdateAvailable(device: Zh.Device, extraMetas: Ota.ExtraMetas, requestPayload: Ota.ImageInfo | undefined, previous: boolean): Promise<Ota.UpdateAvailableResult>;
/**
 * @see https://zigbeealliance.org/wp-content/uploads/2021/10/07-5123-08-Zigbee-Cluster-Library.pdf 11.12
 */
export declare function update(device: Zh.Device, extraMetas: Ota.ExtraMetas, previous: boolean, onProgress: Ota.OnProgress, requestPayload: Ota.ImageInfo, reqTransNum: number): Promise<number | undefined>;
export declare function update(device: Zh.Device, extraMetas: Ota.ExtraMetas, previous: boolean, onProgress: Ota.OnProgress): Promise<number | undefined>;
//# sourceMappingURL=ota.d.ts.map