/*
 * Decompiled with CFR 0.152.
 */
package org.cts.registry;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.cts.registry.AbstractProjRegistry;
import org.cts.registry.RegistryException;

public class Nad27Registry
extends AbstractProjRegistry {
    static final Pattern NAD27_REGEX = Pattern.compile("\\s+");

    @Override
    public String getRegistryName() {
        return "nad27";
    }

    @Override
    public Map<String, String> getParameters(String code) throws RegistryException {
        try {
            return this.projParser.readParameters(code, NAD27_REGEX);
        }
        catch (IOException ex) {
            throw new RegistryException("Cannot load the NAD27 registry", ex);
        }
    }

    @Override
    public Set<String> getSupportedCodes() throws RegistryException {
        try {
            return this.projParser.getSupportedCodes(NAD27_REGEX);
        }
        catch (IOException ex) {
            throw new RegistryException("Cannot load the NAD27 registry", ex);
        }
    }
}

