/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.enumeration;

import java.awt.event.ActionEvent;
import java.util.List;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;

public class NodeEnumerationAction<T extends Enum<T>>
extends AMultipleNodeAction {
    private static final long serialVersionUID = 1L;
    private final T value;

    public NodeEnumerationAction(T value) {
        super("NodeEnumerationAction." + value.getClass().getSimpleName() + '.' + ((Enum)value).name());
        this.value = value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setSelected();
        super.actionPerformed(e);
    }

    @Override
    protected void actionPerformed(ActionEvent e, NodeModel node) {
        MMapController controller = (MMapController)Controller.getCurrentModeController().getMapController();
        if (this.isSelected()) {
            controller.removeProperty(node, this.getValueClass());
        } else {
            controller.setProperty(node, this.value);
        }
    }

    @Override
    public void setSelected() {
        List<NodeModel> nodes = this.getNodes();
        boolean selected = !nodes.isEmpty() && nodes.get(0).getExtension(this.getValueClass()) == this.value;
        this.setSelected(selected);
    }

    protected Class<T> getValueClass() {
        return this.value.getClass();
    }

    protected T getValue() {
        return this.value;
    }
}

