/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Slot
implements Serializable {
    private static final long serialVersionUID = -6090581677123995491L;
    Object name;
    int indexOrHash;
    private short attributes;
    Object value;
    transient Slot next;
    transient Slot orderedNext;

    Slot(Object object, int n, int n2) {
        this.name = object;
        this.indexOrHash = n;
        this.attributes = (short)n2;
    }

    boolean isValueSlot() {
        return true;
    }

    boolean isSetterSlot() {
        return false;
    }

    protected Slot(Slot slot) {
        this.name = slot.name;
        this.indexOrHash = slot.indexOrHash;
        this.attributes = slot.attributes;
        this.value = slot.value;
        this.next = slot.next;
        this.orderedNext = slot.orderedNext;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.name != null) {
            this.indexOrHash = this.name.hashCode();
        }
    }

    public final boolean setValue(Object object, Scriptable scriptable, Scriptable scriptable2) {
        return this.setValue(object, scriptable, scriptable2, Context.isCurrentContextStrict());
    }

    public boolean setValue(Object object, Scriptable scriptable, Scriptable scriptable2, boolean bl) {
        if ((this.attributes & 1) != 0) {
            if (bl) {
                throw ScriptRuntime.typeErrorById("msg.modify.readonly", this.name);
            }
            return true;
        }
        if (scriptable == scriptable2) {
            this.value = object;
            return true;
        }
        return false;
    }

    public Object getValue(Scriptable scriptable) {
        return this.value;
    }

    int getAttributes() {
        return this.attributes;
    }

    synchronized void setAttributes(int n) {
        ScriptableObject.checkValidAttributes(n);
        this.attributes = (short)n;
    }

    ScriptableObject getPropertyDescriptor(Context context, Scriptable scriptable) {
        return ScriptableObject.buildDataDescriptor(scriptable, this.value, this.attributes);
    }

    protected void throwNoSetterException(Scriptable scriptable, Object object) {
        Context context = Context.getContext();
        if (context.isStrictMode() || context.hasFeature(11)) {
            String string = "";
            if (this.name != null) {
                string = "[" + scriptable.getClassName() + "]." + this.name;
            }
            throw ScriptRuntime.typeErrorById("msg.set.prop.no.setter", string, Context.toString(object));
        }
    }

    Function getSetterFunction(String string, Scriptable scriptable) {
        return null;
    }

    Function getGetterFunction(String string, Scriptable scriptable) {
        return null;
    }
}

