/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Blurs an image while preserving edges.


This filter uses bilateral filtering to blur an image using both
domain and range "neighborhoods". Pixels that are close to a pixel
in the image domain and similar to a pixel in the image range are used
to calculate the filtered value. Two gaussian kernels (one in the
image domain and one in the image range) are used to smooth the image.
The result is an image that is smoothed in homogeneous regions yet has
edges preserved. The result is similar to anisotropic diffusion but
the implementation in non-iterative. Another benefit to bilateral
filtering is that any distance metric can be used for kernel smoothing
the image range. Hence, color images can be smoothed as vector images,
using the CIE distances between intensity values as the similarity
metric (the Gaussian kernel for the image domain is evaluated using
CIE distances). A separate version of this filter will be designed for
color and vector images.

Bilateral filtering is capable of reducing the noise in an image by an
order of magnitude while maintaining edges.

The bilateral operator used here was described by Tomasi and Manduchi
(Bilateral Filtering for Gray and ColorImages. IEEE ICCV. 1998.)


See:
 GaussianOperator

 RecursiveGaussianImageFilter

 DiscreteGaussianImageFilter

 AnisotropicDiffusionImageFilter

 Image

 Neighborhood

 NeighborhoodOperator
 TodoSupport color images

Support vector images
See:
 itk::simple::Bilateral for the procedural interface

 itk::BilateralImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBilateralImageFilter.h
*/
public class BilateralImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BilateralImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BilateralImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BilateralImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BilateralImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BilateralImageFilter::~BilateralImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BilateralImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BilateralImageFilter::BilateralImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BilateralImageFilter() {
    this(SimpleITKJNI.new_BilateralImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BilateralImageFilter::SetDomainSigma(double DomainSigma)

Convenience get/set methods for setting all domain parameters to the
same values.

*/
public  void setDomainSigma(double DomainSigma) {
    SimpleITKJNI.BilateralImageFilter_setDomainSigma(swigCPtr, this, DomainSigma);
  }

  /**
double itk::simple::BilateralImageFilter::GetDomainSigma() const

Standard get/set macros for filter parameters. DomainSigma is
specified in the same units as the Image spacing. RangeSigma is specified in the units of intensity.

*/
public  double getDomainSigma() {
    return SimpleITKJNI.BilateralImageFilter_getDomainSigma(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BilateralImageFilter::SetRangeSigma(double RangeSigma)

Standard get/set macros for filter parameters. DomainSigma is
specified in the same units as the Image spacing. RangeSigma is specified in the units of intensity.

*/
public  void setRangeSigma(double RangeSigma) {
    SimpleITKJNI.BilateralImageFilter_setRangeSigma(swigCPtr, this, RangeSigma);
  }

  /**
double itk::simple::BilateralImageFilter::GetRangeSigma() const

Standard get/set macros for filter parameters. DomainSigma is
specified in the same units as the Image spacing. RangeSigma is specified in the units of intensity.

*/
public  double getRangeSigma() {
    return SimpleITKJNI.BilateralImageFilter_getRangeSigma(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BilateralImageFilter::SetNumberOfRangeGaussianSamples(unsigned int NumberOfRangeGaussianSamples)

Set/Get the number of samples in the approximation to the Gaussian
used for the range smoothing. Samples are only generated in the range
of [0, 4*m_RangeSigma]. Default is 100.

*/
public  void setNumberOfRangeGaussianSamples(long NumberOfRangeGaussianSamples) {
    SimpleITKJNI.BilateralImageFilter_setNumberOfRangeGaussianSamples(swigCPtr, this, NumberOfRangeGaussianSamples);
  }

  /**
unsigned int itk::simple::BilateralImageFilter::GetNumberOfRangeGaussianSamples() const

Set/Get the number of samples in the approximation to the Gaussian
used for the range smoothing. Samples are only generated in the range
of [0, 4*m_RangeSigma]. Default is 100.

*/
public  long getNumberOfRangeGaussianSamples() {
    return SimpleITKJNI.BilateralImageFilter_getNumberOfRangeGaussianSamples(swigCPtr, this);
  }

  /**
std::string itk::simple::BilateralImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BilateralImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BilateralImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BilateralImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BilateralImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BilateralImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
