/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter performs anisotropic diffusion on a scalar itk::Image using the modified curvature diffusion equation (MCDE).


For detailed information on anisotropic diffusion and the MCDE see
itkAnisotropicDiffusionFunction and
itkCurvatureNDAnisotropicDiffusionFunction.

Inputs and Outputs
The input and output to this filter must be a scalar itk::Image with numerical pixel types (float or double). A user defined type
which correctly defines arithmetic operations with floating point
accuracy should also give correct results.
Parameters
Please first read all the documentation found in AnisotropicDiffusionImageFilter and AnisotropicDiffusionFunction . Also see CurvatureNDAnisotropicDiffusionFunction .
 The default time step for this filter is set to the maximum
theoretically stable value: 0.5 / 2^N, where N is the dimensionality
of the image. For a 2D image, this means valid time steps are below
0.1250. For a 3D image, valid time steps are below 0.0625.


See:
 AnisotropicDiffusionImageFilter

 AnisotropicDiffusionFunction

 CurvatureNDAnisotropicDiffusionFunction

 itk::simple::CurvatureAnisotropicDiffusion for the procedural interface

 itk::CurvatureAnisotropicDiffusionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCurvatureAnisotropicDiffusionImageFilter.h
*/
public class CurvatureAnisotropicDiffusionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected CurvatureAnisotropicDiffusionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.CurvatureAnisotropicDiffusionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(CurvatureAnisotropicDiffusionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(CurvatureAnisotropicDiffusionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::CurvatureAnisotropicDiffusionImageFilter::~CurvatureAnisotropicDiffusionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_CurvatureAnisotropicDiffusionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::CurvatureAnisotropicDiffusionImageFilter::CurvatureAnisotropicDiffusionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  CurvatureAnisotropicDiffusionImageFilter() {
    this(SimpleITKJNI.new_CurvatureAnisotropicDiffusionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::CurvatureAnisotropicDiffusionImageFilter::SetTimeStep(double TimeStep)
*/
public  void setTimeStep(double TimeStep) {
    SimpleITKJNI.CurvatureAnisotropicDiffusionImageFilter_setTimeStep(swigCPtr, this, TimeStep);
  }

  /**
double itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetTimeStep() const
*/
public  double getTimeStep() {
    return SimpleITKJNI.CurvatureAnisotropicDiffusionImageFilter_getTimeStep(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CurvatureAnisotropicDiffusionImageFilter::SetConductanceParameter(double ConductanceParameter)
*/
public  void setConductanceParameter(double ConductanceParameter) {
    SimpleITKJNI.CurvatureAnisotropicDiffusionImageFilter_setConductanceParameter(swigCPtr, this, ConductanceParameter);
  }

  /**
double itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetConductanceParameter() const
*/
public  double getConductanceParameter() {
    return SimpleITKJNI.CurvatureAnisotropicDiffusionImageFilter_getConductanceParameter(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CurvatureAnisotropicDiffusionImageFilter::SetConductanceScalingUpdateInterval(unsigned int ConductanceScalingUpdateInterval)
*/
public  void setConductanceScalingUpdateInterval(long ConductanceScalingUpdateInterval) {
    SimpleITKJNI.CurvatureAnisotropicDiffusionImageFilter_setConductanceScalingUpdateInterval(swigCPtr, this, ConductanceScalingUpdateInterval);
  }

  /**
unsigned int itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetConductanceScalingUpdateInterval() const
*/
public  long getConductanceScalingUpdateInterval() {
    return SimpleITKJNI.CurvatureAnisotropicDiffusionImageFilter_getConductanceScalingUpdateInterval(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CurvatureAnisotropicDiffusionImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.CurvatureAnisotropicDiffusionImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.CurvatureAnisotropicDiffusionImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
std::string itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.CurvatureAnisotropicDiffusionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::CurvatureAnisotropicDiffusionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.CurvatureAnisotropicDiffusionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::CurvatureAnisotropicDiffusionImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.CurvatureAnisotropicDiffusionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
double itk::simple::CurvatureAnisotropicDiffusionImageFilter::EstimateOptimalTimeStep(Image &amp;inImage)

This method autmatically sets the optimal timestep for an image given
its spacing.

*/
public  double estimateOptimalTimeStep(Image inImage) {
    return SimpleITKJNI.CurvatureAnisotropicDiffusionImageFilter_estimateOptimalTimeStep(swigCPtr, this, Image.getCPtr(inImage), inImage);
  }

}
