/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Base class for specialized complex-to-real inverse Fast Fourier Transform .


This is a base class for the "inverse" or "reverse" Discrete
Fourier Transform . This is an abstract base class: the actual implementation is
provided by the best child class available on the system when the
object is created via the object factory system.

The input to this filter is assumed to have the same format as the
output of the RealToHalfHermitianForwardFFTImageFilter . That is, the input is assumed to consist of roughly half the full
complex image resulting from a real-to-complex discrete Fourier
transform. This half is expected to be the first half of the image in
the X-dimension. Because this filter assumes that the input stores
only about half of the non-redundant complex pixels, the output is
larger in the X-dimension than it is in the input. To determine the
actual size of the output image, this filter needs additional
information in the form of a flag indicating whether the output image
has an odd size in the X-dimension. Use SetActualXDimensionIsOdd() to set this flag.


See:
 ForwardFFTImageFilter , HalfHermitianToRealInverseFFTImageFilter

 itk::simple::HalfHermitianToRealInverseFFT for the procedural interface

 itk::HalfHermitianToRealInverseFFTImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHalfHermitianToRealInverseFFTImageFilter.h
*/
public class HalfHermitianToRealInverseFFTImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected HalfHermitianToRealInverseFFTImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.HalfHermitianToRealInverseFFTImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(HalfHermitianToRealInverseFFTImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(HalfHermitianToRealInverseFFTImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::HalfHermitianToRealInverseFFTImageFilter::~HalfHermitianToRealInverseFFTImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_HalfHermitianToRealInverseFFTImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::HalfHermitianToRealInverseFFTImageFilter::HalfHermitianToRealInverseFFTImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  HalfHermitianToRealInverseFFTImageFilter() {
    this(SimpleITKJNI.new_HalfHermitianToRealInverseFFTImageFilter(), true);
  }

  /**
Self&amp; itk::simple::HalfHermitianToRealInverseFFTImageFilter::SetActualXDimensionIsOdd(bool ActualXDimensionIsOdd)

Was the original truncated dimension size odd?

*/
public  void setActualXDimensionIsOdd(boolean ActualXDimensionIsOdd) {
    SimpleITKJNI.HalfHermitianToRealInverseFFTImageFilter_setActualXDimensionIsOdd(swigCPtr, this, ActualXDimensionIsOdd);
  }

  /**
Self&amp; itk::simple::HalfHermitianToRealInverseFFTImageFilter::ActualXDimensionIsOddOn()

Set the value of ActualXDimensionIsOdd to true or false respectfully.

*/
public  void actualXDimensionIsOddOn() {
    SimpleITKJNI.HalfHermitianToRealInverseFFTImageFilter_actualXDimensionIsOddOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::HalfHermitianToRealInverseFFTImageFilter::ActualXDimensionIsOddOff()
*/
public  void actualXDimensionIsOddOff() {
    SimpleITKJNI.HalfHermitianToRealInverseFFTImageFilter_actualXDimensionIsOddOff(swigCPtr, this);
  }

  /**
bool itk::simple::HalfHermitianToRealInverseFFTImageFilter::GetActualXDimensionIsOdd() const

Was the original truncated dimension size odd?

*/
public  boolean getActualXDimensionIsOdd() {
    return SimpleITKJNI.HalfHermitianToRealInverseFFTImageFilter_getActualXDimensionIsOdd(swigCPtr, this);
  }

  /**
std::string itk::simple::HalfHermitianToRealInverseFFTImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.HalfHermitianToRealInverseFFTImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::HalfHermitianToRealInverseFFTImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.HalfHermitianToRealInverseFFTImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::HalfHermitianToRealInverseFFTImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.HalfHermitianToRealInverseFFTImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
