/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class UTMProjectionChoice
extends ListProjectionChoice {
    private static final TransverseMercator.Hemisphere DEFAULT_HEMISPHERE = TransverseMercator.Hemisphere.North;
    private TransverseMercator.Hemisphere hemisphere;
    private static final List<String> cbEntries = new ArrayList<String>();

    public UTMProjectionChoice() {
        super(I18n.tr("UTM", new Object[0]), "core:utm", cbEntries.toArray(new String[0]), I18n.tr("UTM Zone", new Object[0]));
    }

    @Override
    public JPanel getPreferencePanel(ActionListener listener) {
        return new UTMPanel(this.entries, this.index, this.label, listener);
    }

    @Override
    public String getCurrentCode() {
        int zone = this.index + 1;
        int code = 32600 + zone + (this.hemisphere == TransverseMercator.Hemisphere.South ? 100 : 0);
        return "EPSG:" + Integer.toString(code);
    }

    @Override
    public String getProjectionName() {
        return I18n.tr("UTM", new Object[0]);
    }

    @Override
    public Collection<String> getPreferences(JPanel panel) {
        if (!(panel instanceof UTMPanel)) {
            throw new IllegalArgumentException("Unsupported panel: " + panel);
        }
        UTMPanel p = (UTMPanel)panel;
        int idx = p.prefcb.getSelectedIndex();
        TransverseMercator.Hemisphere hem = p.south.isSelected() ? TransverseMercator.Hemisphere.South : TransverseMercator.Hemisphere.North;
        return Arrays.asList(this.indexToZone(idx), hem.toString());
    }

    @Override
    public String[] allCodes() {
        ArrayList<CallSite> projections = new ArrayList<CallSite>(240);
        for (int zone = 1; zone <= 60; ++zone) {
            for (TransverseMercator.Hemisphere hem : TransverseMercator.Hemisphere.values()) {
                projections.add((CallSite)((Object)("EPSG:" + (32600 + zone + (hem == TransverseMercator.Hemisphere.South ? 100 : 0)))));
            }
        }
        return projections.toArray(new String[0]);
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        if (code.startsWith("EPSG:326") || code.startsWith("EPSG:327")) {
            try {
                TransverseMercator.Hemisphere hem = code.charAt(7) == '6' ? TransverseMercator.Hemisphere.North : TransverseMercator.Hemisphere.South;
                String zonestring = code.substring(8);
                int zoneval = Integer.parseInt(zonestring);
                if (zoneval > 0 && zoneval <= 60) {
                    return Arrays.asList(zonestring, hem.toString());
                }
            }
            catch (NumberFormatException e) {
                Logging.warn(e);
            }
        }
        return null;
    }

    @Override
    public void setPreferences(Collection<String> args) {
        String[] array;
        super.setPreferences(args);
        TransverseMercator.Hemisphere hem = DEFAULT_HEMISPHERE;
        if (args != null && (array = args.toArray(new String[0])).length > 1) {
            hem = TransverseMercator.Hemisphere.valueOf(array[1]);
        }
        this.hemisphere = hem;
    }

    @Override
    protected String indexToZone(int idx) {
        return Integer.toString(idx + 1);
    }

    @Override
    protected int zoneToIndex(String zone) {
        try {
            return Integer.parseInt(zone) - 1;
        }
        catch (NumberFormatException e) {
            Logging.warn(e);
            return this.defaultIndex;
        }
    }

    static {
        for (int i = 1; i <= 60; ++i) {
            cbEntries.add(Integer.toString(i));
        }
    }

    private class UTMPanel
    extends ListProjectionChoice.CBPanel {
        public JRadioButton north;
        public JRadioButton south;

        UTMPanel(String[] entries, int initialIndex, String label, ActionListener listener) {
            super(entries, initialIndex, label, listener);
            this.north = new JRadioButton();
            this.north.setSelected(UTMProjectionChoice.this.hemisphere == TransverseMercator.Hemisphere.North);
            this.south = new JRadioButton();
            this.south.setSelected(UTMProjectionChoice.this.hemisphere == TransverseMercator.Hemisphere.South);
            ButtonGroup group = new ButtonGroup();
            group.add(this.north);
            group.add(this.south);
            JPanel bPanel = new JPanel(new GridBagLayout());
            bPanel.add((Component)new JLabel(I18n.tr("North", new Object[0])), GBC.std().insets(5, 5, 0, 5));
            bPanel.add((Component)this.north, GBC.std().fill(2));
            bPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
            bPanel.add((Component)new JLabel(I18n.tr("South", new Object[0])), GBC.std().insets(5, 5, 0, 5));
            bPanel.add((Component)this.south, GBC.std().fill(2));
            bPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
            this.add((Component)new JLabel(I18n.tr("Hemisphere", new Object[0])), GBC.std().insets(5, 5, 0, 5));
            this.add(GBC.glue(1, 0), GBC.std().fill(2));
            this.add((Component)bPanel, GBC.eop().fill(2));
            this.add(GBC.glue(1, 1), GBC.eol().fill(1));
            if (listener != null) {
                this.north.addActionListener(listener);
                this.south.addActionListener(listener);
            }
        }
    }
}

