/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import com.sun.xml.registry.uddi.infomodel.KeyImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.uddi.infomodel.URIValidatorImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;

public class ExternalLinkImpl
extends RegistryObjectImpl
implements ExternalLink,
Serializable {
    private ArrayList registryObjects;
    private String externalURI;
    private URIValidatorImpl validator = new URIValidatorImpl();
    private RegistryObject parent;

    public ExternalLinkImpl() throws JAXRException {
        this.registryObjects = new ArrayList();
    }

    public ExternalLinkImpl(String uri) throws JAXRException {
        this();
        this.setExternalURI(uri);
    }

    public ExternalLinkImpl(String uri, String description) throws JAXRException {
        this(uri);
        this.description = new InternationalStringImpl(description);
    }

    public Collection getLinkedObjects() throws JAXRException {
        return (Collection)this.registryObjects.clone();
    }

    public void setValidateURI(boolean validate) throws JAXRException {
        this.validator.setValidateURI(validate);
    }

    public boolean getValidateURI() {
        return this.validator.getValidateURI();
    }

    public String getExternalURI() throws JAXRException {
        return this.externalURI;
    }

    public void setExternalURI(String externalUri) throws JAXRException {
        this.validator.validate(externalUri);
        this.externalURI = externalUri;
        this.setIsModified(true);
    }

    void addLinkedObject(RegistryObject registryObject) {
        this.registryObjects.add(registryObject);
    }

    @Override
    public Key getKey() throws JAXRException {
        Iterator iter = this.registryObjects.iterator();
        if (iter.hasNext()) {
            RegistryObjectImpl rObject = (RegistryObjectImpl)iter.next();
            int sequenceId = rObject.getSequenceId(this);
            return new KeyImpl(this.externalURI + ":" + sequenceId);
        }
        return null;
    }

    void setParent(RegistryObject object) {
        this.parent = object;
    }
}

